/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.Date;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.BuildsInfo;
import org.appwork.storage.FailLevel;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateCondition2;
import org.appwork.storage.StorableValidateRegex;
import org.appwork.storage.StorableValidationLogic;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.LocaleMap;
import org.appwork.updatesys.transport.exchange.BooleanTristate;
import org.appwork.updatesys.transport.exchange.Exec;
import org.appwork.updatesys.transport.exchange.FailedAction;
import org.appwork.updatesys.transport.exchange.SearchAndReplace;
import org.appwork.utils.StringUtils;

@StorableDoc(value="*.clientoptions files can be generated via \"AdminTool CLI\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Cli")
@StorableValidateCondition(value="{\u00a7eq:null}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Must not be null but a valid ClientOption JSON")
@StorableValidateCondition2(value="{\u00a7nondefaults:{\u00a7size:0}}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Must not be an empty object")
@AllowNonStorableObjects(value={Date.class})
public class ClientOptions
implements Storable {
    public static final TypeRef<ClientOptions> TYPE = new TypeRef<ClientOptions>(ClientOptions.class){};
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="If enabled, the client will delete the referenced file after executing the ClientOptions. Warning: The server does not know about this deletion and will continue to use this file for \"Deduplication\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Deduplication and \"Jar-Diff\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Jar_diff")
    private BooleanTristate deleteAfterClientOptions = BooleanTristate.NOTSET;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="If enabled, the client will mark the referenced file as an executable file (This is mainly used on Linux and MAC)")
    private BooleanTristate executable = BooleanTristate.NOTSET;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="*For signed Connect Service Packages only!* if enabled, the package will be executed in the Connect-Self-Update SELF-TEST process via \"Connect-Service\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Connect_Service")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes' instead.")
    @Deprecated
    private BooleanTristate executeSelfTestService = BooleanTristate.NOTSET;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="*For signed Connect Service Packages only!* if enabled, the package will be executed in the Connect-Self-Update SELF-TEST process by asking the user for Permission Elevation (Admin/UAC). If enabled, the client will always try to execute via \"Connect-Service\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Connect_Service first")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes' instead.")
    @Deprecated
    private BooleanTristate executeSelfTestServiceFallback = BooleanTristate.NOTSET;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="*For signed Connect Service Packages only!* if enabled, the package will be executed during the regular package installation via \"Connect-Service\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Connect_Service")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes' instead.")
    @Deprecated
    private BooleanTristate executeService = BooleanTristate.NOTSET;
    @StorableValidateCondition(value="{\u00a7ne:null}", description="Must not be null but on of TRUE|FALSE|UNSET")
    @StorableDoc(value="*For signed Connect Service Packages only!* if enabled, the package will be executed during the regular package installation by asking the user for Permission Elevation (Admin/UAC). If enabled, the client will always try to execute via \"Connect-Service\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Connect_Service first")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes' instead.")
    @Deprecated
    private BooleanTristate executeServiceFallback = BooleanTristate.NOTSET;
    @StorableDoc(value="Defines a regular expression that is matched against the outputs of installCMDLine or Connect Service executes. The step will fail if the regular expression cannot be found in stdout or stderr. If no regular expression is given, the client will use the default: Connect Service:Connect-Service-Result:Success; CMDLine:.?")
    @StorableValidateRegex(message="Must be null or a valid regular expression", nullAllowed=true)
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes[*].resultMapping' instead.")
    @Deprecated
    private String executionSuccessRegex;
    @StorableDoc(value="Define how to handle a installation step error. IGNORE or REVERT all changes")
    private FailedAction failedAction = null;
    @StorableDoc(value="A Commandline that will get executed when the file or the clientoptions file changes. Placeholders: %filepath% (path to referenced file), %fileparentpath%, %connectpath% (path to ConnectM.jar),%javabinary% (Path to Connect java binary),%selftest% (true if the calling client is in self-test mode). Enviromental Variables: Connect-java,Connect-path,Connect-selftest\r\n\r\nWarning: The run-in directory is always the parent of the *.clientOptions file. Always define the path to the executable absolute. Use the placeholder properties if required. \"Dynamic Path Links\":https://projects.appwork.org/projects/connect-system-documentation/wiki/Dynamic_Link_pathes are supported as well (Since 19.05.2022)")
    @StorableValidateCondition(value="{\u00a7or:[{\u00a7eq:[]},{\u00a7exists:true,\u00a7ne:null,\u00a7in:[null,\"\"]}]}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Commandline list must contain at least one entry, but no empty or null entries")
    @StorableValidateCondition2(level=FailLevel.WARNING, value="{\u00a7\u00a7this:{\u00a7ne:null},\u00a7parent.getProcessResultMapping:null,\u00a7parent.executionSuccessRegex:null}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Also set \r\n'executionSuccessRegex' for Connect Clients < 27.06.2022 and \r\n'processResultMapping' for Connect Clients > 27.06.2022")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'executes' instead.")
    @Deprecated
    private String[] installCMDLine = null;
    @StorableDoc(value="The name for a clientoption. It will be shown while the ClientOptions is applied.")
    @StorableValidateCondition(level=FailLevel.WARNING, value="{\u00a7\u00a7parent.installCMDLine:{\u00a7exists:true,\u00a7ne:null},\u00a7\u00a7this:null}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Define a readable name for  the process in 'installCMDLine'")
    @StorableDeprecatedSince(value="2022-06-27T17:42+0200", message="Use 'localizedName' instead.")
    @Deprecated
    private String name;
    @StorableAvailableSince(value="2022-06-27T17:42+0200", message="Use 'name' if the target Connect Client Buildtime is lower, or both.")
    @StorableDoc(value="The name for a clientoption. It will be shown while the ClientOptions is applied.")
    @StorableValidateCondition(level=FailLevel.WARNING, value="{\u00a7\u00a7parent.installCMDLine:{\u00a7exists:true,\u00a7ne:null},\u00a7\u00a7this:null}", logic=StorableValidationLogic.FAIL_ON_MATCH, description="Define a readable localizedName for  the process in 'installCMDLine'")
    private LocaleMap localizedName;
    @StorableDoc(value="Execute a Script, Connect Service package or commandline")
    @StorableAvailableSince(value="2022-06-27T17:42+0200", message="use installCMDLine or execute*Service for older clients")
    private Exec[] executes;
    @StorableAvailableSince(value="2023-06-24T00:00+0200")
    @StorableDoc(value="A list of search and replace instructions")
    private SearchAndReplace[] searchAndReplaces;
    private BuildsInfo targetBuilds;

    public Exec[] getExecutes() {
        return this.executes;
    }

    public void setExecutes(Exec[] executes) {
        this.executes = executes;
    }

    public LocaleMap getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(LocaleMap localizedName) {
        this.localizedName = localizedName;
    }

    public SearchAndReplace[] getSearchAndReplaces() {
        return this.searchAndReplaces;
    }

    public void setSearchAndReplaces(SearchAndReplace[] searchAndReplaces) {
        this.searchAndReplaces = searchAndReplaces;
    }

    @StorableAvailableSince(value="2023-02-24T16:26+0200")
    @StorableDoc(value="Information about the target Clients this configuration should be used with. ")
    public BuildsInfo getTargetBuilds() {
        return this.targetBuilds;
    }

    public void setTargetBuilds(BuildsInfo clientInfo) {
        this.targetBuilds = clientInfo;
    }

    public ClientOptions clone() {
        ClientOptions ret = new ClientOptions();
        if (this.executable != null) {
            ret.executable = this.executable;
        }
        if (this.searchAndReplaces != null) {
            ret.searchAndReplaces = this.searchAndReplaces;
        }
        if (this.installCMDLine != null && this.installCMDLine.length > 0) {
            ret.installCMDLine = this.installCMDLine;
        }
        if (this.deleteAfterClientOptions != null) {
            ret.deleteAfterClientOptions = this.deleteAfterClientOptions;
        }
        if (this.executeService != null) {
            ret.executeService = this.executeService;
        }
        if (this.executeServiceFallback != null) {
            ret.executeServiceFallback = this.executeServiceFallback;
        }
        if (this.executeSelfTestService != null) {
            ret.executeSelfTestService = this.executeSelfTestService;
        }
        if (this.executeSelfTestServiceFallback != null) {
            ret.executeSelfTestServiceFallback = this.executeSelfTestServiceFallback;
        }
        if (this.name != null) {
            ret.name = this.name;
        }
        if (this.localizedName != null) {
            ret.localizedName = this.localizedName;
        }
        if (this.executionSuccessRegex != null) {
            ret.executionSuccessRegex = this.executionSuccessRegex;
        }
        if (this.executes != null) {
            ret.executes = this.executes;
        }
        if (this.failedAction != null) {
            ret.failedAction = this.failedAction;
        }
        return ret;
    }

    public BooleanTristate getDeleteAfterClientOptions() {
        return BooleanTristate.valueOf(this.deleteAfterClientOptions);
    }

    public BooleanTristate getExecutable() {
        return BooleanTristate.valueOf(this.executable);
    }

    @Deprecated
    public BooleanTristate getExecuteSelfTestService() {
        return BooleanTristate.valueOf(this.executeSelfTestService);
    }

    @Deprecated
    public BooleanTristate getExecuteSelfTestServiceFallback() {
        return BooleanTristate.valueOf(this.executeSelfTestServiceFallback);
    }

    @Deprecated
    public BooleanTristate getExecuteService() {
        return BooleanTristate.valueOf(this.executeService);
    }

    @Deprecated
    public BooleanTristate getExecuteServiceFallback() {
        return BooleanTristate.valueOf(this.executeServiceFallback);
    }

    @Deprecated
    public String getExecutionSuccessRegex() {
        return this.executionSuccessRegex;
    }

    public FailedAction getFailedAction() {
        if (this.failedAction == null) {
            return FailedAction.REVERT;
        }
        return this.failedAction;
    }

    @Deprecated
    public String[] getInstallCMDLine() {
        return this.installCMDLine;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public void setDeleteAfterClientOptions(BooleanTristate deleteAfterClientOptions) {
        this.deleteAfterClientOptions = BooleanTristate.valueOf(deleteAfterClientOptions);
    }

    public void setExecutable(BooleanTristate executable) {
        this.executable = BooleanTristate.valueOf(executable);
    }

    @Deprecated
    public void setExecuteSelfTestService(BooleanTristate executeSelfTestService) {
        this.executeSelfTestService = BooleanTristate.valueOf(executeSelfTestService);
    }

    @Deprecated
    public void setExecuteSelfTestServiceFallback(BooleanTristate executeSelfTestServiceFallback) {
        this.executeSelfTestServiceFallback = executeSelfTestServiceFallback;
    }

    @Deprecated
    public void setExecuteService(BooleanTristate executeService) {
        this.executeService = BooleanTristate.valueOf(executeService);
    }

    @Deprecated
    public void setExecuteServiceFallback(BooleanTristate executeServiceFallback) {
        this.executeServiceFallback = executeServiceFallback;
    }

    @Deprecated
    public void setExecutionSuccessRegex(String installCMDSuccessRegex) {
        this.executionSuccessRegex = installCMDSuccessRegex;
    }

    public void setFailedAction(FailedAction executeFailedAction) {
        this.failedAction = executeFailedAction;
    }

    @Deprecated
    public void setInstallCMDLine(String[] install) {
        this.installCMDLine = install;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public void write(ClientOptions clientOptions) {
        if (!BooleanTristate.NOTSET.equals((Object)this.getExecutable())) {
            this.executable = clientOptions.executable;
        }
        if (!BooleanTristate.NOTSET.equals((Object)this.getExecuteService())) {
            this.executeService = clientOptions.executeService;
        }
        if (!BooleanTristate.NOTSET.equals((Object)this.getExecuteServiceFallback())) {
            this.executeServiceFallback = clientOptions.executeServiceFallback;
        }
        if (!BooleanTristate.NOTSET.equals((Object)this.getExecuteSelfTestService())) {
            this.executeSelfTestService = clientOptions.executeSelfTestService;
        }
        if (!BooleanTristate.NOTSET.equals((Object)this.getExecuteSelfTestServiceFallback())) {
            this.executeSelfTestServiceFallback = clientOptions.executeSelfTestServiceFallback;
        }
        if (!BooleanTristate.NOTSET.equals((Object)this.getDeleteAfterClientOptions())) {
            this.deleteAfterClientOptions = clientOptions.deleteAfterClientOptions;
        }
        if (clientOptions.installCMDLine != null && clientOptions.installCMDLine.length > 0) {
            this.installCMDLine = clientOptions.installCMDLine;
        }
        if (clientOptions.executionSuccessRegex != null) {
            this.executionSuccessRegex = clientOptions.executionSuccessRegex;
        }
        if (clientOptions.executes != null) {
            this.executes = clientOptions.executes;
        }
        if (clientOptions.searchAndReplaces != null) {
            this.searchAndReplaces = clientOptions.searchAndReplaces;
        }
        if (clientOptions.name != null) {
            this.name = clientOptions.name;
        }
        if (clientOptions.localizedName != null) {
            this.localizedName = clientOptions.localizedName;
        }
        if (clientOptions.failedAction != null) {
            this.failedAction = clientOptions.failedAction;
        }
    }

    public String _getLocalizedName(String fallback) {
        String ret;
        if (this.localizedName == null) {
            ret = this.getName();
        } else {
            if (this.localizedName.get("en") == null) {
                this.localizedName.put("en", this.name);
            }
            ret = this.localizedName.resolve();
        }
        if (StringUtils.isEmpty(ret)) {
            ret = fallback;
        }
        return ret;
    }
}

