/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport;

import java.util.ArrayList;
import java.util.List;
import org.appwork.storage.JSonStorage;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.transport.Pkg;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.IDsResponse;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.batch.JobResponse;
import org.appwork.updatesys.transport.exchange.interfaces.IDsResponseInterface;
import org.appwork.updatesys.transport.exchange.json.IDsJsonResponse;
import org.appwork.updatesys.transport.exchange.json.ServerJsonResponse;
import org.appwork.utils.ExtIOException;

public class Ids
extends Pkg {
    protected IDsResponseInterface idsResponse = null;

    public IDsResponseInterface getIdsResponse() {
        return this.idsResponse;
    }

    public Ids(UpdateClient updateClient) throws ExtIOException {
        super(updateClient);
    }

    @Override
    protected void initOptionals(UpdateClient updateClient) throws ExtIOException {
        this.optionalRequestsInstall = new ArrayList();
        this.optionalRequestsUninstall = new ArrayList();
    }

    @Override
    public List<String> getEidList() throws ExtIOException {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getEipList() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getEirList() {
        return new ArrayList<String>();
    }

    @Override
    public String getEidUrlParameter() throws ExtIOException {
        return "";
    }

    @Override
    public String getEipUrlParameter() {
        return "";
    }

    @Override
    public String getEirUrlParameter() {
        return "";
    }

    public String[] list() {
        IDsResponseInterface idsResponse = this.getIdsResponse();
        if (idsResponse != null) {
            if (idsResponse.getIds() != null) {
                return idsResponse.getIds().toArray(new String[0]);
            }
            return new String[0];
        }
        return null;
    }

    @Override
    public String getResumeUrlParameter() {
        return null;
    }

    @Override
    protected boolean onServerResonse(ResponseStatus status, String[] lines) throws TransportException, ExtIOException, InterruptedException {
        if (ResponseStatus.IDS.equals((Object)status) && lines != null) {
            try {
                this.idsResponse = new IDsResponse(lines);
                this.serverResponse = this.idsResponse;
                return true;
            }
            catch (NumberFormatException e) {
                throw new TransportException(e);
            }
        }
        return false;
    }

    @Override
    protected boolean onServerJsonResponse(ResponseStatus status, ServerJsonResponse jsonResponse, String responseString) throws TransportException, ExtIOException, InterruptedException {
        if (jsonResponse != null && ResponseStatus.IDS.equals((Object)status)) {
            this.idsResponse = JSonStorage.restoreFromString(responseString, IDsJsonResponse.TYPEREF);
            this.serverResponse = this.idsResponse;
            return true;
        }
        return false;
    }

    @Override
    public boolean parseJobResponse(JobResponse response) throws ExtIOException, TransportException, InterruptedException {
        try {
            switch (ResponseStatus.valueOf(response.getName())) {
                case IDS: {
                    this.parseServerResponse(response.getJson().getBytes(Pkg.UTF8));
                    return true;
                }
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

