/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.List;
import java.util.Random;
import org.appwork.testframework.AWTest;
import org.appwork.updatesys.transport.exchange.ZipSignature;
import org.appwork.utils.Files;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.zip.tests.OnClassPathZipJarTests;

public class ZipSignatureTest
extends OnClassPathZipJarTests {
    public static void main(String[] args) {
        AWTest.run();
    }

    @Override
    public void runTest() throws Exception {
        KeyPair keyPair = AWSign.createKeyPair();
        KeyPair keyPair2 = AWSign.createKeyPair();
        List<File> testZips = this.getZipJarFilesFromClassPath();
        for (File testZip : testZips) {
            for (ZipSignature.COMPRESSION compression : ZipSignature.COMPRESSION.values()) {
                this.testZipSignature(compression, testZip, keyPair, keyPair2);
            }
        }
    }

    protected void testZipSignature(final ZipSignature.COMPRESSION compression, File zipFile, KeyPair keyPair, KeyPair keyPair2) throws Exception {
        int revision = new Random().nextInt(10000);
        String rel = Files.getRelativePath(zipFile.getParentFile(), zipFile);
        Exception e = null;
        ZipSignature zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected ZipSignature.COMPRESSION getCompressionMode(String entry) {
                if (entry == null) {
                    return compression;
                }
                return super.getCompressionMode(entry);
            }
        };
        final byte[] signature = zipSignature.create(keyPair.getPrivate());
        System.out.println("ZipSignature for file=" + zipFile + " is size=" + signature.length + " with compression=" + (Object)((Object)compression));
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        zipSignature.verify(keyPair.getPublic());
        try {
            e = null;
            zipSignature.verify(keyPair2.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "container signature verification failed");
        try {
            e = null;
            zipSignature.verify(null);
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "container signature verification failed");
        zipSignature = new ZipSignature(zipFile, revision + 1, rel){

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "container signature verification failed");
        zipSignature = new ZipSignature(zipFile, revision, rel + "WTF"){

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "container signature verification failed");
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected List<String> parseContentCatalogV1(InputStream is) throws IOException {
                List<String> ret = super.parseContentCatalogV1(is);
                ret.remove(ret.size() - 1);
                return ret;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertTrue(e.getMessage().contains("but no more entries are expected!"));
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected List<String> parseContentCatalogV1(InputStream is) throws IOException {
                List<String> ret = super.parseContentCatalogV1(is);
                ret.add("WTF");
                return ret;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertTrue(e.getMessage().contains("missing entries"));
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected List<String> parseContentCatalogV1(InputStream is) throws IOException {
                List<String> ret = super.parseContentCatalogV1(is);
                ret.set(0, ret.get(1 + new Random().nextInt(ret.size() - 1)));
                return ret;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertTrue(e.getMessage().contains("but current="));
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected byte[] parseContentHashV1(InputStream is) throws IOException {
                return null;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "no valid signature found");
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected byte[] parseContentHashV1(InputStream is) throws IOException {
                byte[] ret = super.parseContentHashV1(is);
                new Random().nextBytes(ret);
                return ret;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "content hash v1 verification failed!");
        zipSignature = new ZipSignature(zipFile, revision, rel){

            @Override
            protected List<String> parseContentCatalogV1(InputStream is) throws IOException {
                return null;
            }

            @Override
            public byte[] readSignature() throws IOException {
                return signature;
            }
        };
        try {
            e = null;
            zipSignature.verify(keyPair.getPublic());
        }
        catch (Exception e2) {
            e = e2;
        }
        AWTest.assertNotNull(e);
        AWTest.assertEquals(SignatureViolationException.class, e.getClass());
        AWTest.assertEquals(e.getMessage(), "no valid signature found");
    }
}

