/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.tests;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.testframework.AWTest;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.DefaultFileAccessNIOHandler;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.utils.Application;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.IO;
import org.appwork.utils.extioexceptions.CouldNotRenameFile;
import org.appwork.utils.extioexceptions.CouldNotWriteFileExtIOException;
import org.appwork.utils.extioexceptions.FileNotFoundExtIOException;

public class TestFileSystem
extends AWTest {
    private static FileAccessHandler fs;
    private static List<File> CLEANUP;
    private static int COUNTER;

    public static void main(String[] args) throws Exception {
        AWTest.run();
    }

    private static void testSecureWrite() throws ExtIOException, UnsupportedEncodingException, IOException {
        try {
            fs.secureWrite(TestFileSystem.createExistingFileWithContent(), "test".getBytes(), false);
            throw new WTFException();
        }
        catch (CouldNotWriteFileExtIOException couldNotWriteFileExtIOException) {
            fs.secureWrite(TestFileSystem.createExistingFileWithContent(), "test".getBytes(), true);
            fs.secureWrite(TestFileSystem.createNonExistinghPath(), "test".getBytes(), true);
            fs.secureWrite(TestFileSystem.createNonExistinghPath(), "test".getBytes(), true);
            return;
        }
    }

    protected static void testMoveFile() throws ExtIOException, InterruptedException, UnsupportedEncodingException, IOException {
        fs.moveFile(TestFileSystem.createExistingFileWithContent(), TestFileSystem.createNonExistinghPath(), false);
        try {
            File a = TestFileSystem.createExistingFileWithContent();
            File b = TestFileSystem.createExistingFileWithContent();
            fs.moveFile(a, b, false);
            throw new WTFException();
        }
        catch (CouldNotRenameFile couldNotRenameFile) {
            fs.moveFile(TestFileSystem.createExistingFileWithContent(), TestFileSystem.createExistingFileWithContent(), true);
            try {
                fs.moveFile(TestFileSystem.createNonExistinghPath(), TestFileSystem.createExistingFileWithContent(), true);
                throw new WTFException();
            }
            catch (FileNotFoundExtIOException fileNotFoundExtIOException) {
                return;
            }
        }
    }

    private static File createNonExistinghPath() {
        File file = Application.generateNumberedTempResource("test " + COUNTER++);
        if (file.exists()) {
            throw new WTFException(file.getAbsolutePath());
        }
        CLEANUP.add(file);
        return file;
    }

    private static File createExistingFileWithContent() throws UnsupportedEncodingException, IOException {
        File file = Application.generateNumberedTempResource("test " + COUNTER++);
        IO.secureWrite(file, "test".getBytes("UTF-8"), IO.SYNC.META_AND_DATA);
        if (!file.isFile()) {
            throw new WTFException(file.getAbsolutePath());
        }
        CLEANUP.add(file);
        return file;
    }

    @Override
    public void runTest() throws Exception {
        try {
            Application.setApplication(".tests");
            fs = new DefaultFileAccessHandler(null);
            TestFileSystem.testMoveFile();
            TestFileSystem.testSecureWrite();
            fs = new DefaultFileAccessNIOHandler(null);
            TestFileSystem.testMoveFile();
            TestFileSystem.testSecureWrite();
        }
        finally {
            for (File clean : CLEANUP) {
                if (clean.delete() || !clean.isFile()) continue;
                clean.deleteOnExit();
            }
        }
    }

    static {
        CLEANUP = new CopyOnWriteArrayList<File>();
        COUNTER = 0;
    }
}

