/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.serveroptions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.client.FailedActionException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.extensions.CompiledServerOptions;
import org.appwork.updatesys.transport.exchange.UpdateSignature;

public class ServerOptionsManager {
    protected HashMap<String, String> all;
    protected HashMap<String, String> newEntries;
    protected HashMap<String, String> removedEntries;
    protected final UpdateClient updateClient;

    public ServerOptionsManager(UpdateClient updateClient) {
        this.updateClient = updateClient;
    }

    protected synchronized void addOrReplaceServerOption(String path, String str) {
        String old = this.all.put(path, str);
        this.newEntries.put(path, old);
    }

    public synchronized CompiledServerOptions compile() {
        return new CompiledServerOptions(this);
    }

    public synchronized Map<String, String> getAll() {
        if (this.all == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.all);
    }

    public synchronized Map<String, String> getNewEntries() {
        if (this.newEntries == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.newEntries);
    }

    public synchronized Map<String, String> getRemovedEntries() {
        if (this.removedEntries == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.removedEntries);
    }

    public UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    public synchronized void init() throws IOException {
        File file = this.getStorageFile();
        try {
            if (file.isFile()) {
                this.all = JSonStorage.restoreFromString(this.getUpdateClient().getFileSystem().secureReadFileToString(file), TypeRef.HASHMAP_STRING);
            }
        }
        catch (Exception e) {
            this.getUpdateClient().getLogger().log(e);
        }
        if (this.all == null) {
            this.all = new HashMap();
        }
        this.newEntries = new HashMap();
        this.removedEntries = new HashMap();
    }

    public void installServerOption(InputStream input, String relPath, final String signature, int destRev) throws FailedActionException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            DigestInputStream is = new DigestInputStream(input, md);
            final String str = UpdateClient.readEntry(is);
            final byte[] sha256 = is.getMessageDigest().digest();
            new UpdateSignature(null, destRev, relPath){

                @Override
                public InputStream getInputstream() throws IOException {
                    return new ByteArrayInputStream(str.getBytes("UTF-8"));
                }

                @Override
                public byte[] getSHA256() throws IOException {
                    return sha256;
                }

                @Override
                public boolean isFile() {
                    return true;
                }

                @Override
                public String readSignatureString() throws IOException {
                    return signature;
                }
            }.verify(this.getUpdateClient().getPublicKey());
            this.addOrReplaceServerOption(relPath.substring(0, relPath.length() - ".serverOptions".length()), str);
        }
        catch (Exception e) {
            throw FailedActionException.wrap(this.getUpdateClient(), e);
        }
    }

    public synchronized void removeServerOption(String path) {
        String old = this.all.remove(path);
        if (old != null) {
            this.removedEntries.put(path, old);
        }
    }

    protected File getStorageFile() {
        return this.getUpdateClient().getPathBuilder().getServerOptionsFilePath(this.getUpdateClient());
    }

    public void save() throws IOException {
        File file = this.getStorageFile();
        this.save(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(File file) throws IOException {
        byte[] bytes;
        ServerOptionsManager serverOptionsManager = this;
        synchronized (serverOptionsManager) {
            bytes = JSonStorage.serializeToJsonByteArray(this.all);
        }
        this.getUpdateClient().getFileSystem().secureWrite(file, bytes, true);
    }
}

