/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.security.NoSuchAlgorithmException;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.DeleteCallback;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;

public class ReplaceExistingFileInstallAction
extends InstallerAction {
    public static final String ID = "MODIFY";
    protected final String backup;
    protected final String restore;

    public ReplaceExistingFileInstallAction(String backup, String restore) {
        this.backup = backup;
        this.restore = restore;
    }

    public static ReplaceExistingFileInstallAction read(BufferedReader reader) throws IOException {
        return new ReplaceExistingFileInstallAction(reader.readLine(), reader.readLine());
    }

    public String getBackup() {
        return this.backup;
    }

    public String getRestore() {
        return this.restore;
    }

    @Override
    public void revert(UpdateClient client) throws RevertException, InterruptedException {
        AbsoluteFile dst;
        AbsoluteFile src;
        try {
            src = this.fromRelPath(client, this.getBackup());
            dst = this.fromRelPath(client, this.getRestore());
        }
        catch (CleanupException e1) {
            throw new RevertException(e1);
        }
        this.logger.info("Revert|Backup:" + src + "|Destination:" + dst);
        if (!src.exists()) {
            throw new RevertException(UpdTrans.I().getErrorCouldNotRestoreFILEAbecauseFILEBdoesNotExist(dst, src));
        }
        try {
            if (dst.exists()) {
                this.delete(dst, client);
                this.logger.info("Deleted|Destination:" + dst);
            }
        }
        catch (ExtIOException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
        }
        catch (RuntimeException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
        }
        FileAccessHandler fileSystem = client.getFileSystem();
        try {
            fileSystem.mkdirs(dst.getParentFile());
            fileSystem.moveFile(src, dst, false);
            this.logger.info("Reverted|" + dst);
        }
        catch (ExtIOException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
        }
        catch (RuntimeException e) {
            throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
        }
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String[] getParameters() {
        return new String[]{this.getBackup(), this.getRestore()};
    }

    @Override
    public void cleanup(UpdateClient client, final FileList fileList) throws CleanupException, InterruptedException {
        final AbsoluteFile toDelete = this.fromRelPath(client, this.getBackup());
        try {
            if (toDelete.exists()) {
                DeleteCallback callback = fileList == null ? null : new DeleteCallback(){

                    @Override
                    public void onDeleted(File file) throws ExtIOException, InterruptedException {
                        try {
                            AbsoluteFile child = toDelete.deriveFromChild(file);
                            fileList.removeFile(child);
                        }
                        catch (ClosedByInterruptException e) {
                            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                        }
                        catch (IOException e) {
                            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
                        }
                    }
                };
                this.delete(toDelete, client, callback);
            }
        }
        catch (ExtIOException e) {
            throw new CleanupException(e);
        }
        if (fileList != null) {
            try {
                AbsoluteFile newFile = this.fromRelPath(client, this.getRestore());
                if (newFile.exists()) {
                    fileList.addFile(newFile);
                }
            }
            catch (ClosedByInterruptException e) {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (IOException e) {
                throw new CleanupException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CleanupException(e);
            }
            catch (RuntimeException e) {
                throw new CleanupException(e);
            }
        }
    }
}

