/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.security.NoSuchAlgorithmException;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;

public class MergeJarFilesAction
extends InstallerAction {
    public static final String ID = "JARMERGE";
    protected final String backup;
    protected final String restore;

    public MergeJarFilesAction(String backup, String restore) {
        this.backup = backup;
        this.restore = restore;
    }

    public static MergeJarFilesAction read(BufferedReader reader) throws IOException {
        return new MergeJarFilesAction(reader.readLine(), reader.readLine());
    }

    public String getBackup() {
        return this.backup;
    }

    protected String getDiff() {
        return this.restore + ".updJarDiff";
    }

    public String getRestore() {
        return this.restore;
    }

    @Override
    public void revert(UpdateClient client) throws RevertException, InterruptedException {
        AbsoluteFile dst;
        AbsoluteFile diff;
        AbsoluteFile src;
        try {
            src = this.fromRelPath(client, this.getBackup());
            diff = this.fromRelPath(client, this.getDiff());
            dst = this.fromRelPath(client, this.getRestore());
        }
        catch (CleanupException e1) {
            throw new RevertException(e1);
        }
        this.logger.info("Revert|Backup:" + src + "|Destination:" + dst);
        FileAccessHandler fileSystem = client.getFileSystem();
        try {
            this.delete(diff, client);
        }
        catch (ExtIOException e1) {
            this.logger.log(new Exception("Swallow", e1));
        }
        if (!src.exists()) {
            if (!dst.exists()) {
                throw new RevertException(UpdTrans.I().getErrorCouldNotRestoreFILEAbecauseFILEBdoesNotExist(dst, src));
            }
            this.logger.info("Reverted?|" + dst);
        } else {
            try {
                if (dst.exists()) {
                    this.delete(dst, client);
                    this.logger.info("Deleted|Destination:" + dst);
                }
            }
            catch (ExtIOException e) {
                throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
            }
            catch (RuntimeException e) {
                throw new RevertException(e, UpdTrans.I().getErrorCouldNotDeleteFILE(dst));
            }
            try {
                fileSystem.mkdirs(dst.getParentFile());
                fileSystem.moveFile(src, dst, false);
                this.logger.info("Reverted|" + dst);
            }
            catch (ExtIOException e) {
                throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
            }
            catch (RuntimeException e) {
                throw new RevertException(e, UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dst));
            }
        }
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String[] getParameters() {
        return new String[]{this.getBackup(), this.getRestore()};
    }

    @Override
    public void cleanup(UpdateClient client, FileList fileList) throws CleanupException, InterruptedException {
        AbsoluteFile toDelete = this.fromRelPath(client, this.getBackup());
        try {
            client.getFileSystem().deleteFileIfExists(toDelete);
        }
        catch (ExtIOException e1) {
            throw new CleanupException("Could not cleanup backup files: " + toDelete, e1);
        }
        if (fileList != null) {
            try {
                AbsoluteFile file = this.fromRelPath(client, this.getRestore());
                if (file.exists()) {
                    fileList.addFile(file);
                }
            }
            catch (ClosedByInterruptException e) {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (IOException e) {
                throw new CleanupException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CleanupException(e);
            }
            catch (RuntimeException e) {
                throw new CleanupException(e);
            }
        }
    }
}

