/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.DeleteCallback;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.logging2.ConsoleLogImpl;
import org.appwork.utils.logging2.LogInterface;

public abstract class InstallerAction {
    private static final LogInterface DEFAULT_LOGGER = new ConsoleLogImpl();
    protected LogInterface logger = DEFAULT_LOGGER;

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder().append(this.getID());
        for (String s : this.getParameters()) {
            sb.append("\r\n");
            sb.append(s);
        }
        return sb.toString().hashCode();
    }

    protected AbsoluteFile fromRelPath(UpdateClient client, String relPath) throws CleanupException {
        try {
            return client.convertRelPath(relPath);
        }
        catch (InstallException e) {
            throw new CleanupException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallerAction) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    protected void delete(AbsoluteFile toDelete, UpdateClient client) throws ExtIOException, InterruptedException {
        this.delete(toDelete, client, null);
    }

    protected void delete(AbsoluteFile toDelete, UpdateClient client, DeleteCallback callback) throws ExtIOException, InterruptedException {
        client.deleteFileOrFolderRecursive(toDelete, callback, true);
    }

    public abstract void revert(UpdateClient var1) throws RevertException, InterruptedException;

    public abstract String getID();

    public abstract String[] getParameters();

    public abstract void cleanup(UpdateClient var1, FileList var2) throws CleanupException, InterruptedException;

    public String createUniqueID() {
        return null;
    }

    public void retryFailedcleanup(UpdateClient client, FileList filelist) throws CleanupException, InterruptedException {
        this.cleanup(client, filelist);
    }
}

