/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.install.DeleteFileOrFolderV1;
import org.appwork.updatesys.client.install.DeleteFileOrFolderV2;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.MergeJarFilesAction;
import org.appwork.updatesys.client.install.NewFileInstallAction;
import org.appwork.updatesys.client.install.ReplaceExistingFileInstallAction;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.ExtIOException;

public class BackupFileReader {
    private BufferedReader reader;
    private long size;
    private long loaded;

    public BackupFileReader(UpdateClient client, File file) throws UnsupportedEncodingException, MalformedURLException, ExtIOException, InterruptedException {
        this.size = file.length();
        this.loaded = 0L;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)client.getFileSystem().openFileInputStream(file), "UTF-8")){

            @Override
            public String readLine() throws IOException {
                String ret = super.readLine();
                if (ret != null) {
                    BackupFileReader backupFileReader = BackupFileReader.this;
                    backupFileReader.loaded = backupFileReader.loaded + (long)(ret.getBytes("UTF-8").length + 2);
                }
                return ret;
            }
        };
    }

    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public double getProgress() {
        return Math.min(1.0, (double)this.loaded / (double)this.size);
    }

    public InstallerAction read() throws IOException {
        String line = "";
        while ("".equals(line = this.reader.readLine())) {
        }
        if ("MODIFY".equals(line)) {
            return ReplaceExistingFileInstallAction.read(this.reader);
        }
        if ("NEW".equals(line)) {
            return NewFileInstallAction.read(this.reader);
        }
        if ("DELETE".equals(line)) {
            return DeleteFileOrFolderV1.read(this.reader);
        }
        if ("DELETE_V2".equals(line)) {
            return DeleteFileOrFolderV2.read(this.reader);
        }
        if ("JARMERGE".equals(line)) {
            return MergeJarFilesAction.read(this.reader);
        }
        String lastLineCheck = this.reader.readLine();
        if (lastLineCheck != null) {
            throw new ExtIOException(UpdTrans.I().getErrorUnknownEntry(), ExtIOException.IOExceptionType.LOCAL, lastLineCheck);
        }
        this.loaded = this.size;
        return null;
    }
}

