/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.extensions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appwork.storage.JSonStorage;
import org.appwork.updatesys.transport.exchange.ServerOptions;
import org.appwork.utils.StringUtils;

public class ServerOptionNode
extends HashMap<String, ServerOptionNode> {
    private final String name;
    private ServerOptions serverOptions;
    private ServerOptionNode parent;

    public ServerOptionNode getParent() {
        return this.parent;
    }

    public ServerOptions getServerOptions() {
        return this.serverOptions;
    }

    public ServerOptionNode(String s) {
        this.name = s;
    }

    protected ServerOptions merge(ServerOptions child, ServerOptions parent) {
        return ServerOptions.merge(child, parent);
    }

    public ServerOptionNode getOrCreate(String s) {
        ServerOptionNode ret = (ServerOptionNode)super.get(s);
        if (ret == null) {
            ret = new ServerOptionNode(s);
            ret.setParent(this);
            ret.setServerOptions(this.getServerOptions());
            this.put(s, ret);
        }
        return ret;
    }

    public String toPath() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> path = new ArrayList<String>();
        ServerOptionNode node = this;
        do {
            path.add(0, node.getName());
        } while ((node = node.getParent()) != null);
        for (String s : path) {
            sb.append(File.separator);
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.fillPost(this.toPath(), " ", 128)).append(" = ");
        sb.append(JSonStorage.toString(this.getServerOptions())).append("\r\n");
        for (Map.Entry s : this.entrySet()) {
            sb.append(((ServerOptionNode)s.getValue()).toString());
        }
        return sb.toString();
    }

    private String getName() {
        return this.name;
    }

    private void setParent(ServerOptionNode serverOptionNode) {
        this.parent = serverOptionNode;
    }

    public void setServerOptions(ServerOptions so) {
        this.serverOptions = so;
        for (Map.Entry e : this.entrySet()) {
            ((ServerOptionNode)e.getValue()).setServerOptions(this.merge(((ServerOptionNode)e.getValue()).getServerOptions(), so));
        }
    }
}

