/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.extensions;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.extensions.AbstractExtensionManager;
import org.appwork.updatesys.client.extensions.ExtensionsStorage;
import org.appwork.utils.ExtIOException;

public class ExtensionManager
extends AbstractExtensionManager {
    protected ExtensionsStorage settings = null;
    protected final Set<String> requestedInstalls = new CopyOnWriteArraySet<String>();
    protected final Set<String> installed = new CopyOnWriteArraySet<String>();
    protected final Set<String> requestedUninstalls = new CopyOnWriteArraySet<String>();

    public ExtensionManager(UpdateClient updateClient) throws IOException {
        super(updateClient, updateClient.getLogger());
        this.init();
    }

    @Override
    public synchronized void uninstall() {
        HashSet<String> requests = new HashSet<String>();
        requests.addAll(this.installed);
        requests.addAll(this.requestedInstalls);
        this.installed.clear();
        this.requestedInstalls.clear();
        this.requestedUninstalls.clear();
        this.requestedInstalls.addAll(requests);
        this.writeInstalled();
        this.writeRequestedInstalls();
        this.writeRequestedUninstalls();
    }

    protected synchronized void markInstalled(String id) {
        if ((id = this.toLowerCase(id)) != null) {
            if (this.installed.add(id)) {
                this.writeInstalled();
            }
            if (this.requestedInstalls.remove(id)) {
                this.writeRequestedInstalls();
            }
        }
    }

    protected synchronized void markUninstalled(String id) {
        if ((id = this.toLowerCase(id)) != null) {
            if (this.installed.remove(id)) {
                this.writeInstalled();
            }
            if (this.requestedUninstalls.remove(id)) {
                this.writeRequestedUninstalls();
            }
        }
    }

    public void init() throws IOException {
        this.settings = JsonConfig.create(this.getUpdateClient().getPathBuilder().getOptionalConfigPath(this.getUpdateClient()), ExtensionsStorage.class);
        this.settings._getStorageHandler().setSaveInShutdownHookEnabled(false);
        this.settings._getStorageHandler().setAllowWriteDefaultObjects(false);
        String[] i = this.settings.getInstalled();
        String[] ri = this.settings.getRequestedInstalls();
        String[] rui = this.settings.getRequestedUninstalls();
        if (i != null) {
            for (String s : i) {
                if (s == null) continue;
                this.installed.add(s);
            }
        }
        this.getLogger().info("Installed Extensions: " + this.installed);
        if (ri != null) {
            for (String s : ri) {
                if (s == null || !this.canInstall(s)) continue;
                this.requestedInstalls.add(s);
            }
        }
        this.getLogger().info("Requested Extension Installations: " + this.requestedInstalls);
        if (rui != null) {
            for (String s : rui) {
                if (s == null || !this.canUninstall(s)) continue;
                this.requestedUninstalls.add(s);
            }
        }
        this.getLogger().info("Requested Extension Uninstalls: " + this.requestedUninstalls);
    }

    public synchronized boolean canInstall(String s) {
        return !this.installed.contains(s);
    }

    public synchronized boolean canUninstall(String s) {
        return this.installed.contains(s) || this.requestedInstalls.contains(s);
    }

    protected synchronized void requestFreshInstall(String id) {
        if ((id = this.toLowerCase(id)) != null) {
            this.markUninstalled(id);
            if (this.requestedInstalls.add(id)) {
                this.writeRequestedInstalls();
            }
        }
    }

    @Override
    public Set<String> getRequestedInstalls() {
        return Collections.unmodifiableSet(this.requestedInstalls);
    }

    @Override
    public Set<String> getRequestedUninstalls() {
        return Collections.unmodifiableSet(this.requestedUninstalls);
    }

    @Override
    public Set<String> getInstalled() {
        return Collections.unmodifiableSet(this.installed);
    }

    public boolean isInstalled(String id) {
        return (id = this.toLowerCase(id)) != null && this.installed.contains(id);
    }

    public synchronized void requestInstallation(String s, boolean clearUninstallRequest) {
        s = this.toLowerCase(s);
        this.requestInstallation(s);
        if (clearUninstallRequest) {
            this.requestedUninstalls.remove(s);
            this.writeRequestedUninstalls();
        }
    }

    public synchronized void requestInstallation(String s) {
        if ((s = this.toLowerCase(s)) != null && this.canInstall(s) && this.requestedInstalls.add(s)) {
            this.writeRequestedInstalls();
        }
    }

    private final String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.ENGLISH);
    }

    protected synchronized void writeRequestedInstalls() {
        this.settings.setRequestedInstalls(this.requestedInstalls.toArray(new String[0]));
        this.settings._getStorageHandler().setSaveInShutdownHookEnabled(true);
    }

    protected synchronized void writeRequestedUninstalls() {
        this.settings.setRequestedUninstalls(this.requestedUninstalls.toArray(new String[0]));
        this.settings._getStorageHandler().setSaveInShutdownHookEnabled(true);
    }

    protected synchronized void writeInstalled() {
        this.settings.setInstalled(this.installed.toArray(new String[0]));
        this.settings._getStorageHandler().setSaveInShutdownHookEnabled(true);
    }

    @Override
    public synchronized void setRequestsDone() throws ExtIOException {
        this.installed.addAll(this.requestedInstalls);
        this.requestedInstalls.clear();
        this.installed.removeAll(this.requestedUninstalls);
        this.requestedUninstalls.clear();
        this.writeInstalled();
        this.writeRequestedInstalls();
        this.writeRequestedUninstalls();
    }

    public synchronized void requestUninstallation(String e) {
        if ((e = this.toLowerCase(e)) != null && this.canUninstall(e) && this.requestedUninstalls.add(e)) {
            this.writeRequestedUninstalls();
        }
    }

    public synchronized void requestUninstallation(String e, boolean clearInstallRequests) {
        e = this.toLowerCase(e);
        this.requestUninstallation(e);
        if (clearInstallRequests) {
            this.requestedInstalls.remove(e);
            this.writeRequestedInstalls();
        }
    }

    @Override
    protected boolean keepFile(String id) {
        if (this.requestedUninstalls.contains(id)) {
            return false;
        }
        if (this.requestedInstalls.contains(id)) {
            return true;
        }
        return this.installed.contains(id);
    }

    @Override
    public void sync() throws ExtIOException {
    }
}

