/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.defaultimpl.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.defaultimpl.http.HttpBackend;
import org.appwork.updatesys.client.defaultimpl.http.NoConnectionException;
import org.appwork.updatesys.client.defaultimpl.http.ProxySelectorImpl;
import org.appwork.updatesys.client.defaultimpl.http.ServerException;
import org.appwork.updatesys.client.defaultimpl.http.UpdateHttpClientOptions;
import org.appwork.updatesys.client.http.DownloadHooksInterface;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.http.PostProgressCallback;
import org.appwork.updatesys.client.http.ProgressCallback;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.http.ProxySelectorInterface;
import org.appwork.updatesys.transport.DoNOTTryNextGatewayOrProxyException;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.TryNextGatewayOrProxyException;
import org.appwork.updatesys.transport.UpdateServerOfflineException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.BasicHTTP.BadRangeResponse;
import org.appwork.utils.net.BasicHTTP.BasicHTTPException;
import org.appwork.utils.net.BasicHTTP.InvalidResponseCode;
import org.appwork.utils.net.DownloadProgress;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyAuthException;

public class HttpClientImpl
implements HttpClientInterface {
    public static final String NO_LAST_CHANCE_FOUND_GOOD = "No Last Chance Found. Good!";
    protected final UpdateHttpClientOptions settings;
    protected final LogInterface logger;
    protected volatile HttpBackend httpBackend;
    protected ProxySelectorInterface proxySelector;

    public HttpClientImpl(LogInterface logger) {
        this.logger = logger;
        this.settings = this.createSettings();
        this.initProxySelector();
    }

    public void initProxySelector() {
        this.setProxySelector(new ProxySelectorImpl(this.getLogger()));
    }

    @Override
    public void cancel() {
        HTTPConnection connection;
        HttpBackend httpBackend = this.getHttpBackend();
        if (httpBackend != null && (connection = httpBackend.getConnection()) != null) {
            connection.disconnect();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkTryNextProxyOrGiveUp(IOException e, Object context) throws TransportException, TryNextGatewayOrProxyException, DoNOTTryNextGatewayOrProxyException {
        String squidError;
        InvalidResponseCode irc;
        this.getLogger().info("Check if we can leave ");
        if (this.getProxySelector().isDialogAskAuthRequiredAllowedForCurrentThread(context) && this.isProxyAuthRequired(e, this.getHttpBackend())) {
            throw new DoNOTTryNextGatewayOrProxyException(e);
        }
        InvalidResponseCode ivrc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
        if (ivrc != null && ivrc.getCode() == 404) {
            try {
                if (!ivrc.getConnection().getURL().toString().contains("/lastchance")) {
                    // empty if block
                }
            }
            catch (Throwable e1) {
                this.getLogger().log(e);
            }
        }
        if ((irc = Exceptions.getInstanceof(e, InvalidResponseCode.class)) != null) {
            this.getLogger().info("Invalid Response Code: " + irc);
        }
        if (irc != null && irc.getConnection() != null && HTTPConstants.ResponseCode.SERVERERROR_SERVICE_UNAVAILABLE.getCode() == irc.getConnection().getResponseCode() && (squidError = irc.getConnection().getHeaderField("X-Squid-Error")) != null && squidError.trim().startsWith("ERR_DNS_FAIL")) {
            this.getLogger().info("bad Proxy. X-Squid-Error: " + squidError);
            throw new TryNextGatewayOrProxyException();
        }
        this.throwServerExceptions(e);
        throw new TryNextGatewayOrProxyException();
    }

    protected HttpBackend createHTTPBackend() {
        return new HttpBackend(this);
    }

    protected UpdateHttpClientOptions createSettings() {
        return JsonConfig.create("cfg/updateclient/HttpSettings", UpdateHttpClientOptions.class);
    }

    public synchronized String download(Object context, URL url, File file, ProgressCallback progressCallback) throws TransportException, InterruptedException, ProxySelectorException {
        return this.download(context, url, file, progressCallback, null);
    }

    @Override
    public synchronized String download(Object context, URL url, File file, ProgressCallback progressCallback, DownloadHooksInterface hooks) throws TransportException, InterruptedException, ProxySelectorException {
        HttpBackend httpBackend;
        ProxySelectorInterface proxyManager = this.getProxySelector();
        List<HTTPProxy> proxyList = proxyManager.getProxies(context, url);
        this.info("GET " + url + " via " + proxyList);
        this.httpBackend = httpBackend = this.createHTTPBackend();
        try {
            IOException firstIOException;
            block20: {
                firstIOException = null;
                for (HTTPProxy proxy : proxyList) {
                    try {
                        return this.internalDownloadWithProxy(context, url, httpBackend, proxy, file, progressCallback, hooks);
                    }
                    catch (IOException e) {
                        proxy = httpBackend.getProxy();
                        if (firstIOException == null) {
                            firstIOException = e;
                        }
                        try {
                            this.checkTryNextProxyOrGiveUp(e, context);
                        }
                        catch (DoNOTTryNextGatewayOrProxyException e1) {
                            break;
                        }
                        catch (TryNextGatewayOrProxyException e1) {
                        }
                        catch (TransportException e1) {
                            this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), proxy, url);
                            throw e1;
                        }
                    }
                }
                if (firstIOException == null || this.couldNotConnectToTheServer(firstIOException)) {
                    HTTPProxy newProxy;
                    while ((newProxy = this.getProxySelector().onNoConnection(context, proxyList, url)) != null) {
                        proxyList = Arrays.asList(newProxy);
                        try {
                            return this.internalDownloadWithProxy(context, url, httpBackend, newProxy, file, progressCallback, hooks);
                        }
                        catch (IOException e) {
                            newProxy = httpBackend.getProxy();
                            if (firstIOException == null) {
                                firstIOException = e;
                            }
                            try {
                                this.checkTryNextProxyOrGiveUp(e, context);
                            }
                            catch (DoNOTTryNextGatewayOrProxyException e1) {
                                break block20;
                            }
                            catch (TryNextGatewayOrProxyException e1) {
                            }
                            catch (TransportException e1) {
                                this.validateProxySuccessOnIOException(context, e1, this.proxySelector, newProxy, url);
                                throw e1;
                            }
                        }
                    }
                    throw new NoConnectionException("Could not Connect to " + url);
                }
            }
            if (this.isProxyAuthRequired(firstIOException, httpBackend)) {
                throw new NoConnectionException("Proxy Auth failed", firstIOException);
            }
            throw firstIOException;
        }
        catch (IOException e) {
            this.throwServerExceptions(e);
            throw new UpdateServerOfflineException(e);
        }
    }

    @Override
    public synchronized byte[] get(Object context, URL url) throws TransportException, InterruptedException, ProxySelectorException {
        return this.get(this, url, null, true);
    }

    @Override
    public synchronized byte[] get(Object context, URL url, boolean askForConnection) throws TransportException, InterruptedException, ProxySelectorException {
        return this.get(context, url, null, askForConnection);
    }

    protected byte[] internalPostWithProxy(Object context, URL url, byte[] postData, HttpBackend httpBackend, final PostProgressCallback postProgressCallback, final HTTPProxy proxy) throws InterruptedException, IOException, ProxySelectorException {
        DownloadProgress uploadProgress = new DownloadProgress(){

            @Override
            public void onConnect(HTTPConnection connection) throws IOException {
                postProgressCallback.onBeforeConnect(proxy, connection);
            }

            @Override
            public void onConnected(HTTPConnection connection) throws IOException {
            }

            @Override
            public void onException(HTTPConnection connection, Throwable exception) {
                postProgressCallback.onException(exception);
            }

            @Override
            public void onDisconnected(HTTPConnection connection) {
                postProgressCallback.onDisconnected(proxy, connection);
            }

            @Override
            public void setLoaded(long loaded) {
            }

            @Override
            public void setTotal(long total) {
                super.setTotal(total);
            }

            @Override
            public void increaseLoaded(long increase) {
                super.increaseLoaded(increase);
                postProgressCallback.onUploadProgress(this.getLoaded(), this.getTotal());
            }

            @Override
            public long getLoaded() {
                return super.getLoaded();
            }

            @Override
            public long getTotal() {
                return super.getTotal();
            }

            @Override
            public void onBytesLoaded(byte[] b, int len) {
            }
        };
        DownloadProgress downloadProgress = new DownloadProgress(){

            @Override
            public void onConnect(HTTPConnection connection) throws IOException {
            }

            @Override
            public void onConnected(HTTPConnection connection) throws IOException {
                postProgressCallback.onConnected(proxy, connection);
            }

            @Override
            public void onException(HTTPConnection connection, Throwable exception) {
                postProgressCallback.onException(exception);
            }

            @Override
            public void onDisconnected(HTTPConnection connection) {
                postProgressCallback.onDisconnected(proxy, connection);
            }

            @Override
            public void setLoaded(long loaded) {
                super.setLoaded(loaded);
            }

            @Override
            public void setTotal(long total) {
                super.setTotal(total);
            }

            @Override
            public void increaseLoaded(long increase) {
                super.increaseLoaded(increase);
                postProgressCallback.onDownloadProgress(this.getLoaded(), this.getTotal());
            }

            @Override
            public long getLoaded() {
                return super.getLoaded();
            }

            @Override
            public long getTotal() {
                return super.getTotal();
            }

            @Override
            public void onBytesLoaded(byte[] b, int len) {
            }
        };
        try {
            httpBackend.setProxy(proxy);
            this.info("Get Try with Proxy " + proxy);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            postProgressCallback.onTry(proxy);
            httpBackend.postPage(url, postData, baos, uploadProgress, downloadProgress);
            byte[] ret = baos.toByteArray();
            if (httpBackend.getConnection().getResponseMessage() == "unknown HTTP response") {
                throw new IOException("unknown HTTP response");
            }
            this.getProxySelector().onSuccess(context, url, proxy);
            this.info("Connection OK: " + ret.length + " Bytes loaded");
            return ret;
        }
        catch (IOException e) {
            if (Thread.interrupted()) {
                throw Exceptions.addSuppressed(new InterruptedException(), e);
            }
            HTTPProxy usedProxy = httpBackend.getProxy();
            if (this.isProxyAuthRequired(e, httpBackend)) {
                HTTPProxy newProxy;
                this.info("Proxy Auth Required");
                int retries = 0;
                while ((newProxy = this.getProxySelector().updateProxyAuth(context, ++retries, usedProxy, this.getProxyAuthHeaders(e, httpBackend), url)) != null) {
                    this.info("Proxy Auth try 2: " + newProxy + " Native HTTP:" + newProxy.isPreferNativeImplementation());
                    try {
                        httpBackend.setProxy(newProxy);
                        usedProxy = newProxy;
                        postProgressCallback.onTry(proxy);
                        byte[] ret = httpBackend.download(url, downloadProgress, -1L);
                        this.getProxySelector().onSuccess(context, url, newProxy);
                        this.info("Connection OK: " + ret.length + " Bytes loaded");
                        return ret;
                    }
                    catch (IOException e1) {
                        this.log(e1);
                        if (!this.isProxyAuthRequired(e1, httpBackend)) {
                            this.info("No proxy Auth");
                            this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), newProxy, url);
                            throw e1;
                        }
                        this.info("Proxy Auth Failed anyway");
                    }
                }
                this.info("Got no Proxy AUth Infos.");
                throw e;
            }
            throw e;
        }
    }

    @Override
    public synchronized byte[] post(Object context, URL url, byte[] postData, boolean askForConnection, PostProgressCallback postProgressCallback) throws TransportException, InterruptedException, ProxySelectorException {
        HttpBackend httpBackend;
        ProxySelectorInterface proxyManager = this.getProxySelector();
        List<HTTPProxy> proxyList = proxyManager.getProxies(context, url);
        this.info("GET " + url + " via " + proxyList);
        this.httpBackend = httpBackend = this.createHTTPBackend();
        try {
            IOException firstIOException = null;
            for (HTTPProxy proxy : proxyList) {
                try {
                    return this.internalPostWithProxy(context, url, postData, httpBackend, postProgressCallback, proxy);
                }
                catch (IOException e) {
                    proxy = httpBackend.getProxy();
                    if (firstIOException == null) {
                        firstIOException = e;
                    }
                    try {
                        this.checkTryNextProxyOrGiveUp(e, context);
                    }
                    catch (DoNOTTryNextGatewayOrProxyException e1) {
                        break;
                    }
                    catch (TryNextGatewayOrProxyException e1) {
                    }
                    catch (TransportException e1) {
                        this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), proxy, url);
                        throw e1;
                    }
                }
            }
            if (firstIOException == null || this.couldNotConnectToTheServer(firstIOException)) {
                while (askForConnection) {
                    HTTPProxy newProxy = this.getProxySelector().onNoConnection(context, proxyList, url);
                    if (newProxy != null) {
                        proxyList = Arrays.asList(newProxy);
                        try {
                            return this.internalPostWithProxy(context, url, postData, httpBackend, postProgressCallback, newProxy);
                        }
                        catch (IOException e) {
                            if (firstIOException == null) {
                                firstIOException = e;
                            }
                            try {
                                this.checkTryNextProxyOrGiveUp(e, context);
                                continue;
                            }
                            catch (DoNOTTryNextGatewayOrProxyException e1) {
                                break;
                            }
                            catch (TryNextGatewayOrProxyException e1) {
                                continue;
                            }
                            catch (TransportException e1) {
                                this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), newProxy, url);
                                throw e1;
                            }
                        }
                    }
                    throw new NoConnectionException("Could not Connect to " + url);
                }
            }
            if (this.isProxyAuthRequired(firstIOException, httpBackend)) {
                throw new NoConnectionException("Proxy Auth failed", firstIOException);
            }
            throw firstIOException;
        }
        catch (IOException e) {
            this.throwServerExceptions(e);
            throw new UpdateServerOfflineException(e);
        }
    }

    @Override
    public synchronized byte[] get(Object context, URL url, ProgressCallback progressCallback, boolean askForConnection) throws TransportException, InterruptedException, ProxySelectorException {
        HttpBackend httpBackend;
        String urlString = url.toString();
        if (urlString.contains("%0d") || urlString.contains("%0a") || urlString.contains("%0D") || urlString.contains("%0A")) {
            this.info("WARNING! Found encoded NEWLINE in URL: " + url);
            try {
                url = new URL(urlString.replace("%0d", "").replace("%0a", "").replace("%0D", "").replace("%0A", ""));
            }
            catch (MalformedURLException e) {
                throw new WTFException(e);
            }
        }
        ProxySelectorInterface proxyManager = this.getProxySelector();
        List<HTTPProxy> proxyList = proxyManager.getProxies(context, url);
        this.info("GET " + url + " via " + proxyList);
        this.httpBackend = httpBackend = this.createHTTPBackend();
        try {
            IOException firstIOException = null;
            for (HTTPProxy proxy : proxyList) {
                try {
                    return this.internalGetWithProxy(context, url, httpBackend, progressCallback, proxy);
                }
                catch (IOException e) {
                    proxy = httpBackend.getProxy();
                    if (firstIOException == null) {
                        firstIOException = e;
                    }
                    try {
                        this.checkTryNextProxyOrGiveUp(e, context);
                    }
                    catch (DoNOTTryNextGatewayOrProxyException e1) {
                        break;
                    }
                    catch (TryNextGatewayOrProxyException e1) {
                    }
                    catch (TransportException e1) {
                        this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), proxy, url);
                        throw e1;
                    }
                }
            }
            if (firstIOException == null || this.couldNotConnectToTheServer(firstIOException)) {
                while (askForConnection) {
                    HTTPProxy newProxy = this.getProxySelector().onNoConnection(context, proxyList, url);
                    if (newProxy != null) {
                        proxyList = Arrays.asList(newProxy);
                        try {
                            return this.internalGetWithProxy(context, url, httpBackend, progressCallback, newProxy);
                        }
                        catch (IOException e) {
                            if (firstIOException == null) {
                                firstIOException = e;
                            }
                            try {
                                this.checkTryNextProxyOrGiveUp(e, context);
                                continue;
                            }
                            catch (DoNOTTryNextGatewayOrProxyException e1) {
                                break;
                            }
                            catch (TryNextGatewayOrProxyException e1) {
                                continue;
                            }
                            catch (TransportException e1) {
                                this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), newProxy, url);
                                throw e1;
                            }
                        }
                    }
                    throw new NoConnectionException("Could not Connect to " + url);
                }
            }
            if (this.isProxyAuthRequired(firstIOException, httpBackend)) {
                throw new NoConnectionException("Proxy Auth failed", firstIOException);
            }
            throw firstIOException;
        }
        catch (IOException e) {
            this.throwServerExceptions(e);
            throw new UpdateServerOfflineException(e);
        }
    }

    public HTTPConnection getConnection() {
        HttpBackend httpBackend = this.getHttpBackend();
        return httpBackend == null ? null : httpBackend.getConnection();
    }

    public LogInterface getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return LogV3.I().getDefaultLogger();
    }

    protected HttpBackend getHttpBackend() {
        return this.httpBackend;
    }

    private List<String> getProxyAuthHeaders(IOException e, HttpBackend httpBackend) {
        List<String> proxyAuths = null;
        InvalidResponseCode irc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
        if (irc != null && irc.getConnection() != null) {
            proxyAuths = irc.getConnection().getHeaderFields("proxy-authenticate");
        }
        if (proxyAuths == null && httpBackend.getConnection() != null && httpBackend.getProxy() != null && !HTTPProxy.NONE.equals(httpBackend.getProxy())) {
            proxyAuths = httpBackend.getConnection().getHeaderFields("proxy-authenticate");
        }
        if (Exceptions.containsInstanceOf(e, ProxyAuthException.class)) {
            return Arrays.asList("ProxyAuthException");
        }
        return proxyAuths;
    }

    @Override
    public ProxySelectorInterface getProxySelector() {
        return this.proxySelector;
    }

    public UpdateHttpClientOptions getSettings() {
        return this.settings;
    }

    private void throwServerExceptions(Exception e) throws TransportException {
        InvalidResponseCode irc;
        if (e instanceof TransportException) {
            throw (TransportException)e;
        }
        BasicHTTPException bhe = Exceptions.getInstanceof(e, BasicHTTPException.class);
        if (bhe != null) {
            this.getLogger().info("Handle BasicHTTPException " + bhe);
            if (bhe.getConnection().getHeaderField("JCGI") != null) {
                throw new ServerException(e);
            }
        }
        if ((irc = Exceptions.getInstanceof(e, InvalidResponseCode.class)) != null) {
            this.getLogger().info("Handle InvalidResponseCode " + irc);
            if (irc.getConnection().getHeaderField("JCGI") != null) {
                throw new ServerException(e);
            }
            int code = irc.getConnection().getResponseCode();
            String message = irc.getConnection().getResponseMessage();
            if (code == 502 && StringUtils.equalsIgnoreCase("Bad Gateway", message)) {
                throw new UpdateServerOfflineException(e);
            }
            if (code == 503) {
                throw new UpdateServerOfflineException(e);
            }
            if (code == 404) {
                throw new UpdateServerOfflineException(e);
            }
            if (code == 504) {
                throw new UpdateServerOfflineException(e);
            }
        }
    }

    private void info(String string) {
        LogInterface lLogger = this.getLogger();
        if (lLogger != null) {
            lLogger.info(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String internalActualDownload(HttpBackend httpBackend, HTTPProxy proxy, URL url, File file, final ProgressCallback progressCallback, DownloadHooksInterface hooks) throws TransportException, InterruptedException, IOException {
        FileOutputStream boas = null;
        try {
            try {
                final MessageDigest md = MessageDigest.getInstance("SHA-256");
                if (file.length() > 0L) {
                    if (hooks != null) {
                        hooks.onBeforePreHashing(file);
                    }
                    long start = Time.systemIndependentCurrentJVMTimeMillis();
                    InputStream fis = null;
                    Throwable throwable = null;
                    try {
                        byte[] b = new byte[32768];
                        fis = hooks == null ? new FileInputStream(file) : hooks.openInputStream(file);
                        int n = 0;
                        while ((n = fis.read(b, 0, b.length)) >= 0) {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (n <= 0) continue;
                            md.update(b, 0, n);
                        }
                    }
                    catch (InterruptedException e) {
                        throwable = e;
                        throw e;
                    }
                    catch (Throwable e) {
                        throwable = e;
                        throw new TransportException(e);
                    }
                    finally {
                        try {
                            fis.close();
                        }
                        catch (Throwable e) {
                            throw new TransportException(e);
                        }
                        finally {
                            if (hooks != null) {
                                hooks.onAfterPreHashing(Time.systemIndependentCurrentJVMTimeMillis() - start, file, throwable);
                            }
                        }
                    }
                }
                boas = hooks == null ? new FileOutputStream(file, true) : hooks.openOutputStream(file, true);
                httpBackend.download(url, new DownloadProgress(){

                    @Override
                    public void increaseLoaded(long increase) {
                        super.increaseLoaded(increase);
                        if (progressCallback != null) {
                            progressCallback.updateLoadedBytes(this.getLoaded());
                        }
                    }

                    @Override
                    public void onConnect(HTTPConnection connection) throws IOException {
                        super.onConnect(connection);
                        if (progressCallback != null) {
                            progressCallback.onConnect(connection);
                        }
                    }

                    @Override
                    public void onConnected(HTTPConnection connection) throws IOException {
                        super.onConnected(connection);
                        if (progressCallback != null) {
                            progressCallback.onConnected(connection);
                        }
                    }

                    @Override
                    public void onDisconnected(HTTPConnection connection) {
                        super.onDisconnected(connection);
                        if (progressCallback != null) {
                            progressCallback.onDisconnected(connection);
                        }
                    }

                    @Override
                    public void onException(HTTPConnection connection, Throwable exception) {
                        super.onException(connection, exception);
                        if (progressCallback != null) {
                            progressCallback.onException(connection, exception);
                        }
                    }

                    @Override
                    public void onBytesLoaded(byte[] b, int len) {
                        if (len > 0) {
                            md.update(b, 0, len);
                        }
                    }

                    @Override
                    public void setLoaded(long loaded) {
                        super.setLoaded(loaded);
                        if (progressCallback != null) {
                            progressCallback.setLoadedBytes(loaded);
                        }
                    }

                    @Override
                    public void setTotal(long total) {
                        super.setTotal(total);
                        if (progressCallback != null) {
                            progressCallback.updateTotalBytes(total);
                        }
                    }
                }, -1L, boas, file.length());
                byte[] digest = md.digest();
                if (httpBackend.getConnection().getResponseMessage() == "unknown HTTP response") {
                    throw new IOException("unknown HTTP response");
                }
                String string = HexFormatter.byteArrayToHex(digest);
                return string;
            }
            catch (FileNotFoundException e) {
                throw new TransportException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransportException(e);
            }
            finally {
                try {
                    boas.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (BasicHTTPException e) {
            if (!file.exists()) throw e;
            if (file.length() <= 0L) throw e;
            if (!Exceptions.containsInstanceOf(e, BadRangeResponse.class)) throw e;
            try {
                if (hooks == null) {
                    if (!file.exists()) return this.internalActualDownload(httpBackend, proxy, url, file, progressCallback, hooks);
                    if (file.delete()) return this.internalActualDownload(httpBackend, proxy, url, file, progressCallback, hooks);
                    throw new IOException("Could not Delete " + file);
                }
                hooks.deleteFileIfExists(file);
                return this.internalActualDownload(httpBackend, proxy, url, file, progressCallback, hooks);
            }
            catch (InterruptedException ie) {
                Exceptions.addSuppressed(ie, e);
                throw ie;
            }
            catch (TransportException te) {
                Exceptions.addSuppressed(te, e);
                throw te;
            }
            catch (IOException ioe) {
                Exceptions.addSuppressed(ioe, e);
                throw ioe;
            }
        }
    }

    protected String internalDownloadWithProxy(Object context, URL url, HttpBackend httpBackend, HTTPProxy proxy, File file, ProgressCallback progressCallback, DownloadHooksInterface hooks) throws TransportException, InterruptedException, IOException, ProxySelectorException {
        try {
            httpBackend.setProxy(proxy);
            this.getLogger().info("Try Proxy: " + proxy);
            this.info("Download to " + file + " Size before: " + file.length() + " bytes");
            String ret = this.internalActualDownload(httpBackend, proxy, url, file, progressCallback, hooks);
            this.getProxySelector().onSuccess(context, url, proxy);
            this.info("Connection ok. Downloaded " + file + ": " + file.length() + " bytes");
            return ret;
        }
        catch (IOException e) {
            if (Thread.interrupted()) {
                throw Exceptions.addSuppressed(new InterruptedException(), e);
            }
            HTTPProxy usedProxy = httpBackend.getProxy();
            if (this.isProxyAuthRequired(e, httpBackend)) {
                HTTPProxy newProxy;
                this.log(e);
                this.info("Proxy Auth Required");
                int retries = 0;
                while ((newProxy = this.getProxySelector().updateProxyAuth(context, ++retries, usedProxy, this.getProxyAuthHeaders(e, httpBackend), url)) != null) {
                    this.info("Proxy Auth try1: " + usedProxy + " Native HTTP:" + usedProxy.isPreferNativeImplementation());
                    try {
                        httpBackend.setProxy(newProxy);
                        usedProxy = newProxy;
                        this.info("Download to " + file + " Size before: " + file.length() + " bytes");
                        String ret = this.internalActualDownload(httpBackend, newProxy, url, file, progressCallback, hooks);
                        this.info("Connection ok. Downloaded " + file + ": " + file.length() + " bytes");
                        this.getProxySelector().onSuccess(context, url, newProxy);
                        return ret;
                    }
                    catch (IOException e1) {
                        if (!this.isProxyAuthRequired(e1, httpBackend)) {
                            this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), newProxy, url);
                            throw e1;
                        }
                        this.info("Proxy Auth Failed:");
                        this.log(e1);
                    }
                }
                this.info("Got no Proxy AUth Infos.");
                throw e;
            }
            if (url.toString().contains("/lastchance")) {
                InvalidResponseCode ivrc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
                if (ivrc != null && ivrc.getCode() == 404) {
                    this.info(NO_LAST_CHANCE_FOUND_GOOD);
                } else {
                    this.log(e);
                }
            } else {
                this.log(e);
            }
            throw e;
        }
    }

    protected byte[] internalGetWithProxy(Object context, URL url, HttpBackend httpBackend, final ProgressCallback progressCallback, HTTPProxy proxy) throws InterruptedException, IOException, ProxySelectorException {
        DownloadProgress downloadProgress = progressCallback != null ? new DownloadProgress(){

            @Override
            public void increaseLoaded(long increase) {
                super.increaseLoaded(increase);
                progressCallback.updateLoadedBytes(this.getLoaded());
            }

            @Override
            public void onConnect(HTTPConnection connection) throws IOException {
                progressCallback.onConnect(connection);
            }

            @Override
            public void onConnected(HTTPConnection connection) throws IOException {
                progressCallback.onConnected(connection);
            }

            @Override
            public void onDisconnected(HTTPConnection connection) {
                progressCallback.onDisconnected(connection);
            }

            @Override
            public void onException(HTTPConnection connection, Throwable exception) {
                progressCallback.onException(connection, exception);
            }

            @Override
            public void setLoaded(long loaded) {
                super.setLoaded(loaded);
                progressCallback.setLoadedBytes(loaded);
            }

            @Override
            public void setTotal(long total) {
                super.setTotal(total);
                progressCallback.updateTotalBytes(total);
            }
        } : null;
        try {
            httpBackend.setProxy(proxy);
            this.info("Get Try with Proxy " + proxy);
            byte[] ret = httpBackend.download(url, downloadProgress, -1L);
            if (httpBackend.getConnection().getResponseMessage() == "unknown HTTP response") {
                throw new IOException("unknown HTTP response");
            }
            this.getProxySelector().onSuccess(context, url, proxy);
            this.info("Connection OK: " + ret.length + " Bytes loaded");
            return ret;
        }
        catch (IOException e) {
            if (Thread.interrupted()) {
                throw Exceptions.addSuppressed(new InterruptedException(), e);
            }
            HTTPProxy usedProxy = httpBackend.getProxy();
            if (this.isProxyAuthRequired(e, httpBackend)) {
                HTTPProxy newProxy;
                this.info("Proxy Auth Required");
                int retries = 0;
                while ((newProxy = this.getProxySelector().updateProxyAuth(context, ++retries, usedProxy, this.getProxyAuthHeaders(e, httpBackend), url)) != null) {
                    this.info("Proxy Auth try 2: " + newProxy + " Native HTTP:" + newProxy.isPreferNativeImplementation());
                    try {
                        httpBackend.setProxy(newProxy);
                        usedProxy = newProxy;
                        byte[] ret = httpBackend.download(url, downloadProgress, -1L);
                        this.getProxySelector().onSuccess(context, url, newProxy);
                        this.info("Connection OK: " + ret.length + " Bytes loaded");
                        return ret;
                    }
                    catch (IOException e1) {
                        this.log(e1);
                        if (!this.isProxyAuthRequired(e1, httpBackend)) {
                            this.info("No proxy Auth");
                            this.validateProxySuccessOnIOException(context, e1, this.getProxySelector(), newProxy, url);
                            throw e1;
                        }
                        this.info("Proxy Auth Failed anyway");
                    }
                }
                this.info("Got no Proxy AUth Infos.");
                throw e;
            }
            this.log(e);
            throw e;
        }
    }

    protected boolean isProxyAuthRequired(IOException e, HttpBackend httpBackend) {
        int responseCode;
        List<String> proxyAuths;
        if (Exceptions.containsInstanceOf(e, ProxyAuthException.class)) {
            return true;
        }
        InvalidResponseCode irc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
        if (irc != null && irc.getConnection() != null) {
            proxyAuths = irc.getConnection().getHeaderFields("proxy-authenticate");
            responseCode = irc.getConnection().getResponseCode();
            if (responseCode == HTTPConstants.ResponseCode.PROXY_AUTH_REQUIRED.getCode() || proxyAuths != null && proxyAuths.size() > 0) {
                return true;
            }
        }
        if (httpBackend.getConnection() != null && httpBackend.getProxy() != null && !HTTPProxy.NONE.equals(httpBackend.getProxy())) {
            proxyAuths = httpBackend.getConnection().getHeaderFields("proxy-authenticate");
            responseCode = httpBackend.getConnection().getResponseCode();
            if (responseCode == HTTPConstants.ResponseCode.PROXY_AUTH_REQUIRED.getCode() || proxyAuths != null && proxyAuths.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private void log(Exception e1) {
        LogInterface logger = this.getLogger();
        if (logger != null) {
            if (e1.getCause() != null && e1.getCause() instanceof InvalidResponseCode && ((InvalidResponseCode)e1.getCause()).getCode() == HTTPConstants.ResponseCode.ERROR_NOT_FOUND.getCode()) {
                this.info("ResponseCode: 404");
                return;
            }
            logger.log(e1);
        }
    }

    @Override
    public void setProxySelector(ProxySelectorInterface proxySelector) {
        if (proxySelector == null) {
            throw new NullPointerException();
        }
        this.proxySelector = proxySelector;
    }

    protected boolean couldNotConnectToTheServer(Exception e) {
        String squidError;
        SocketTimeoutException timeout = Exceptions.getInstanceof(e, SocketTimeoutException.class);
        if (timeout != null && timeout.getMessage() != null && timeout.getMessage().toLowerCase(Locale.ENGLISH).contains("read")) {
            return false;
        }
        InvalidResponseCode irc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
        if (irc != null && irc.getConnection() != null && HTTPConstants.ResponseCode.SERVERERROR_SERVICE_UNAVAILABLE.getCode() == irc.getConnection().getResponseCode() && (squidError = irc.getConnection().getHeaderField("X-Squid-Error")) != null && squidError.trim().startsWith("ERR_DNS_FAIL")) {
            this.getLogger().info("Bad Proxy. X-Squid-Error: " + squidError);
            return true;
        }
        return Exceptions.containsInstanceOf(e, UnknownHostException.class, SocketException.class, InterruptedIOException.class);
    }

    private void validateProxySuccessOnIOException(Object context, Exception e, ProxySelectorInterface proxySelector, HTTPProxy proxy, URL url) {
        HTTPConstants.ResponseCode code;
        if (this.couldNotConnectToTheServer(e)) {
            return;
        }
        if (e instanceof ServerException) {
            proxySelector.onSuccess(context, url, proxy);
            return;
        }
        InvalidResponseCode irc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
        if (irc != null && irc.getConnection() != null && (code = HTTPConstants.ResponseCode.get(irc.getConnection().getResponseCode())) != null && code != HTTPConstants.ResponseCode.PROXY_AUTH_REQUIRED) {
            proxySelector.onSuccess(context, url, proxy);
            return;
        }
    }
}

