/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.appwork.exceptions.WTFException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.updatesys.transport.exchange.batch.BatchRequest;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.StringUtils;

public class RandomAnonymousUIDProvider
implements UIDProviderInterface {
    protected static String DO_NOT_TRACK = "dnt_";
    protected final UpdateClient client;

    protected UpdateClient getClient() {
        return this.client;
    }

    public RandomAnonymousUIDProvider(UpdateClient client) {
        this.client = client;
    }

    @Override
    public String getAcceptedID() throws InterruptedException, ExtIOException {
        return DO_NOT_TRACK;
    }

    @Override
    public boolean hasValidID() throws InterruptedException, ExtIOException {
        return true;
    }

    @Override
    public void onServerSentAcceptedID(String uid) throws InterruptedException, ExtIOException {
    }

    protected String encode(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public void appendToUrl(StringBuilder url) throws InterruptedException, ExtIOException {
        try {
            url.append("&uid=" + this.encode(this.getAcceptedID()));
        }
        catch (Throwable e) {
            this.getClient().trackException(e);
        }
    }

    @Override
    public void appendToBatchRequest(BatchRequest br) throws InterruptedException, ExtIOException {
    }
}

