/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import java.util.Map;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;

public class DiskSpaceException
extends InstallException {
    private final File file;
    private final long requiredBytes;
    private final Map<File, DiskSpaceChanges> map;

    public Map<File, DiskSpaceChanges> getMap() {
        return this.map;
    }

    public DiskSpaceException(UpdateClient updateClient, File file, long needed) {
        super(updateClient, "Not enough space on " + file + ", " + needed + " bytes required!");
        this.map = null;
        this.requiredBytes = needed;
        this.file = file;
    }

    public DiskSpaceException(UpdateClient updateClient, Map<File, DiskSpaceChanges> badMap) {
        super(updateClient, "Additional Space required: " + badMap);
        this.map = badMap;
        this.file = null;
        this.requiredBytes = -1L;
    }

    public long getRequiredBytes() {
        return this.requiredBytes;
    }

    public File getFile() {
        return this.file;
    }
}

