/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.client.NoRelativeFileException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.os.CrossSystem;

public class AbsoluteFile
extends File {
    private static final long serialVersionUID = 8063838938903379506L;
    private final String relative;
    protected final String root;
    protected final String key;

    private AbsoluteFile(String absolute, String key, String root, String rel) {
        super(absolute);
        if (!this.isAbsolute()) {
            throw new WTFException("File is not absolute: " + this + "|Absolute:" + absolute + "|Key:" + key + "|Root:" + root + "|Rel:" + rel);
        }
        this.root = root == null ? null : new File(root).getPath();
        this.key = key;
        if (rel != null && File.separatorChar != '/') {
            rel = rel.replace('/', File.separatorChar);
        }
        String string = this.relative = rel == null ? null : new File(rel).getPath();
        if (this.relative != null && !new AbsoluteFile(key, this.root, this.relative).equals(this)) {
            try {
                if (!new AbsoluteFile(key, this.root, this.relative).getCanonicalFile().equals(this.getCanonicalFile())) {
                    throw new IllegalStateException("Unknown path error " + this + " != " + new AbsoluteFile(key, root, rel));
                }
            }
            catch (IOException e) {
                LogV3.I().getDefaultLogger().exception("Absolute:" + absolute + "|Key:" + key + "|Root:" + root + "|Rel:" + rel, e);
            }
        }
    }

    public AbsoluteFile(String key, String root, String rel) {
        super(AbsoluteFile.buildAbsolutePath(key, root, rel));
        if (!this.isAbsolute()) {
            throw new WTFException("File is not absolute: " + this + "|Key:" + key + "|Root:" + root + "|Rel:" + rel);
        }
        if (rel != null && File.separatorChar != '/') {
            rel = rel.replace('/', File.separatorChar);
        }
        this.root = root == null ? null : new File(root).getPath();
        this.key = key;
        this.relative = rel == null ? null : new File(rel).getPath();
    }

    private static String buildAbsolutePath(String key, String root, String rel) {
        if (root == null) {
            new IllegalArgumentException("Key:" + key + "|Root:" + root + "|Rel:" + rel);
        }
        try {
            if (key == null) {
                return new File(root, rel).getAbsolutePath();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(root);
            sb.append(rel.substring(key.length()));
            return sb.toString();
        }
        catch (Throwable e) {
            throw Exceptions.addSuppressed(new IllegalArgumentException("Key:" + key + "|Root:" + root + "|Rel:" + rel), e);
        }
    }

    public AbsoluteFile(File root, String rel) {
        super(root, rel);
        if (!this.isAbsolute()) {
            throw new WTFException("File is not absolute: " + this);
        }
        if (rel != null && File.separatorChar != '/') {
            rel = rel.replace('/', File.separatorChar);
        }
        this.root = root.getAbsolutePath();
        this.key = null;
        this.relative = rel == null ? null : new File(rel).getPath();
    }

    public AbsoluteFile deriveWithPostFix(String postFix) throws NoRelativeFileException {
        String relative = this.getRelative();
        if (relative == null) {
            throw new NoRelativeFileException(this);
        }
        return new AbsoluteFile(this.key, this.root, relative + postFix);
    }

    public static String getParent(String path) {
        String name;
        int index = path.lastIndexOf(File.separatorChar);
        int prefixLength = CrossSystem.getDesktopSupport().getPrefixLength(path);
        if (path.length() == prefixLength) {
            return null;
        }
        if (index < prefixLength && prefixLength > 0 && path.length() > prefixLength) {
            return path.substring(0, prefixLength);
        }
        String string = name = index >= 0 && path.length() - index - 1 == 2 ? path.substring(index + 1) : null;
        if (index < prefixLength || "..".equals(name)) {
            return new File(path, "..").getPath();
        }
        return path.substring(0, index);
    }

    public AbsoluteFile[] listFiles(FileFilter filter) {
        AbsoluteFile[] files = this.listFiles();
        if (files == null || files.length == 0 || filter == null) {
            return files;
        }
        ArrayList<AbsoluteFile> ret = new ArrayList<AbsoluteFile>();
        for (AbsoluteFile file : files) {
            if (!filter.accept(file)) continue;
            ret.add(file);
        }
        return ret.toArray(new AbsoluteFile[0]);
    }

    public AbsoluteFile[] listFiles(FilenameFilter filter) {
        AbsoluteFile[] files = this.listFiles();
        if (files == null || files.length == 0 || filter == null) {
            return files;
        }
        ArrayList<AbsoluteFile> ret = new ArrayList<AbsoluteFile>();
        for (AbsoluteFile file : files) {
            if (!filter.accept(this, file.getName())) continue;
            ret.add(file);
        }
        return ret.toArray(new AbsoluteFile[0]);
    }

    public AbsoluteFile[] listFiles() {
        String[] ret = this.list();
        if (ret == null) {
            return null;
        }
        if (ret.length == 0) {
            return new AbsoluteFile[0];
        }
        int count = ret.length;
        AbsoluteFile[] files = new AbsoluteFile[count];
        for (int i = 0; i < count; ++i) {
            files[i] = new AbsoluteFile(this.key, this.root, this.getRelative() + "/" + ret[i]);
        }
        return files;
    }

    @Override
    public AbsoluteFile getParentFile() {
        String absoluteParent = super.getParent();
        if (absoluteParent == null) {
            return null;
        }
        if (this.relative == null) {
            return new AbsoluteFile(absoluteParent, this.key, this.root, null);
        }
        String relativeParent = AbsoluteFile.getParent(this.getRelative());
        if (relativeParent != null && this.key != null && !relativeParent.startsWith(this.key)) {
            relativeParent = null;
        }
        return new AbsoluteFile(absoluteParent, this.key, this.root, relativeParent);
    }

    public AbsoluteFile deriveFromChild(File child) throws NoRelativeFileException {
        if (child instanceof AbsoluteFile) {
            return (AbsoluteFile)child;
        }
        String rel = Files.getRelativePath(this.root, child.getAbsolutePath());
        if (rel == null) {
            throw new NoRelativeFileException(this.root, child);
        }
        return new AbsoluteFile(this.key, this.root, rel);
    }

    public AbsoluteFile deriveSibling(String newName) {
        if (this.relative == null) {
            return new AbsoluteFile(this.getParent() + File.separator + newName, this.key, this.root, null);
        }
        String relativeParent = AbsoluteFile.getParent(this.getRelative());
        if (relativeParent == null) {
            relativeParent = newName;
        } else {
            relativeParent = relativeParent + File.separatorChar;
            relativeParent = relativeParent + newName;
        }
        if (this.key != null && !relativeParent.startsWith(this.key)) {
            relativeParent = null;
        }
        return new AbsoluteFile(this.key, this.root, relativeParent);
    }

    public String getRelative() {
        return this.relative;
    }
}

