/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.uio;

import javax.swing.Icon;
import org.appwork.console.AbstractConsole;
import org.appwork.console.ConsoleDialog;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UserIODefinition;
import org.appwork.uio.UserIOHandlerInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Exceptions;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;

public class HeadlessDialogHandler
implements UserIOHandlerInterface {
    @Override
    public <T extends UserIODefinition> T show(Class<T> class1, T impl) {
        if (impl instanceof ConfirmDialog) {
            CloseReason cr;
            if (BinaryLogic.containsAll(impl.getFlags(), 16)) {
                this.showMessageDialog(((ConfirmDialog)impl).getMessage());
                cr = CloseReason.OK;
            } else {
                cr = this.showConfirmDialog(impl.getFlags(), impl.getTitle(), ((ConfirmDialog)impl).getMessage(), null, ((ConfirmDialog)impl).getOKButtonText(), ((ConfirmDialog)impl).getCancelButtonText()) ? CloseReason.OK : CloseReason.CANCEL;
            }
            return (T)new ConfirmDialogInterface(){

                @Override
                public void throwCloseExceptions() throws DialogClosedException, DialogCanceledException {
                    switch (this.getCloseReason()) {
                        case CANCEL: {
                            throw new DialogCanceledException(4);
                        }
                        case CLOSE: {
                            throw new DialogCanceledException(64);
                        }
                        case TIMEOUT: {
                            throw new DialogCanceledException(96);
                        }
                        case INTERRUPT: {
                            throw new DialogCanceledException(320);
                        }
                    }
                }

                @Override
                public void setCloseReason(CloseReason closeReason) {
                }

                @Override
                public boolean isRemoteAPIEnabled() {
                    return false;
                }

                @Override
                public boolean isDontShowAgainSelected() {
                    return false;
                }

                @Override
                public String getTitle() {
                    return null;
                }

                @Override
                public int getTimeout() {
                    return 0;
                }

                @Override
                public int getFlags() {
                    return 0;
                }

                @Override
                public CloseReason getCloseReason() {
                    return cr;
                }

                @Override
                public String getOKButtonText() {
                    return null;
                }

                @Override
                public String getMessage() {
                    return null;
                }

                @Override
                public String getCancelButtonText() {
                    return null;
                }
            };
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean showConfirmDialog(int flag, String title, String message) {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog(title);
            cd.start();
            cd.printLines(message);
            try {
                cd.waitYesOrNo(flag, "ok", "cancel");
                boolean bl = true;
                return bl;
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
            }
            finally {
                cd.end();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean showConfirmDialog(int flags, String title, String message, Icon icon, String ok, String cancel, String dontShowAgainKey) {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog(title);
            cd.start();
            cd.printLines(message);
            try {
                cd.waitYesOrNo(flags, ok, cancel);
                boolean bl = true;
                return bl;
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
            }
            finally {
                cd.end();
            }
            return false;
        }
    }

    @Override
    public boolean showConfirmDialog(int flags, String title, String message, Icon icon, String ok, String cancel) {
        return this.showConfirmDialog(flags, title, message, icon, ok, cancel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showErrorMessage(String message) {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog("Error!");
            cd.printLines(message);
            cd.start();
            try {
                cd.waitYesOrNo(8, null, null);
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
            }
            finally {
                cd.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showMessageDialog(String message) {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog("Message");
            cd.printLines(message);
            try {
                cd.waitYesOrNo(8, null, null);
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
            }
            finally {
                cd.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showException(String message, Throwable e1) {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog(message);
            cd.printLines(message);
            cd.printLines(Exceptions.getStackTrace(e1));
            cd.start();
            try {
                cd.waitYesOrNo(8, null, null);
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
            }
            finally {
                cd.end();
            }
        }
    }
}

