/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.txtresource.LocaleMap;
import org.appwork.txtresource.Name;
import org.appwork.txtresource.TranslatedStringBuilder;
import org.appwork.utils.DebugMode;

public class TranslatedEntry {
    private final String raw;
    private Object[] parts;
    private volatile int expectedSize;

    public TranslatedEntry(String raw) {
        this.raw = raw;
    }

    public String getRaw() {
        return this.raw;
    }

    public String format(Method method, Object[] args) {
        if (args != null && args.length > 0) {
            try {
                this.precompile(method);
                TranslatedStringBuilder sb = new TranslatedStringBuilder(this.expectedSize);
                for (int i = 0; i < this.parts.length; ++i) {
                    Object p = this.parts[i];
                    if (p instanceof Integer) {
                        Object arg = args[(Integer)p];
                        if (arg != null && arg instanceof LocaleMap) {
                            arg = ((LocaleMap)arg).resolve();
                        }
                        sb.append(arg);
                        continue;
                    }
                    if (p instanceof int[]) {
                        sb.append(this.raw, ((int[])p)[0], ((int[])p)[1]);
                        continue;
                    }
                    if (p instanceof String) {
                        sb.append((String)p);
                        continue;
                    }
                    if (p instanceof char[]) {
                        sb.append((char[])p);
                        continue;
                    }
                    throw new WTFException("Unsupported:" + p.getClass());
                }
                this.expectedSize = sb.length();
                return sb.toString();
            }
            catch (RuntimeException e) {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    throw e;
                }
                return "FIXME:" + this.raw;
            }
        }
        return this.raw;
    }

    protected void precompile(Method method) {
        block6: {
            ArrayList<Object> parts;
            block7: {
                int last;
                block5: {
                    String split;
                    int first;
                    if (this.parts != null) break block6;
                    Annotation[][] annotations = method.getParameterAnnotations();
                    HashMap<String, Integer> splitOn = new HashMap<String, Integer>();
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        splitOn.put("%s" + (i + 1), i);
                        for (Annotation ap : annotations[i]) {
                            if (!(ap instanceof Name)) continue;
                            splitOn.put("%" + ((Name)ap).value() + "%", i);
                        }
                    }
                    parts = new ArrayList<Object>();
                    last = 0;
                    do {
                        first = -1;
                        split = null;
                        for (Map.Entry s : splitOn.entrySet()) {
                            int index = this.raw.indexOf((String)s.getKey(), last);
                            if (index < 0 || first >= 0 && first <= index) continue;
                            first = index;
                            split = (String)s.getKey();
                        }
                        if (first < 0) break block5;
                        if (first - last > 0) {
                            parts.add(new int[]{last, first});
                        }
                        Integer index = (Integer)splitOn.get(split);
                        parts.add(index);
                    } while ((last = first + split.length()) != this.raw.length());
                    break block7;
                }
                parts.add(new int[]{last, this.raw.length()});
            }
            this.expectedSize = this.raw.length() * 2;
            this.parts = parts.toArray(new Object[0]);
        }
    }
}

