/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.testframework;

import java.io.File;
import java.io.FileFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.sink.AbstractSink;
import org.appwork.loggingv3.simple.sink.SimpleFormatter;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.ConditionedArgs;
import org.appwork.testframework.PostBuildTestInterface;
import org.appwork.testframework.PostTestMetaData;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.ProcessOutput;

public class PostBuildRunner {
    private static final String SOURCE = "-source=";
    private static final String DO_NOT_TRY_TO_RUN_MARKER = "-skip=";
    private static final String MUST_RUN_WITHOUT_CLASSLOADER_ERRORS_MARKER = "-force=";
    public static HashMap<String, Object> CONFIG = null;
    static File BASE;
    private static HashSet<String> MUST_RUN_WITHOUT_CLASSLOADER_ERRORS;
    private static HashSet<String> DO_NOT_TRY_TO_RUN;
    private static boolean PRINT_CLASSLOADER_ERRORS;
    private static ArrayList<String> TESTS_OK;

    public static void main(String[] args) throws Exception {
        Application.setApplication(".appwork-tests");
        AWTest.initLogger(new SimpleFormatter(){

            @Override
            protected String createPre(LogRecord2 record, String sourceString) {
                return "";
            }
        });
        if (args.length >= 1 && args[0].equals("-test")) {
            PostBuildRunner.runSingleTest(args);
        } else {
            PostBuildRunner.runAllTestsInClasspath(args);
        }
    }

    protected static void runAllTestsInClasspath(String[] args) throws Exception {
        BASE = new File(args[0]);
        TESTS_OK = new ArrayList();
        MUST_RUN_WITHOUT_CLASSLOADER_ERRORS = new HashSet();
        DO_NOT_TRY_TO_RUN = new HashSet();
        String sourceFolder = null;
        LogV3.info("Parameters " + Arrays.toString(args));
        for (int i = 1; i < args.length; ++i) {
            LogV3.info("Parameter " + i + ": " + args[i]);
            if (args[i].startsWith(MUST_RUN_WITHOUT_CLASSLOADER_ERRORS_MARKER)) {
                MUST_RUN_WITHOUT_CLASSLOADER_ERRORS.add(args[i].substring(MUST_RUN_WITHOUT_CLASSLOADER_ERRORS_MARKER.length()));
                continue;
            }
            if (args[i].startsWith(DO_NOT_TRY_TO_RUN_MARKER)) {
                DO_NOT_TRY_TO_RUN.add(args[i].substring(DO_NOT_TRY_TO_RUN_MARKER.length()));
                continue;
            }
            if (args[i].startsWith(SOURCE)) {
                sourceFolder = args[i].substring(SOURCE.length());
                continue;
            }
            if (StringUtils.equalsIgnoreCase(args[i], "-print_classloader_errors")) {
                PRINT_CLASSLOADER_ERRORS = true;
                continue;
            }
            throw new WTFException("Unknown Parameter: " + args[i]);
        }
        if (!BASE.isDirectory()) {
            throw new WTFException("The Base directory passed from the ant script does not exist: " + BASE);
        }
        if (!new File(BASE, "application").isDirectory()) {
            throw new WTFException("base/application Folder does not exist.");
        }
        if (!new File(BASE, "tests").isDirectory()) {
            throw new WTFException("base/tests Folder does not exist.");
        }
        LogV3.info(PostBuildRunner.header("START") + "Post Build Tests");
        LogV3.info(PostBuildRunner.header("BASE") + BASE);
        boolean anyTest = false;
        block4: for (File f : Files.getFiles(true, true, new File(BASE, "tests"))) {
            String relative;
            if (!f.isFile() || !(relative = Files.getRelativePath(new File(BASE, "tests"), f)).toUpperCase(Locale.ROOT).endsWith(".CLASS") || relative.contains("$")) continue;
            String classname = relative.replace("/", ".").substring(0, relative.length() - ".class".length());
            try {
                for (String p : DO_NOT_TRY_TO_RUN) {
                    if (!classname.matches(p)) continue;
                    continue block4;
                }
                Class<?> cls = Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
                if (Modifier.isAbstract(cls.getModifiers()) || !PostBuildTestInterface.class.isAssignableFrom(cls) || PostBuildTestInterface.class == cls) continue;
                PostBuildRunner.runTestClass(cls, sourceFolder, args);
                anyTest = true;
            }
            catch (NoClassDefFoundError e) {
                LogV3.info("Skipped Test (Classloader Error):" + relative);
                if (!PostBuildRunner.mustRunWithoutClassloaderErrors(classname)) continue;
                throw new Exception("Failed test with classloader error although it is marked with -force in the build.xml", e);
            }
            catch (ClassNotFoundException e) {
                LogV3.info("Skipped Test (Classloader Error):" + relative);
                if (!PostBuildRunner.mustRunWithoutClassloaderErrors(classname)) continue;
                throw new Exception("Failed test with classloader error although it is marked with -force in the build.xml", e);
            }
        }
        if (!anyTest) {
            throw new Exception("No Tests found. This is probably a build error. Check folder " + new File(BASE, "tests") + " for tests classes");
        }
        int i = 0;
        block6: for (String p : MUST_RUN_WITHOUT_CLASSLOADER_ERRORS) {
            for (String test : TESTS_OK) {
                if (!test.matches(p)) continue;
                continue block6;
            }
            LogV3.info(PostBuildRunner.header("error") + "-force Test not found: " + p);
            ++i;
        }
        if (i > 0) {
            throw new Exception("Could not find tests for at least 1 -force pattern");
        }
        LogV3.info(PostBuildRunner.header("SUCCESS") + "Finished Post Build Tests");
        LogV3.info(PostBuildRunner.header("FINISHED") + "PostBuildRunnerFinished");
    }

    private static boolean mustRunWithoutClassloaderErrors(String classname) {
        for (String p : MUST_RUN_WITHOUT_CLASSLOADER_ERRORS) {
            if (!classname.matches(p)) continue;
            return true;
        }
        return false;
    }

    protected static void runSingleTest(String[] args) {
        try {
            String testClass = args[1];
            Class.forName(testClass);
            String folderWithTestWorkspace = args[2];
            if (!new File(folderWithTestWorkspace).isDirectory()) {
                throw new WTFException("Workspace Folder does not exist.");
            }
            if (!new File(new File(folderWithTestWorkspace), "application").isDirectory()) {
                throw new WTFException("Workspace/application Folder does not exist.");
            }
            if (!new File(new File(folderWithTestWorkspace), "tests").isDirectory()) {
                throw new WTFException("Workspace/tests Folder does not exist.");
            }
            PostBuildRunner.runTest(args[1], args[2], args);
            LogV3.info(PostBuildRunner.header("SUCCESS") + "Test Finished Successfuly");
            LogV3.disableSysout();
            System.exit(0);
        }
        catch (InstantiationException testClass) {
        }
        catch (Throwable e) {
            if (Exceptions.getInstanceof(e, NoClassDefFoundError.class) != null) {
                AWTest.setLoggerSilent(false, false);
                LogV3.info(PostBuildRunner.header("ERROR") + "Class file(s) not in JAR: " + e.getMessage());
                LogV3.disableSysout();
                System.exit(2);
            }
            AWTest.setLoggerSilent(false, true);
            LogV3.log(e);
            LogV3.disableSysout();
            System.exit(1);
        }
    }

    public static String header(String msg) {
        return "*** " + StringUtils.fillPost(msg.toUpperCase(Locale.ROOT), " ", 10) + "";
    }

    private static void runTest(String clz, String base, String[] args) throws Exception {
        PostBuildTestInterface instance = (PostBuildTestInterface)Class.forName(clz).getConstructor(new Class[0]).newInstance(new Object[0]);
        String[] paras = new String[args.length - 2];
        System.arraycopy(args, 2, paras, 0, paras.length);
        File testConfigFile = new File(new File(base, "application"), "test_resources/config.json");
        CONFIG = new HashMap();
        if (testConfigFile.isFile()) {
            CONFIG = JSonStorage.restoreFromString(IO.readFileToString(testConfigFile), TypeRef.HASHMAP);
        }
        instance.runPostBuildTest(paras, new File(base, "application"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runTestClass(Class<?> cls, String sourceFolder, String[] args) throws Exception {
        LogV3.info(PostBuildRunner.header("run test") + cls.getName());
        AWTest.setLoggerSilent(true, false);
        final File workingcopy = new File(BASE, "RUNNING_TEST");
        try {
            HashMap<String, Long> matcher;
            if (workingcopy.exists()) {
                Files.deleteRecursive(workingcopy, true);
            }
            IO.copyFolderRecursive(Application.getResource(""), new File(workingcopy, "application"), false, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.equals(workingcopy);
                }
            }, IO.SYNC.META_AND_DATA);
            IO.copyFolderRecursive(new File(BASE, "tests"), new File(workingcopy, "tests"), false, new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.equals(workingcopy);
                }
            }, IO.SYNC.META_AND_DATA);
            StringBuilder sb = new StringBuilder();
            List<URL> urls = ClassPathScanner.getClassPath();
            for (URL url : urls) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                File u = new File(url.toURI());
                sb.append(Files.getRelativePath(BASE, u));
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(CrossSystem.getJavaBinary());
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> jvmArgs = bean.getInputArguments();
            for (int i = 0; i < jvmArgs.size(); ++i) {
                if (!jvmArgs.get(i).startsWith("-D")) continue;
                cmd.add(jvmArgs.get(i));
            }
            URL metaUrl = cls.getResource(cls.getSimpleName() + ".meta.json");
            PostTestMetaData meta = null;
            if (metaUrl != null) {
                meta = (PostTestMetaData)FlexiUtils.readObject(metaUrl.openStream(), new SimpleTypeRef((Type)((Object)PostTestMetaData.class)));
            }
            if (meta != null && meta.getArgs() != null) {
                matcher = new HashMap<String, Long>();
                matcher.put("jvm", JVMVersion.get());
                if (meta.getArgs().getJVM() != null) {
                    for (ConditionedArgs p : meta.getArgs().getJVM()) {
                        if (p.getCondition() != null && !p.getCondition().matches(matcher)) continue;
                        cmd.addAll(Arrays.asList(p.getCommandline()));
                    }
                }
            }
            cmd.addAll(Arrays.asList("-cp", sb.toString(), PostBuildRunner.class.getName(), "-test", cls.getName(), workingcopy.getAbsolutePath()));
            if (sourceFolder != null) {
                cmd.addAll(Arrays.asList("-source", sourceFolder));
            }
            cmd.addAll(Arrays.asList(args));
            if (meta != null && meta.getArgs() != null) {
                matcher = new HashMap();
                matcher.put("jvm", JVMVersion.get());
                if (meta.getArgs().getCLI() != null) {
                    for (ConditionedArgs p : meta.getArgs().getCLI()) {
                        if (p.getCondition() != null && !p.getCondition().matches(matcher)) continue;
                        cmd.addAll(Arrays.asList(p.getCommandline()));
                    }
                }
            }
            AWTest.logInfoAnyway("Command: " + cmd.toString());
            ProcessBuilder pb = ProcessBuilderFactory.create(cmd);
            pb.directory(workingcopy);
            ProcessOutput result = ProcessBuilderFactory.runCommand(pb);
            if (result.getStdOutString().length() > 0) {
                LogV3.info(result.getStdOutString());
            }
            if (result.getErrOutString().length() > 0) {
                LogV3.info(result.getErrOutString());
            }
            int exit = result.getExitCode();
            AWTest.setLoggerSilent(false, false);
            if (exit == 2) {
                if (PostBuildRunner.mustRunWithoutClassloaderErrors(cls.getName())) {
                    if (result.getStdOutString().length() > 0) {
                        LogV3.info("      " + result.getStdOutString().replaceAll("[\r\n]{1,2}", "\r\n      "));
                    }
                    if (result.getErrOutString().length() > 0) {
                        LogV3.info("      " + result.getErrOutString().replaceAll("[\r\n]{1,2}", "\r\n      "));
                    }
                    throw new Exception("Failed test with classloader error although it is marked with -force in the build.xml");
                }
                String missingResource = new Regex(result.getStdOutString(), "not in JAR\\:\\s*([^\r\n]+)").getMatch(0);
                if (missingResource != null) {
                    LogV3.info("  >>" + PostBuildRunner.header("skipped") + "Missing Test Resource: " + missingResource);
                } else {
                    LogV3.info("  >>" + PostBuildRunner.header("skipped") + "Classloader Error.");
                }
                if (PRINT_CLASSLOADER_ERRORS) {
                    if (result.getStdOutString().length() > 0) {
                        LogV3.info("    " + result.getStdOutString().replaceAll("[\r\n]{1,2}", "\r\n    "));
                    }
                    if (result.getErrOutString().length() > 0) {
                        LogV3.info("    " + result.getErrOutString().replaceAll("[\r\n]{1,2}", "\r\n    "));
                    }
                }
                TESTS_OK.add(cls.getName());
                return;
            }
            if (exit == 1) {
                LogV3.info("  >>" + PostBuildRunner.header("failed") + "Exit with ExitCode " + exit);
                if (result.getStdOutString().length() > 0) {
                    LogV3.info("      " + result.getStdOutString().replaceAll("[\r\n]{1,2}", "\r\n      "));
                }
                if (result.getErrOutString().length() > 0) {
                    LogV3.info("      " + result.getErrOutString().replaceAll("[\r\n]{1,2}", "\r\n      "));
                }
                System.exit(exit);
            } else {
                TESTS_OK.add(cls.getName());
                LogV3.info("  >>" + PostBuildRunner.header("success"));
            }
        }
        finally {
            AWTest.setLoggerSilent(false, false);
            if (workingcopy.exists()) {
                Files.deleteRecursive(workingcopy, true);
            }
        }
    }

    public static class LogCache
    extends AbstractSink {
        private ArrayList<LogRecord2> buffer = new ArrayList();

        public ArrayList<LogRecord2> getBuffer() {
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord2 record) {
            ArrayList<LogRecord2> arrayList = this.buffer;
            synchronized (arrayList) {
                this.buffer.add(record);
            }
        }
    }
}

