/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.synthetica;

import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthUI;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.synthetica.LanguageFileSetup;
import org.appwork.swing.synthetica.SyntheticaSettings;
import org.appwork.testframework.AWTestValidateClassReference;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class SyntheticaHelper {
    @AWTestValidateClassReference(classpath=".*/?syntheticaSimple2D\\.jar")
    private static final String DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_SIMPLE2D_LOOK_AND_FEEL = "de.javasoft.plaf.synthetica.SyntheticaSimple2DLookAndFeel";
    public final SyntheticaSettings config;
    public static Boolean IS_SYNTHETICA = null;
    @AWTestValidateClassReference(classpath=".*/?synthetica\\.jar")
    public static final String CLASS_DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_LOOK_AND_FEEL = "de.javasoft.plaf.synthetica.SyntheticaLookAndFeel";

    public SyntheticaHelper() {
        this(JsonConfig.create(SyntheticaSettings.class));
    }

    public SyntheticaHelper(SyntheticaSettings settings) {
        this.config = settings;
    }

    public String getDefaultFont() {
        if (CrossSystem.isWindows()) {
            if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_VISTA)) {
                return "Segoe UI";
            }
        }
        return null;
    }

    public String getFontName(SyntheticaSettings config, LanguageFileSetup locale) {
        String configFontName = config.getFontName();
        String translationFontName = locale.config_fontname();
        String fontName = null;
        if (StringUtils.isNotEmpty(translationFontName) && !"default".equalsIgnoreCase(translationFontName)) {
            fontName = translationFontName;
        }
        if (StringUtils.isNotEmpty(configFontName) && !"default".equalsIgnoreCase(configFontName)) {
            fontName = configFontName;
        }
        if (StringUtils.isEmpty(fontName)) {
            fontName = this.getDefaultFont();
        }
        return fontName;
    }

    public int getFontScaleFaktor(SyntheticaSettings config, LanguageFileSetup translationFileConfig) {
        int fontScale = -1;
        try {
            fontScale = Integer.parseInt(translationFileConfig.config_fontscale_faktor());
            LogV3.logger(this).info("Get FontScale from Translationfile: " + fontScale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config.getFontScaleFactor() != 100 || fontScale <= 0) {
            fontScale = config.getFontScaleFactor();
            LogV3.logger(this).info("Get FontScale from config: " + fontScale);
        }
        return fontScale;
    }

    public static void init() throws IOException {
        new SyntheticaHelper().load();
    }

    public void load() throws IOException {
        this.load(DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_SIMPLE2D_LOOK_AND_FEEL);
    }

    public void load(String laf) throws IOException {
        this.load(laf, SyntheticaHelper.readLicense());
    }

    public static String readLicense() throws IOException {
        URL url = Application.getRessourceURL("cfg/synthetica-license.key");
        if (url == null) {
            LogV3.warning("Missing Look And Feel License. Reverted to your System Look And Feel!");
            LogV3.warning("You can only use Synthetica Look and Feel in official JDownloader versions.");
            LogV3.warning("Reverted to your System Look And Feel!");
            LogV3.warning("If you are a developer, and want to do some gui work on the offical JDownloader Look And Feel, write e-mail@appwork.org to get a developer Look And Feel Key");
            throw new WTFException("No Synthetica License Found!");
        }
        return IO.readURLToString(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String laf, String license) throws IOException {
        if (UIManager.get("Synthetica.animation.enabled") != null) {
            LogV3.info("Synthetica Look And Feel is already Set");
        }
        if (CrossSystem.isMac() && this.checkIfMacInitWillFail()) {
            LogV3.info("GC");
            System.gc();
            if (this.checkIfMacInitWillFail()) {
                throw new IOException("Cannot Init LookAndFeel. Windows Are Open");
            }
        }
        if (StringUtils.isEmpty(license)) {
            license = SyntheticaHelper.readLicense();
        }
        LogV3.info("LaF init: " + laf);
        long start = System.currentTimeMillis();
        try {
            Class<?> synthetica;
            SyntheticaHelper.setLicense(license);
            try {
                this.getClass();
                synthetica = Class.forName(CLASS_DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_LOOK_AND_FEEL);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                long time = System.currentTimeMillis() - start;
                LogV3.info("LAF Init duration: " + time + "ms");
                return;
            }
            JFrame.setDefaultLookAndFeelDecorated(false);
            JDialog.setDefaultLookAndFeelDecorated(false);
            LanguageFileSetup locale = TranslationFactory.create(LanguageFileSetup.class);
            boolean decorated = this.config.isWindowDecorationEnabled();
            ReflectionUtils.invoke(synthetica, "setWindowsDecorated", null, Void.TYPE, decorated);
            UIManager.put("Synthetica.window.decoration", decorated);
            if (CrossSystem.isUnix()) {
                UIManager.put("Synthetica.popupRobot.enabled", Boolean.FALSE);
            }
            UIManager.put("Synthetica.extendedFileChooser.rememberPreferences", Boolean.FALSE);
            UIManager.put("Synthetica.extendedFileChooser.rememberLastDirectory", Boolean.FALSE);
            UIManager.put("Synthetica.font.respectSystemDPI", this.config.isFontRespectsSystemDPI());
            int fontScale = this.getFontScaleFaktor(this.config, locale);
            if (this.config.isFontRespectsSystemDPI() && fontScale != 100) {
                LogV3.warning("SystemDPI might interfere with JD's FontScaling");
            }
            if (fontScale >= 50) {
                LogV3.logger(this).info("FontScale: " + fontScale);
                UIManager.put("Synthetica.font.scaleFactor", fontScale);
            } else {
                LogV3.logger(this).info("FontScale skipped: " + fontScale);
            }
            UIManager.put("Synthetica.animation.enabled", this.config.isAnimationEnabled());
            if (CrossSystem.isWindows()) {
                UIManager.put("Synthetica.window.opaque", this.config.isWindowOpaque());
            } else {
                UIManager.put("Synthetica.window.opaque", true);
            }
            UIManager.put("Synthetica.text.antialias", this.config.isTextAntiAliasEnabled());
            UIManager.put("Synthetica.menu.toolTipEnabled", true);
            UIManager.put("Synthetica.menuItem.toolTipEnabled", true);
            if (!Application.isHeadless()) {
                ReflectionUtils.invoke(synthetica, "setLookAndFeel", null, Void.TYPE, laf);
            }
            ReflectionUtils.invoke(synthetica, "setExtendedFileChooserEnabled", null, Void.TYPE, false);
            String fontName = this.getFontName(this.config, locale);
            if (StringUtils.isNotEmpty(fontName)) {
                LogV3.logger(this).info("FontName: " + fontName);
                Font font = ReflectionUtils.invoke(synthetica, "getFont", null, Font.class, new Object[0]);
                Font newFont = new Font(fontName, font.getStyle(), font.getSize());
                ReflectionUtils.invoke(synthetica, "setFont", null, Void.TYPE, newFont, false);
            }
            ExtPasswordField.MASK = "*******";
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            long time = System.currentTimeMillis() - start;
            LogV3.info("LAF Init duration: " + time + "ms");
        }
    }

    public static void setLicense(String license) {
        if (license == null) {
            LogV3.warning("Missing Look And Feel License. Reverted to your System Look And Feel!");
            LogV3.warning("Missing Look And Feel License. Reverted to your System Look And Feel!");
            LogV3.warning("Missing Look And Feel License.");
            LogV3.warning("You can only use Synthetica Look and Feel in official JDownloader versions.");
            LogV3.warning("Reverted to your System Look And Feel!");
            LogV3.warning("If you are a developer, and want to do some gui work on the offical JDownloader Look And Feel, write e-mail@appwork.org to get a developer Look And Feel Key");
            throw new WTFException("No Synthetica License Found!");
        }
        String[] licenseLines = Regex.getLines(license);
        ArrayList<String> valids = new ArrayList<String>();
        for (String s : licenseLines) {
            if (s.trim().startsWith("#") || s.trim().startsWith("//")) continue;
            valids.add(s);
        }
        licenseLines = valids.toArray(new String[0]);
        String key = licenseLines[0];
        if (key.split("-").length == 5) {
            throw new WTFException("Outdated Licensefile: " + Application.getRessourceURL("cfg/synthetica-license.key"));
        }
        String[] li = new String[licenseLines.length - 1];
        System.arraycopy(licenseLines, 1, li, 0, li.length);
        if (key != null) {
            UIManager.put("Synthetica.license.info", li);
            UIManager.put("Synthetica.license.key", key);
        }
    }

    protected boolean checkIfMacInitWillFail() {
        for (Window window : Window.getWindows()) {
            boolean flag;
            boolean bl = flag = !(window instanceof JWindow) && !(window instanceof JFrame) && !(window instanceof JDialog);
            if (window.getClass().getName().contains("Popup$HeavyWeightWindow") || flag) continue;
            return true;
        }
        return false;
    }

    public static boolean isSyntheticaLookAndFeel() {
        Boolean ret = IS_SYNTHETICA;
        if (ret != null) {
            return ret;
        }
        try {
            Class<?> lafClass = UIManager.getLookAndFeel().getClass();
            Class<?> cls = Class.forName(CLASS_DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_LOOK_AND_FEEL, false, Application.class.getClassLoader());
            ret = cls != null && cls.isAssignableFrom(lafClass);
        }
        catch (Throwable throwable) {
        }
        finally {
            IS_SYNTHETICA = ret != null ? ret : Boolean.FALSE;
        }
        return IS_SYNTHETICA;
    }

    public static Color getTextForeGroundForComponent(JComponent comp) {
        try {
            Method getUI = comp.getClass().getMethod("getUI", new Class[0]);
            if (getUI == null) {
                return null;
            }
            SynthUI ui = (SynthUI)getUI.invoke((Object)comp, new Object[0]);
            SynthContext context = ui.getContext(comp);
            Color ret = context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND);
            if (ret == null) {
                ret = context.getStyle().getColor(context, ColorType.FOREGROUND);
            }
            if (ret == null) {
                return comp.getForeground();
            }
            return ret;
        }
        catch (Throwable e) {
            LogV3.log(e);
            return Color.BLACK;
        }
    }

    public static boolean isSynthetica() {
        if (Application.isHeadless()) {
            return false;
        }
        try {
            Class<?> synthetica = Class.forName(CLASS_DE_JAVASOFT_PLAF_SYNTHETICA_SYNTHETICA_LOOK_AND_FEEL, false, SyntheticaHelper.class.getClassLoader());
            LookAndFeel laf = UIManager.getLookAndFeel();
            return synthetica.isAssignableFrom(laf.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

