/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.reflection.Clazz;

public abstract class ExtSpinnerColumn<E>
extends ExtTextColumn<E> {
    private static final long serialVersionUID = 1L;
    private final JSpinner editor;
    private final JSpinner.NumberEditor intEditor;
    private final JSpinner.NumberEditor longEditor;
    private final JSpinner.NumberEditor byteEditor;
    private final JSpinner.NumberEditor shortEditor;
    private final JSpinner.NumberEditor doubleEditor;
    private final JSpinner.NumberEditor floatEditor;
    private final SpinnerNumberModel intModel = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
    private final SpinnerNumberModel longModel = new SpinnerNumberModel((Number)0L, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), (Number)1L);
    private final SpinnerNumberModel byteModel = new SpinnerNumberModel((Number)0, Byte.valueOf((byte)-128), Byte.valueOf((byte)127), (Number)1);
    private final SpinnerNumberModel shortModel = new SpinnerNumberModel((Number)0, Short.valueOf((short)Short.MIN_VALUE), Short.valueOf((short)Short.MAX_VALUE), (Number)1);
    private final SpinnerNumberModel doubleModel = new SpinnerNumberModel((Number)0.0, Double.valueOf(-1.7976931348623157E308), Double.valueOf(Double.MAX_VALUE), (Number)1.0);
    private final SpinnerNumberModel floatModel = new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(1.0f));
    private FocusListener tableFocusLost;

    public ExtSpinnerColumn(String name) {
        this(name, null);
    }

    public ExtSpinnerColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.editor = new JSpinner();
        this.intEditor = new JSpinner.NumberEditor(new JSpinner(this.intModel), "#");
        this.longEditor = new JSpinner.NumberEditor(new JSpinner(this.longModel), "#");
        this.byteEditor = new JSpinner.NumberEditor(new JSpinner(this.byteModel), "#");
        this.shortEditor = new JSpinner.NumberEditor(new JSpinner(this.shortModel), "#");
        this.doubleEditor = new JSpinner.NumberEditor(new JSpinner(this.doubleModel), "###.##");
        this.floatEditor = new JSpinner.NumberEditor(new JSpinner(this.floatModel), "###.##");
        this.intEditor.getTextField().addActionListener(this);
        this.longEditor.getTextField().addActionListener(this);
        this.byteEditor.getTextField().addActionListener(this);
        this.shortEditor.getTextField().addActionListener(this);
        this.doubleEditor.getTextField().addActionListener(this);
        this.floatEditor.getTextField().addActionListener(this);
        this.tableFocusLost = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ExtSpinnerColumn.this.stopCellEditing();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                float _1 = ExtSpinnerColumn.this.getNumber(o1).floatValue();
                float _2 = ExtSpinnerColumn.this.getNumber(o2).floatValue();
                if (this.getSortOrderIdentifier() == "ASC") {
                    return _1 == _2 ? 0 : (_1 < _2 ? -1 : 1);
                }
                return _1 == _2 ? 0 : (_1 > _2 ? -1 : 1);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
        super.actionPerformed(e);
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        Number n = this.getNumber(value);
        this.editor.setModel(this.getModel(value, n));
        this.editor.setEditor(this.getEditor(value, n, this.editor));
        this.editor.setValue(n);
    }

    public JSpinner.NumberEditor getByteEditor() {
        return this.byteEditor;
    }

    public SpinnerNumberModel getByteModel() {
        return this.byteModel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    public JSpinner.NumberEditor getDoubleEditor() {
        return this.doubleEditor;
    }

    public SpinnerNumberModel getDoubleModel() {
        return this.doubleModel;
    }

    protected JSpinner.DefaultEditor getEditor(E value, Number n, JSpinner editor2) {
        if (Clazz.isDouble(n.getClass())) {
            return this.getDoubleEditor();
        }
        if (Clazz.isFloat(n.getClass())) {
            return this.getFloatEditor();
        }
        if (Clazz.isLong(n.getClass())) {
            return this.getLongEditor();
        }
        if (Clazz.isInteger(n.getClass())) {
            return this.getIntEditor();
        }
        if (Clazz.isShort(n.getClass())) {
            return this.getShortEditor();
        }
        if (Clazz.isByte(n.getClass())) {
            return this.getByteEditor();
        }
        return this.getLongEditor();
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    public JSpinner.NumberEditor getFloatEditor() {
        return this.floatEditor;
    }

    public SpinnerNumberModel getFloatModel() {
        return this.floatModel;
    }

    public JSpinner.NumberEditor getIntEditor() {
        return this.intEditor;
    }

    public SpinnerNumberModel getIntModel() {
        return this.intModel;
    }

    public JSpinner.NumberEditor getLongEditor() {
        return this.longEditor;
    }

    public SpinnerNumberModel getLongModel() {
        return this.longModel;
    }

    protected SpinnerNumberModel getModel(E value, Number n) {
        if (Clazz.isDouble(n.getClass())) {
            return this.getDoubleModel();
        }
        if (Clazz.isFloat(n.getClass())) {
            return this.getFloatModel();
        }
        if (Clazz.isLong(n.getClass())) {
            return this.getLongModel();
        }
        if (Clazz.isInteger(n.getClass())) {
            return this.getIntModel();
        }
        if (Clazz.isShort(n.getClass())) {
            return this.getShortModel();
        }
        if (Clazz.isByte(n.getClass())) {
            return this.getByteModel();
        }
        return this.getLongModel();
    }

    protected abstract Number getNumber(E var1);

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.rendererField;
    }

    public JSpinner.NumberEditor getShortEditor() {
        return this.shortEditor;
    }

    public SpinnerNumberModel getShortModel() {
        return this.shortModel;
    }

    @Override
    public boolean isEditable(E obj) {
        if (this.tableFocusLost != null) {
            this.getModel().getTable().addFocusListener(this.tableFocusLost);
            this.tableFocusLost = null;
        }
        return true;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
        this.editor.setBorder(null);
    }

    @Override
    public void resetRenderer() {
        super.resetRenderer();
        this.rendererField.setHorizontalAlignment(4);
    }

    protected abstract void setNumberValue(Number var1, E var2);

    @Override
    public final void setValue(Object value, E object) {
        this.setNumberValue((Number)value, object);
    }
}

