/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.locale._AWU;

public abstract class ExtDateColumn<E>
extends ExtTextColumn<E> {
    private static final long serialVersionUID = -5812486934156037376L;
    private SimpleDateFormat dateFormat;
    protected Date date = new Date();
    protected String badDateText = "~";
    private StringBuffer sb = new StringBuffer();

    public ExtDateColumn(String string) {
        this(string, null);
    }

    public ExtDateColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        try {
            this.dateFormat = this.createDateFormat();
        }
        catch (Exception e) {
            this.dateFormat = new SimpleDateFormat("dd.MM.yy HH:mm"){
                private static final long serialVersionUID = 1L;

                @Override
                public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                    ExtDateColumn.this.sb.setLength(0);
                    return super.format(date, ExtDateColumn.this.sb, pos);
                }
            };
        }
        this.setRowSorter(new ExtDefaultRowSorter<E>(){
            private long a = 0L;
            private long b = 0L;
            private final Date date = new Date();

            @Override
            public int compare(E o1, E o2) {
                Date tmp = ExtDateColumn.this.getDate(o1, this.date);
                this.a = tmp != null ? tmp.getTime() : 0L;
                tmp = ExtDateColumn.this.getDate(o2, this.date);
                this.b = tmp != null ? tmp.getTime() : 0L;
                if (this.a == this.b) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return this.a > this.b ? -1 : 1;
                }
                return this.b > this.a ? -1 : 1;
            }
        });
        this.init();
    }

    protected SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat(this.getDateFormatString()){
            private static final long serialVersionUID = 1L;

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                ExtDateColumn.this.sb.setLength(0);
                return super.format(date, ExtDateColumn.this.sb, pos);
            }
        };
    }

    protected String getBadDateText(E value) {
        return this.badDateText;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    protected abstract Date getDate(E var1, Date var2);

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected String getDateFormatString() {
        return _AWU.T.extdatecolumn_dateandtimeformat();
    }

    @Override
    public String getStringValue(E value) {
        Date d = this.getDate(value, this.date);
        if (d != null) {
            this.date = d;
        }
        if (d == null) {
            return this.setText(value, this.getBadDateText(value));
        }
        return this.setText(value, this.getDateFormat().format(d));
    }

    protected void init() {
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    protected String setText(E value, String badDateText2) {
        return badDateText2;
    }
}

