/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.utils.swing.EDTHelper;

public abstract class ExtComponentColumn<T>
extends ExtColumn<T> {
    private static final long serialVersionUID = 1L;
    private MouseAdapter listener = new MouseAdapter(){
        private int col = -1;
        private int row = -1;

        @Override
        public void mouseMoved(MouseEvent e) {
            ExtTable table = ExtComponentColumn.this.getModel().getTable();
            if (table.getColumnModel().getColumnCount() > 0) {
                final int col = table.columnAtPoint(e.getPoint());
                final int row = table.getRowIndexByPoint(e.getPoint());
                int modelIndex = table.getColumnModel().getColumn(col).getModelIndex();
                int editing = table.getEditingColumn();
                if (col != this.col || row != this.row) {
                    if (ExtComponentColumn.this.getModel().getExtColumnByModelIndex(modelIndex) == ExtComponentColumn.this) {
                        if (editing != col || table.getEditingRow() != row) {
                            modelIndex = table.getColumnModel().getColumn(editing).getModelIndex();
                            if (ExtComponentColumn.this.getModel().getExtColumnByModelIndex(modelIndex) == ExtComponentColumn.this) {
                                ExtComponentColumn.this.stopCellEditing();
                            } else if (editing > 0) {
                                ExtComponentColumn.this.getModel().getExtColumnByModelIndex(modelIndex).stopCellEditing();
                            }
                            new EDTHelper<Void>(){

                                @Override
                                public Void edtRun() {
                                    ExtComponentColumn.this.onCellUpdate(col, row);
                                    return null;
                                }
                            }.start(true);
                        }
                    } else {
                        modelIndex = table.getColumnModel().getColumn(editing).getModelIndex();
                        if (ExtComponentColumn.this.getModel().getExtColumnByModelIndex(modelIndex) == ExtComponentColumn.this) {
                            ExtComponentColumn.this.stopCellEditing();
                        }
                    }
                    this.col = col;
                    this.row = row;
                }
            }
        }
    };

    public ExtComponentColumn(String name) {
        super(name, null);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public JComponent getEditorComponent(T value, boolean isSelected, int row, int column) {
        return this.getInternalEditorComponent(value, isSelected, row, column);
    }

    protected abstract JComponent getInternalEditorComponent(T var1, boolean var2, int var3, int var4);

    protected abstract JComponent getInternalRendererComponent(T var1, boolean var2, boolean var3, int var4, int var5);

    @Override
    public final JComponent getRendererComponent(T value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.listener != null) {
            this.getModel().getTable().addMouseMotionListener(this.listener);
            this.listener = null;
        }
        return this.getInternalRendererComponent(value, isSelected, hasFocus, row, column);
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent);
    }

    @Override
    public boolean isEditable(T obj) {
        return true;
    }

    @Override
    public boolean isEnabled(T obj) {
        return true;
    }

    @Override
    public boolean isSortable(T obj) {
        return false;
    }

    protected void onCellUpdate(int col, int row) {
        this.getModel().getTable().editCellAt(row, col);
    }

    @Override
    public void setValue(Object value, T object) {
    }
}

