/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TableModelEvent;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;

public abstract class ExtCircleProgressColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = -2473320164484034664L;
    protected CircledProgressBar determinatedRenderer = new CircledProgressBar(){
        private static final long serialVersionUID = -5119741526005648827L;

        @Override
        public boolean isVisible() {
            return false;
        }
    };
    protected CompoundBorder defaultBorder;
    private CircledProgressBar indeterminatedRenderer = new IndeterminatedCircledProgressBar();
    protected CircledProgressBar renderer;
    private HashMap<E, Long> map = new HashMap();
    private int columnIndex = -1;

    public ExtCircleProgressColumn(String title) {
        this(title, null);
    }

    public ExtCircleProgressColumn(String name, ExtTableModel<E> extModel) {
        super(name, extModel);
        this.renderer = this.determinatedRenderer;
        this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), this.determinatedRenderer.getBorder());
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                double v2;
                double v1 = (double)ExtCircleProgressColumn.this.getValue(o1) / (double)ExtCircleProgressColumn.this.getMax(o1);
                if (v1 == (v2 = (double)ExtCircleProgressColumn.this.getValue(o2) / (double)ExtCircleProgressColumn.this.getMax(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return v1 > v2 ? -1 : 1;
                }
                return v2 > v1 ? -1 : 1;
            }
        });
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.renderer == this.determinatedRenderer) {
            long m;
            long v = this.getValue(value);
            double factor = Math.max((double)v / 2.147483647E9, (double)(m = this.getMax(value)) / 2.147483647E9);
            if (factor >= 1.0) {
                v = (long)((double)v / factor);
                m = (long)((double)m / factor);
            }
            this.renderer.setMaximum((int)m);
            this.renderer.setValue((int)v);
            this.renderer.setString(this.getString(value));
        } else {
            this.renderer.setString(this.getString(value));
            if (!this.renderer.isIndeterminate()) {
                this.renderer.setIndeterminate(true);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    protected int getFps() {
        return 20;
    }

    protected long getMax(E value) {
        return 100L;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.columnIndex = column;
        if (this.isIndeterminated(value, isSelected, hasFocus, row, column)) {
            this.renderer = this.indeterminatedRenderer;
            if (this.map.size() == 0) {
                this.indeterminatedRenderer.setIndeterminate(true);
            }
            this.map.put(value, System.currentTimeMillis());
        } else {
            this.renderer = this.determinatedRenderer;
            this.map.remove(value);
            if (this.map.size() == 0) {
                this.indeterminatedRenderer.setIndeterminate(false);
            }
        }
        return this.renderer;
    }

    protected abstract String getString(E var1);

    @Override
    protected String getTooltipText(E value) {
        return this.getString(value);
    }

    protected abstract long getValue(E var1);

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    protected boolean isIndeterminated(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return false;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setOpaque(false);
        this.renderer.setStringPainted(true);
        this.renderer.setBorder(this.defaultBorder);
    }

    @Override
    public void setValue(Object value, E object) {
    }

    public class IndeterminatedCircledProgressBar
    extends CircledProgressBar {
        private static final long serialVersionUID = 1L;
        private long timer = 0L;
        private long cleanupTimer = 0L;

        @Override
        public boolean isDisplayable() {
            return true;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void repaint() {
            ExtTableModel mod = ExtCircleProgressColumn.this.getModel();
            if (mod != null && mod.getTable() != null && mod.getTable().isShowing()) {
                if (System.currentTimeMillis() - this.cleanupTimer > 30000L) {
                    Iterator it = ExtCircleProgressColumn.this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        long lastUpdate = System.currentTimeMillis() - (Long)next.getValue();
                        if (lastUpdate <= 5000L) continue;
                        it.remove();
                    }
                    this.cleanupTimer = System.currentTimeMillis();
                    if (ExtCircleProgressColumn.this.map.size() == 0) {
                        ExtCircleProgressColumn.this.indeterminatedRenderer.setIndeterminate(false);
                        return;
                    }
                }
                if (System.currentTimeMillis() - this.timer > (long)(1000 / ExtCircleProgressColumn.this.getFps()) && ExtCircleProgressColumn.this.columnIndex >= 0) {
                    List selection = mod.getSelectedObjects();
                    mod.fireTableChanged(new TableModelEvent(mod, 0, Integer.MAX_VALUE, ExtCircleProgressColumn.this.columnIndex, 0));
                    mod.setSelectedObjects(selection);
                    this.timer = System.currentTimeMillis();
                }
            }
        }
    }
}

