/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.renderer.RendererCheckBox;

public abstract class ExtCheckColumn<E>
extends ExtColumn<E>
implements ActionListener {
    private static final long serialVersionUID = -5391898292508477789L;
    protected final RendererCheckBox renderer = new RendererCheckBox();
    protected final JCheckBox editor = new JCheckBox();

    public ExtCheckColumn(String string) {
        this(string, null);
    }

    public ExtCheckColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.editor.setFocusable(false);
        this.renderer.setFocusable(false);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                boolean b2;
                boolean b1 = ExtCheckColumn.this.getBooleanValue(o1);
                if (b1 == (b2 = ExtCheckColumn.this.getBooleanValue(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return b1 && !b2 ? -1 : 1;
                }
                return !b1 && b2 ? -1 : 1;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editor.removeActionListener(this);
        this.stopCellEditing();
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        this.editor.removeActionListener(this);
        this.editor.setSelected(this.getBooleanValue(value));
        this.editor.addActionListener(this);
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.setSelected(this.getBooleanValue(value));
    }

    @Override
    public JPopupMenu createHeaderPopup() {
        JPopupMenu ret = new JPopupMenu();
        boolean allenabled = true;
        boolean editable = false;
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!this.isEditable(this.getModel().getElementAt(i))) continue;
            editable = true;
            if (!this.isEditable(this.getModel().getElementAt(i)) || this.getBooleanValue(this.getModel().getElementAt(i))) continue;
            allenabled = false;
            break;
        }
        if (!editable) {
            return null;
        }
        final JPopupMenu menu = ret;
        if (allenabled) {
            JCheckBox cb = new JCheckBox(_AWU.T.extttable_disable_all());
            cb.setSelected(true);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtCheckColumn.this.setEnabledAll(false);
                    menu.setVisible(false);
                }
            });
            ret.add(cb);
        } else {
            JCheckBox cb = new JCheckBox(_AWU.T.extttable_enabled_all());
            cb.setSelected(false);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtCheckColumn.this.setEnabledAll(true);
                    menu.setVisible(false);
                }
            });
            ret.add(cb);
        }
        return ret;
    }

    @Override
    public void extendControlButtonMenu(JPopupMenu popup) {
        super.extendControlButtonMenu(popup);
    }

    protected abstract boolean getBooleanValue(E var1);

    @Override
    public final Object getCellEditorValue() {
        return this.editor.isSelected();
    }

    @Override
    public int getClickcount() {
        return 1;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    @Override
    public int getMinWidth() {
        return 30;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    protected String getTooltipText(E obj) {
        return this.getBooleanValue(obj) ? _AWU.T.active() : _AWU.T.inactive();
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
        this.editor.setHorizontalAlignment(0);
        this.editor.setOpaque(false);
        this.editor.putClientProperty("Synthetica.opaque", Boolean.FALSE);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setOpaque(false);
        this.renderer.putClientProperty("Synthetica.opaque", Boolean.FALSE);
    }

    protected abstract void setBooleanValue(boolean var1, E var2);

    protected void setEnabledAll(boolean b) {
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!this.isEditable(this.getModel().getElementAt(i))) continue;
            this.setBooleanValue(b, this.getModel().getElementAt(i));
        }
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtCheckColumn.this.getModel().fireTableDataChanged();
            }
        };
    }

    @Override
    public final void setValue(Object value, E object) {
        this.setBooleanValue((Boolean)value, object);
    }
}

