/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;

public abstract class ExtTableContextMenuController<T extends ExtTable<?>>
implements MouseListener {
    protected T table;

    public ExtTableContextMenuController(T table) {
        this.table = table;
    }

    protected abstract JPopupMenu getEmptyPopup();

    protected abstract JPopupMenu getPopup();

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            JPopupMenu pu;
            int row = ((JTable)this.table).rowAtPoint(e.getPoint());
            Object obj = ((ExtTableModel)((ExtTable)this.table).getModel()).getObjectbyRow(row);
            if (obj == null || row == -1) {
                ((ExtTableModel)((ExtTable)this.table).getModel()).clearSelection();
                JPopupMenu pu2 = this.getEmptyPopup();
                if (pu2 != null && pu2.getComponentCount() > 0) {
                    pu2.show((Component)this.table, e.getPoint().x, e.getPoint().y);
                }
                return;
            }
            if (!((JTable)this.table).isRowSelected(row)) {
                ((ExtTableModel)((ExtTable)this.table).getModel()).clearSelection();
                ((JTable)this.table).addRowSelectionInterval(row, row);
            }
            if ((pu = this.getPopup()) != null && pu.getComponentCount() > 0) {
                pu.show((Component)this.table, e.getPoint().x, e.getPoint().y);
            }
        }
    }
}

