/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.swing.SwingUtils;

public abstract class ExtComponentRowHighlighter<E> {
    protected Color foreground;
    protected Color background;
    protected Border border;
    private final boolean bgMixEnabled;
    private final boolean fgMixEnabled;
    HashMap<String, Color> cache = new HashMap();

    public static Color mixColors(Color bg, Color fg) {
        int ba = fg.getAlpha();
        int aa = 255 - ba;
        int r = (bg.getRed() * aa + fg.getRed() * ba) / (aa + ba);
        int g = (bg.getGreen() * aa + fg.getGreen() * ba) / (aa + ba);
        int b = (bg.getBlue() * aa + fg.getBlue() * ba) / (aa + ba);
        double transbg = (double)(255 - bg.getAlpha()) / 255.0;
        double transfg = (double)(255 - fg.getAlpha()) / 255.0;
        int a = (int)(255.0 * (transbg * transfg));
        return new Color(r, g, b, 255 - a);
    }

    public ExtComponentRowHighlighter(Color foreground, Color background, Border border) {
        this.foreground = foreground;
        this.background = background;
        this.bgMixEnabled = background != null && background.getAlpha() < 255;
        this.fgMixEnabled = foreground != null && foreground.getAlpha() < 255;
        this.border = border;
    }

    public abstract boolean accept(ExtColumn<E> var1, E var2, boolean var3, boolean var4, int var5);

    public Color getBackground() {
        return this.background;
    }

    protected Color getBackground(Color current) {
        if (!this.bgMixEnabled) {
            return this.background;
        }
        if (current == null) {
            return this.background;
        }
        String id = current + "_" + this.background;
        Color cached = this.cache.get(id);
        if (cached != null) {
            return cached;
        }
        cached = ExtComponentRowHighlighter.mixColors(current, this.background);
        this.cache.put(id, cached);
        return cached;
    }

    public Border getBorder() {
        return this.border;
    }

    public Color getForeground() {
        return this.foreground;
    }

    protected Color getForeground(Color current) {
        if (!this.fgMixEnabled) {
            return this.foreground;
        }
        if (current == null) {
            return null;
        }
        String id = current + "_" + this.foreground;
        Color cached = this.cache.get(id);
        if (cached != null) {
            return cached;
        }
        cached = ExtComponentRowHighlighter.mixColors(current, this.foreground);
        this.cache.put(id, cached);
        return cached;
    }

    public int getPriority() {
        return 0;
    }

    public boolean highlight(ExtColumn<E> column, JComponent comp, E value, boolean selected, boolean focus, int row) {
        if (this.accept(column, value, selected, focus, row)) {
            if (this.background != null) {
                Color bg = this.getBackground(comp.getBackground());
                comp.setBackground(bg);
                SwingUtils.setOpaque(comp, true);
            }
            if (this.foreground != null) {
                comp.setForeground(this.getForeground(comp.getForeground()));
            }
            if (this.border != null) {
                comp.setBorder(this.border);
            }
            return true;
        }
        return false;
    }

    static String toString(Color background2) {
        return ExtComponentRowHighlighter.toHex(background2);
    }

    private static String hex(int alpha) {
        String ret = Integer.toHexString(alpha);
        while (ret.length() < 2) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String toHex(Color c) {
        if (c == null) {
            return "Null";
        }
        return ExtComponentRowHighlighter.hex(c.getAlpha()) + ExtComponentRowHighlighter.hex(c.getRed()) + ExtComponentRowHighlighter.hex(c.getGreen()) + ExtComponentRowHighlighter.hex(c.getBlue());
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }
}

