/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;

public class IconLabelToolTip
extends ExtTooltip {
    private static final long serialVersionUID = 1437567673004968332L;
    private String name;
    private Icon icon;
    protected JLabel label;

    public IconLabelToolTip(String name, Icon icon2) {
        this.name = name;
        this.icon = icon2;
        this.label.setText(name);
        this.label.setIcon(icon2);
    }

    @Override
    public TooltipPanel createContent() {
        TooltipPanel ret = new TooltipPanel("ins 0", "[grow,fill]", "[]");
        this.label = new JLabel();
        SwingUtils.setOpaque(this.label, false);
        Color color = UIManager.getColor("Appwork.Tooltip.Foreground");
        if (color == null) {
            color = new JLabel().getForeground();
        }
        this.label.setForeground(color);
        ret.add(this.label);
        return ret;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.label.setIcon(icon);
        this.repaint();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.label.setText(name);
        this.repaint();
    }

    @Override
    public String toText() {
        return this.label.getText();
    }
}

