/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.multiprogressbar;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.appwork.swing.components.multiprogressbar.MultiProgressBar;
import org.appwork.swing.components.multiprogressbar.MultiProgressBarUI;
import org.appwork.swing.components.multiprogressbar.MultiProgressListener;
import org.appwork.swing.components.multiprogressbar.Range;
import org.appwork.utils.ColorUtils;

public class BasicMultiProgressModelUI
extends MultiProgressBarUI
implements MultiProgressListener {
    private MultiProgressBar bar;

    public static ComponentUI createUI(JComponent x) {
        return new BasicMultiProgressModelUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        MultiProgressBar bar = (MultiProgressBar)c;
        Range[] ranges = bar.getModel().getRanges();
        long max = bar.getModel().getMaximum();
        if (max == 0L) {
            return;
        }
        if (ranges == null || ranges.length == 0) {
            return;
        }
        int w = bar.getWidth();
        int h = bar.getHeight();
        int to = 0;
        int from = 0;
        for (Range r : ranges) {
            Color color = r.getColor() != null ? r.getColor() : bar.getForeground();
            g2.setPaint(new GradientPaint(w / 2, h, color, w / 2, 0.0f, ColorUtils.getAlphaInstance(color, 40)));
            to = (int)((r.getTo() - r.getFrom()) * (long)w / max) + 1;
            from = (int)(r.getFrom() * (long)w / max);
            g2.fillRect(from, 0, to, h);
            g2.setColor(color);
            g2.drawLine(from, 0, from, h);
        }
    }

    private void installListeners() {
        this.bar.getEventSender().addListener(this);
    }

    @Override
    public void installUI(JComponent c) {
        this.bar = (MultiProgressBar)c;
        this.installListeners();
    }

    @Override
    public void onChanged() {
        this.bar.repaint();
    }
}

