/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.text.DefaultFormatterFactory;
import org.appwork.swing.components.ExtSpinner;
import org.appwork.utils.formatter.SizeFormatter;

public class SizeSpinner
extends ExtSpinner
implements FocusListener,
ActionListener {
    private static final long serialVersionUID = -3983659343629867162L;
    protected SpinnerNumberModel nm;
    protected final NumberFormat numberFormat = this.initNumberFormat();

    public SizeSpinner(long min, long max, long steps) {
        this(new SpinnerNumberModel((Number)min, Long.valueOf(min), Long.valueOf(max), (Number)steps));
    }

    public SizeSpinner(SpinnerNumberModel model) {
        super(model);
        this.nm = (SpinnerNumberModel)super.getModel();
        DefaultFormatterFactory factory = new DefaultFormatterFactory(new JFormattedTextField.AbstractFormatter(){
            private static final long serialVersionUID = 7808117078307243989L;

            @Override
            public Object stringToValue(String text) throws ParseException {
                return SizeSpinner.this.textToObject(text);
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                return SizeSpinner.this.longToText(((Number)value).longValue());
            }
        });
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFormatterFactory(factory);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().addFocusListener(this);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().addActionListener(this);
    }

    protected NumberFormat initNumberFormat() {
        return NumberFormat.getInstance();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.correct();
    }

    private void beep() {
        Toolkit.getDefaultToolkit().beep();
        final Color bg = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getForeground();
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setForeground(Color.RED);
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JSpinner.DefaultEditor)SizeSpinner.this.getEditor()).getTextField().setForeground(bg);
                Timer timer = (Timer)e.getSource();
                timer.stop();
            }
        }).start();
    }

    private void correct() {
        long v;
        long newValue = v = ((Number)this.getValue()).longValue();
        if (this.nm.getMinimum() != null) {
            newValue = Math.max(v, ((Number)((Object)this.nm.getMinimum())).longValue());
        }
        if (this.nm.getMaximum() != null) {
            newValue = Math.min(((Number)((Object)this.nm.getMaximum())).longValue(), newValue);
        }
        if (newValue != v) {
            this.beep();
            this.setValue(newValue);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.correct();
    }

    public long getBytes() {
        return ((Number)this.getValue()).longValue();
    }

    @Override
    public Object getNextValue() {
        Object ret = this.getValue();
        long num = ((Number)ret).longValue();
        SizeFormatter.Unit unit = SizeFormatter.getBestUnit(num);
        long add = this.getStep(num, unit);
        long newV = this.nm.getMaximum() != null ? Math.min(((Number)((Object)this.nm.getMaximum())).longValue(), num + add) : num + add;
        SizeFormatter.Unit newUnit = SizeFormatter.getBestUnit(newV);
        if (newUnit == unit) {
            if (newV == num) {
                this.beep();
            }
            return newV;
        }
        newV = newUnit.getBytes1024() * 1L;
        if (newV == num) {
            this.beep();
        }
        return newV;
    }

    public long getStep(long num, SizeFormatter.Unit unit) {
        long display = num / unit.getBytes1024();
        int log = display < 1L ? 0 : (int)Math.log10(display);
        long add = 0L;
        add = --log < 0 ? unit.getBytes1024() / 1024L * 100L : (long)(Math.pow(10.0, log) * (double)unit.getBytes1024());
        return Math.max(1L, add);
    }

    @Override
    public Object getPreviousValue() {
        Object ret = this.getValue();
        long num = ((Number)ret).longValue();
        SizeFormatter.Unit unit = SizeFormatter.getBestUnit(num);
        long add = this.getStep(num, unit);
        long nv = this.nm.getMinimum() != null ? Math.max(((Number)((Object)this.nm.getMinimum())).longValue(), num - add) : num - add;
        SizeFormatter.Unit nunit = SizeFormatter.getBestUnit(nv);
        if (nunit == unit) {
            if (nv == num) {
                this.beep();
            }
            return nv;
        }
        nv = nunit.getBytes1024() * 1000L;
        if (nv == num) {
            this.beep();
        }
        return nv;
    }

    protected String longToText(long longValue) {
        return SizeFormatter.formatBytes(this.numberFormat, longValue);
    }

    @Override
    public void setModel(SpinnerModel model) {
        throw new IllegalStateException("Not available");
    }

    protected Object textToObject(String text) {
        return SizeFormatter.getSize(this.numberFormat, text, true, true);
    }
}

