/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecordingGraphics2D
extends Graphics2D {
    private final Graphics2D delegate;
    private Rectangle2D drawnArea = null;
    private final List<RecordingGraphics2D> children = new ArrayList<RecordingGraphics2D>();

    public RecordingGraphics2D(Graphics2D delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        this.delegate = delegate;
    }

    public Rectangle2D getDrawnArea() {
        return this.drawnArea;
    }

    public Rectangle2D getCompleteDrawnArea() {
        Rectangle2D complete = this.drawnArea;
        for (RecordingGraphics2D child : this.children) {
            Rectangle2D childArea = child.getCompleteDrawnArea();
            if (childArea == null) continue;
            if (complete == null) {
                complete = childArea;
                continue;
            }
            complete = complete.createUnion(childArea);
        }
        return complete;
    }

    private void recordTransformed(Shape s) {
        if (s == null) {
            return;
        }
        AffineTransform currentTransform = this.getTransform();
        Shape transformedShape = currentTransform.createTransformedShape(s);
        Rectangle2D bounds = transformedShape.getBounds2D();
        this.drawnArea = this.drawnArea == null ? bounds : this.drawnArea.createUnion(bounds);
    }

    private void recordTransformed(Rectangle rect) {
        this.recordTransformed((Shape)rect);
    }

    @Override
    public void draw(Shape s) {
        this.recordTransformed(s);
    }

    @Override
    public void fill(Shape s) {
        this.recordTransformed(s);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (img != null) {
            this.recordTransformed(new Rectangle(x, y, img.getWidth(), img.getHeight()));
        }
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (img != null && xform != null) {
            int w = img.getWidth(obs);
            int h = img.getHeight(obs);
            if (w > 0 && h > 0) {
                Shape imageShape = xform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, w, h));
                this.recordTransformed(imageShape);
            }
        }
        return true;
    }

    @Override
    public void drawString(String str, int x, int y) {
        Font font = this.getFont();
        if (font != null && str != null) {
            FontRenderContext frc = this.getFontRenderContext();
            TextLayout layout = new TextLayout(str, font, frc);
            Rectangle2D bounds = layout.getBounds();
            Rectangle2D.Double shifted = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.recordTransformed(shifted);
        }
    }

    @Override
    public void drawString(String str, float x, float y) {
        Font font = this.getFont();
        if (font != null && str != null) {
            FontRenderContext frc = this.getFontRenderContext();
            TextLayout layout = new TextLayout(str, font, frc);
            Rectangle2D bounds = layout.getBounds();
            Rectangle2D.Double shifted = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.recordTransformed(shifted);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (iterator != null) {
            FontRenderContext frc = this.getFontRenderContext();
            TextLayout layout = new TextLayout(iterator, frc);
            Rectangle2D bounds = layout.getBounds();
            Rectangle2D.Double shifted = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.recordTransformed(shifted);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (iterator != null) {
            FontRenderContext frc = this.getFontRenderContext();
            TextLayout layout = new TextLayout(iterator, frc);
            Rectangle2D bounds = layout.getBounds();
            Rectangle2D.Double shifted = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.recordTransformed(shifted);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.recordTransformed(line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.recordTransformed(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.recordTransformed(new Rectangle(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.recordTransformed(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.recordTransformed(roundRect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.recordTransformed(roundRect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Double oval = new Ellipse2D.Double(x, y, width, height);
        this.recordTransformed(oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Double oval = new Ellipse2D.Double(x, y, width, height);
        this.recordTransformed(oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        this.recordTransformed(arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2);
        this.recordTransformed(arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (xPoints == null || yPoints == null || nPoints <= 0) {
            return;
        }
        Polygon polyline = new Polygon(xPoints, yPoints, nPoints);
        this.recordTransformed(polyline.getBounds());
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (xPoints == null || yPoints == null || nPoints <= 0) {
            return;
        }
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.recordTransformed(polygon.getBounds());
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (xPoints == null || yPoints == null || nPoints <= 0) {
            return;
        }
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.recordTransformed(polygon.getBounds());
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img != null && xform != null) {
            int width = img.getWidth();
            int height = img.getHeight();
            Shape imageShape = xform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, width, height));
            this.recordTransformed(imageShape);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage ri;
        if (img != null && xform != null && (ri = img.createDefaultRendering()) != null) {
            int width = ri.getWidth();
            int height = ri.getHeight();
            Shape imageShape = xform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, width, height));
            this.recordTransformed(imageShape);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (g != null) {
            Shape glyphOutline = g.getOutline(x, y);
            this.recordTransformed(glyphOutline);
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.delegate.getDeviceConfiguration();
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.recordTransformed(new Rectangle(x, y, width, height));
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img != null) {
            int w = img.getWidth(observer);
            int h = img.getHeight(observer);
            if (w > 0 && h > 0) {
                this.recordTransformed(new Rectangle(x, y, w, h));
            }
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (img != null) {
            this.recordTransformed(new Rectangle(x, y, width, height));
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img != null) {
            int w = img.getWidth(observer);
            int h = img.getHeight(observer);
            if (w > 0 && h > 0) {
                this.recordTransformed(new Rectangle(x, y, w, h));
            }
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img != null) {
            this.recordTransformed(new Rectangle(x, y, width, height));
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (img != null) {
            this.recordTransformed(new Rectangle(dx1, dy1, dx2 - dx1, dy2 - dy1));
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img != null) {
            this.recordTransformed(new Rectangle(dx1, dy1, dx2 - dx1, dy2 - dy1));
        }
        return true;
    }

    @Override
    public void clip(Shape s) {
        this.delegate.clip(s);
    }

    @Override
    public void setPaint(Paint paint) {
        this.delegate.setPaint(paint);
    }

    @Override
    public void setComposite(Composite comp) {
        this.delegate.setComposite(comp);
    }

    @Override
    public void setStroke(Stroke s) {
        this.delegate.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.delegate.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.delegate.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.delegate.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.delegate.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.delegate.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.delegate.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.delegate.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.delegate.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.delegate.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.delegate.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.delegate.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.delegate.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.delegate.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.delegate.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.delegate.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.delegate.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.delegate.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.delegate.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.delegate.getStroke();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.delegate.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.delegate.setClip(clip);
    }

    @Override
    public Shape getClip() {
        return this.delegate.getClip();
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.delegate.setClip(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.delegate.getClipBounds();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.delegate.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        Graphics g = this.delegate.create();
        RecordingGraphics2D child = new RecordingGraphics2D((Graphics2D)g);
        this.children.add(child);
        return child;
    }

    @Override
    public Color getColor() {
        return this.delegate.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.delegate.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.delegate.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.delegate.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.delegate.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.delegate.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.delegate.getFontMetrics(f);
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }
}

