/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.SwingUtils;

public class ExtTextArea
extends JTextArea
implements FocusListener,
DocumentListener,
ToolTipHandler {
    private static final long serialVersionUID = -2215616004852131754L;
    protected Color defaultColor;
    private Color helpColor;
    private TooltipFactory tooltipFactory = new TooltipTextDelegateFactory(this);
    private String helpText;

    public ExtTextArea(String infoa) {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
        this.defaultColor = this.getForeground();
        this.helpColor = (Color)UIManager.get("TextField.disabledForeground");
        if (this.helpColor == null) {
            this.helpColor = Color.LIGHT_GRAY;
        }
        this.helpText = null;
        this.setText(infoa);
    }

    public ExtTextArea() {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
        this.defaultColor = this.getForeground();
        this.helpColor = (Color)UIManager.get("TextField.disabledForeground");
        if (this.helpColor == null) {
            this.helpColor = Color.LIGHT_GRAY;
        }
        this.helpText = null;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onChanged();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (super.getText().equals(this.helpText)) {
            this.setText("");
        }
        this.setForeground(this.defaultColor);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.getDocument().getLength() == 0 || super.getText().equals(this.helpText)) {
            this.setText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public Color getHelpColor() {
        return this.helpColor;
    }

    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public void replaceSelection(String content) {
        if (super.getText().equals(this.helpText) && StringUtils.isNotEmpty(content)) {
            super.setText("");
        }
        super.replaceSelection(content);
        this.setForeground(this.defaultColor);
    }

    @Override
    public String getText() {
        String ret = super.getText();
        if (ret.equals(this.helpText)) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onChanged();
    }

    public boolean isHelpTextVisible() {
        return this.helpText != null && this.helpText.equals(super.getText());
    }

    public void onChanged() {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onChanged();
    }

    public void setHelpColor(Color helpColor) {
        this.helpColor = helpColor;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
        if (this.getText().length() == 0) {
            this.setText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public void setLabelMode(boolean b) {
        this.setEditable(!b);
        this.setFocusable(!b);
        this.setBorder(b ? null : new JTextArea().getBorder());
        SwingUtils.setOpaque(this, !b);
    }

    @Override
    public void setText(String t) {
        if (!(this.hasFocus() || this.helpText == null || t != null && t.length() != 0)) {
            t = this.helpText;
        }
        super.setText(t);
        if (this.helpText != null) {
            if (this.helpText.equals(t)) {
                this.setForeground(this.helpColor);
            } else {
                this.setForeground(this.defaultColor);
            }
        }
    }

    public ExtTextArea setTooltipsEnabled(boolean b) {
        if (b) {
            ToolTipController.getInstance().register(this);
        } else {
            ToolTipController.getInstance().unregister(this);
        }
        return this;
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
        this.setTooltipsEnabled(StringUtils.isNotEmpty(this.getToolTipText()));
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }

    @Override
    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.getTooltipFactory().createTooltip();
    }

    public void setTooltipFactory(TooltipFactory tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
        ToolTipController.getInstance().register(this);
    }

    public TooltipFactory getTooltipFactory() {
        return this.tooltipFactory;
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return true;
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }
}

