/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.images.IconPipe;

public class ExtMergedIcon
implements Icon,
IDIcon {
    private int cropedWidth = -1;
    private int cropedHeight = -1;
    protected final TreeSet<Entry> entries = new TreeSet<Entry>(new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return CompareUtils.compareInt(o1.z, o2.z);
        }
    });
    private int width = 0;
    private int height = 0;
    private ImageIcon internalIcon;
    private boolean caching;
    protected IconIdentifier internalID;
    private static final boolean MONITOR_SCALING = ExtMergedIcon.hasMonitorScaling();

    public ExtMergedIcon() {
    }

    public ExtMergedIcon(Icon icon) {
        this(icon, 0, 0, 0, null);
    }

    public ExtMergedIcon(Icon icon, int x, int y) {
        this.addEntry(new Entry(icon, x, y, 0, null, null));
    }

    public ExtMergedIcon(Icon icon, int x, int y, int z, Composite c) {
        this.addEntry(new Entry(icon, x, y, z, c, null));
    }

    private static boolean hasMonitorScaling() {
        if (Application.isHeadless()) {
            return false;
        }
        for (GraphicsDevice sd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            AffineTransform tx = sd.getDefaultConfiguration().getDefaultTransform();
            if (tx.getScaleX() == 1.0 && tx.getScaleY() == 1.0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtMergedIcon add(Icon icon) {
        TreeSet<Entry> treeSet = this.entries;
        synchronized (treeSet) {
            return this.add(icon, 0, 0, this.entries.size(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtMergedIcon add(Icon icon, int x, int y) {
        TreeSet<Entry> treeSet = this.entries;
        synchronized (treeSet) {
            return this.add(icon, x, y, this.entries.size(), null);
        }
    }

    public ExtMergedIcon add(Icon icon, int x, int y, int z, Composite c, Shape clip) {
        this.addEntry(new Entry(icon, x, y, z, c, clip));
        return this;
    }

    public ExtMergedIcon add(Icon icon, int x, int y, int z, Composite c) {
        this.addEntry(new Entry(icon, x, y, z, c, null));
        return this;
    }

    private void addEntry(Entry entry) {
        if (this.internalIcon != null) {
            throw new IllegalStateException("internalIcon is set");
        }
        this.width = Math.max(this.width, entry.x + entry.icon.getIconWidth());
        this.height = Math.max(this.height, entry.y + entry.icon.getIconHeight());
        this.idIconCheck(entry);
        this.entries.add(entry);
    }

    protected void idIconCheck(Entry entry) {
        Icon icon = entry.icon;
        while (icon != null && icon instanceof IconPipe) {
            if (icon instanceof IDIcon) {
                return;
            }
            icon = ((IconPipe)((Object)icon)).getDelegate();
        }
        if (icon != null && icon instanceof IDIcon) {
            return;
        }
        if (icon != null && icon.getClass().isAnonymousClass()) {
            return;
        }
        if (!Application.isJared(null)) {
            new Exception(this.getClass() + ": Warning. Not an  IDIcon").printStackTrace();
        }
    }

    public void cache() {
        this.caching = true;
        try {
            this.internalIcon = ImageProvider.toImageIcon(this);
            this.internalID = this.getIdentifier();
            this.entries.clear();
        }
        finally {
            this.caching = false;
        }
    }

    public ExtMergedIcon crop(int width, int height) {
        this.cropedWidth = width;
        this.cropedHeight = height;
        return this;
    }

    @Override
    public int getIconHeight() {
        if (this.cropedHeight > 0) {
            return this.cropedHeight;
        }
        return this.height;
    }

    @Override
    public int getIconWidth() {
        if (this.cropedWidth > 0) {
            return this.cropedWidth;
        }
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.internalIcon == null && !this.caching && !MONITOR_SCALING) {
            this.cache();
        }
        if (this.internalIcon != null) {
            g2.drawImage(this.internalIcon.getImage(), x, y, null);
            return;
        }
        Shape oldClip = g2.getClip();
        g2.setClip(x, y, this.getIconWidth(), this.getIconHeight());
        Shape defClip = g2.getClip();
        for (Entry e : this.entries) {
            if (e.clip != null) {
                g2.setClip(e.clip);
            }
            this.paintSingleIcon(c, x, y, g2, e);
            g2.setClip(defClip);
        }
        g2.setClip(oldClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSingleIcon(Component c, int x, int y, Graphics2D g2, Entry e) {
        Composite com = g2.getComposite();
        try {
            if (e.composite != null) {
                g2.setComposite(e.composite);
            }
            e.icon.paintIcon(c, g2, x + e.x, y + e.y);
        }
        finally {
            if (com != null) {
                g2.setComposite(com);
            }
        }
    }

    @Override
    public IconIdentifier getIdentifier() {
        if (this.internalID != null) {
            return this.internalID;
        }
        IconIdentifier t = new IconIdentifier("Merge");
        if (this.cropedHeight > 0) {
            t.addProperty("cropedHeight", this.cropedHeight);
        }
        if (this.cropedWidth > 0) {
            t.addProperty("cropedWidth", this.cropedWidth);
        }
        t.addProperty("height", this.getIconHeight());
        t.addProperty("width", this.getIconWidth());
        for (Entry e : this.entries) {
            if (e.icon instanceof IDIcon) {
                IconIdentifier id = ((IDIcon)((Object)e.icon)).getIdentifier();
                if (e.x != 0) {
                    id.addProperty("x", e.x);
                }
                if (e.y != 0) {
                    id.addProperty("y", e.y);
                }
                id.addProperty("height", e.icon.getIconHeight());
                id.addProperty("width", e.icon.getIconWidth());
                t.add(id);
                continue;
            }
            t.add(new IconIdentifier("unknown", e.icon.toString()));
        }
        return t;
    }

    protected class Entry {
        public final Icon icon;
        public final int x;
        public final int y;
        public final Composite composite;
        public final int z;
        public final Shape clip;

        public Entry(Icon icon, int x, int y, int z, Composite c, Shape clip) {
            this.icon = icon;
            this.x = x;
            this.y = y;
            this.composite = c;
            this.z = z;
            this.clip = clip;
        }
    }
}

