/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.models.ConfigToggleButtonModel;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;

public class ExtCheckBox
extends JCheckBox
implements ToolTipHandler {
    private static final long serialVersionUID = 3223817461429862778L;
    private JComponent[] dependencies;
    private TooltipTextDelegateFactory tooltipFactory = new TooltipTextDelegateFactory(this);

    public ExtCheckBox(JComponent ... components) {
        SwingUtils.setOpaque(this, false);
        this.setDependencies(components);
    }

    public ExtCheckBox(BooleanKeyHandler keyhandler, JComponent ... components) {
        this(new KeyHandlerProviderBridge<Boolean>(keyhandler), components);
    }

    public ExtCheckBox(ValueProvider<Boolean> provider, JComponent ... components) {
        this(components);
        this.setModel(new ConfigToggleButtonModel(provider));
        this.updateDependencies();
    }

    @Override
    public void setModel(ButtonModel newModel) {
        super.setModel(newModel);
        newModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                new EDTRunner(){

                    @Override
                    protected void runInEDT() {
                        ExtCheckBox.this.updateDependencies();
                    }
                };
            }
        });
    }

    public JComponent[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(JComponent ... dependencies) {
        this.dependencies = dependencies;
        this.updateDependencies();
    }

    public TooltipTextDelegateFactory getTooltipFactory() {
        return this.tooltipFactory;
    }

    public void setTooltipFactory(TooltipTextDelegateFactory tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
    }

    public void updateDependencies() {
        if (this.dependencies != null) {
            ArrayList<ExtCheckBox> boxes = new ArrayList<ExtCheckBox>();
            for (JComponent c : this.dependencies) {
                c.setEnabled(this.getDependenciesLogic(c, this.isSelected()));
                if (!(c instanceof ExtCheckBox)) continue;
                boxes.add((ExtCheckBox)c);
            }
            for (ExtCheckBox box : boxes) {
                box.updateDependencies();
            }
        }
    }

    protected boolean getDependenciesLogic(JComponent c, boolean b) {
        return b;
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }

    @Override
    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.getTooltipFactory().createTooltip();
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return true;
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }

    public JComponent addDependency(JComponent c) {
        JComponent[] newDeps = new JComponent[this.dependencies.length + 1];
        System.arraycopy(this.dependencies, 0, newDeps, 0, this.dependencies.length);
        newDeps[newDeps.length - 1] = c;
        this.dependencies = newDeps;
        this.updateDependencies();
        return c;
    }
}

