/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.appwork.loggingv3.LogV3;
import org.appwork.swing.components.HeadlessCheckboxIconRef;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.swing.components.RecordingGraphics2D;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.ScalableIcon;

public final class CheckBoxIcon
implements Icon,
ScalableIcon,
IDIcon {
    public static final Icon FALSE = new CheckBoxIcon(false);
    public static final Icon TRUE = new CheckBoxIcon(true);
    public static final Icon UNDEFINED = new CheckBoxIcon(true, false);
    private int size;
    private final JCheckBox checkBox;
    private Rectangle2D unscaledDimensionAndPosition;
    private final Image image;
    private boolean selected;
    private boolean enabled;

    public CheckBoxIcon(boolean selected, boolean enabled) {
        this(-1, selected, enabled);
    }

    protected Image buildHeadlessCheckBoxIcon(int size, boolean selected, boolean enabled) {
        Image ret = selected ? HeadlessCheckboxIconRef.HEADLESS_checkbox_true.image(size) : HeadlessCheckboxIconRef.HEADLESS_checkbox_false.image(size);
        if (!enabled) {
            return IconIO.toGrayScale(ret);
        }
        return ret;
    }

    public CheckBoxIcon(int size, boolean selected, boolean enabled) {
        this.selected = selected;
        this.enabled = enabled;
        this.size = size;
        if (Application.isHeadless()) {
            this.checkBox = null;
            this.image = this.buildHeadlessCheckBoxIcon(size, selected, enabled);
        } else {
            Image image = null;
            JCheckBox checkBox = null;
            try {
                checkBox = new JCheckBox();
                checkBox.setEnabled(enabled);
                checkBox.setSelected(selected);
                checkBox.setSize(checkBox.getPreferredSize());
                checkBox.setOpaque(false);
                checkBox.setContentAreaFilled(true);
                BufferedImage dummy = IconIO.createEmptyImage(32, 32);
                Graphics2D g2d = (Graphics2D)dummy.getGraphics();
                g2d.setTransform(new AffineTransform());
                RecordingGraphics2D record = new RecordingGraphics2D(g2d);
                checkBox.paint(record);
                g2d.dispose();
                this.unscaledDimensionAndPosition = record.getCompleteDrawnArea();
            }
            catch (Exception e) {
                checkBox = null;
                LogV3.log(e);
                image = this.buildHeadlessCheckBoxIcon(size, selected, enabled);
            }
            this.checkBox = checkBox;
            this.image = image;
        }
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics gOrg, int x, int y) {
        this.paintIcon(c, gOrg, x, y, this.getIconWidth(), this.getIconHeight());
    }

    public CheckBoxIcon(boolean selected) {
        this(selected, true);
    }

    @Override
    public int getIconWidth() {
        if (this.image != null) {
            return this.image.getWidth(null);
        }
        if (this.size <= 0) {
            return (int)this.unscaledDimensionAndPosition.getWidth();
        }
        return this.size;
    }

    @Override
    public int getIconHeight() {
        if (this.image != null) {
            return this.image.getHeight(null);
        }
        if (this.size <= 0) {
            return (int)this.unscaledDimensionAndPosition.getHeight();
        }
        return this.size;
    }

    @Override
    public IconIdentifier getIdentifier() {
        return new IconIdentifier("CheckBoxIcon_" + (this.selected ? "true" : "false") + (this.enabled ? "_enabled" : "_disabled"));
    }

    @Override
    public void setIconHeight(int iconHeight) {
        this.size = iconHeight;
    }

    @Override
    public void setIconWidth(int iconWidth) {
        this.size = iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics gOrg, int x, int y, int width, int height) {
        if (this.image != null) {
            gOrg.drawImage(IconIO.getScaledInstance(this.image, width, height), x, y, c);
            return;
        }
        Graphics g = gOrg.create();
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(x, y);
        AffineTransform orgTf = g2d.getTransform();
        double componentScaleX = (double)height / this.unscaledDimensionAndPosition.getWidth();
        double componentScaleY = (double)width / this.unscaledDimensionAndPosition.getHeight();
        g2d.scale(componentScaleX, componentScaleY);
        g2d.translate(-this.unscaledDimensionAndPosition.getX(), -this.unscaledDimensionAndPosition.getY());
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            // empty if block
        }
        this.checkBox.paint(g2d);
        g2d.dispose();
    }
}

