/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing;

import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import org.appwork.swing.PropertyStateEventProviderInterface;
import org.appwork.swing.event.PropertySetEvent;
import org.appwork.swing.event.PropertySetEventSender;
import org.appwork.utils.Application;
import org.appwork.utils.os.CrossSystem;

public class ExtJFrame
extends JFrame
implements PropertyStateEventProviderInterface {
    public static final String PROPERTY_LOCATION = "location";
    public static final String PROPERTY_EXTENDED_STATE = "extendedState";
    public static final String PROPERTY_FOCUSABLE = "focusable";
    public static final String PROPERTY_FOCUSABLE_WINDOW_STATE = "focusableWindowState";
    public static final String PROPERTY_ALWAYS_ON_TOP = "alwaysOnTop";
    public static final String PROPERTY_VISIBLE = "visible";
    private PropertySetEventSender propertySetEventSender;

    public ExtJFrame() throws HeadlessException {
        this.macSpecials();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void macSpecials() {
        if (CrossSystem.isMac() && Application.getJavaVersion() == 17025015L) {
            this.addWindowStateListener(new WindowStateListener(){
                private boolean oldVisibleState = true;

                @Override
                public void windowStateChanged(WindowEvent e) {
                    if ((ExtJFrame.this.getExtendedState() & 1) == 1) {
                        this.oldVisibleState = ExtJFrame.this.isVisible();
                        ExtJFrame.this.setVisible(false);
                    } else {
                        ExtJFrame.this.setVisible(this.oldVisibleState);
                    }
                }
            });
        }
    }

    public ExtJFrame(GraphicsConfiguration graphicsconfiguration) {
        super(graphicsconfiguration);
        this.macSpecials();
    }

    public ExtJFrame(String s) throws HeadlessException {
        super(s);
        this.macSpecials();
    }

    public ExtJFrame(String s, GraphicsConfiguration graphicsconfiguration) {
        super(s, graphicsconfiguration);
        this.macSpecials();
    }

    @Override
    protected void firePropertyChange(String s, boolean flag, boolean flag1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, flag, flag1));
        }
        super.firePropertyChange(s, flag, flag1);
    }

    @Override
    public void firePropertyChange(String s, byte byte0, byte byte1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, byte0, byte1));
        }
        super.firePropertyChange(s, byte0, byte1);
    }

    @Override
    public void firePropertyChange(String s, char c, char c1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, Character.valueOf(c), Character.valueOf(c1)));
        }
        super.firePropertyChange(s, c, c1);
    }

    @Override
    public void firePropertyChange(String s, double d, double d1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, d, d1));
        }
        super.firePropertyChange(s, d, d1);
    }

    @Override
    public void firePropertyChange(String s, float f, float f1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, Float.valueOf(f), Float.valueOf(f1)));
        }
        super.firePropertyChange(s, f, f1);
    }

    @Override
    protected void firePropertyChange(String s, int i, int j) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, i, j));
        }
        super.firePropertyChange(s, i, j);
    }

    @Override
    public void firePropertyChange(String s, long l, long l1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, l, l1));
        }
        super.firePropertyChange(s, l, l1);
    }

    @Override
    protected void firePropertyChange(String s, Object obj, Object obj1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, obj, obj));
        }
        super.firePropertyChange(s, obj, obj1);
    }

    @Override
    public void firePropertyChange(String s, short word0, short word1) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, s, word0, word1));
        }
        super.firePropertyChange(s, word0, word1);
    }

    @Override
    public PropertySetEventSender getPropertySetEventSender() {
        if (this.propertySetEventSender == null) {
            this.propertySetEventSender = new PropertySetEventSender();
        }
        return this.propertySetEventSender;
    }

    @Override
    public void setExtendedState(int i) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, PROPERTY_EXTENDED_STATE, this.getExtendedState(), i));
        }
        super.setExtendedState(i);
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.propertySetEventSender != null) {
            this.propertySetEventSender.fireEvent(new PropertySetEvent(this, PropertySetEvent.Type.SET, PROPERTY_LOCATION, this.getLocation(), new Point(x, y)));
        }
        super.setLocation(x, y);
    }
}

