/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.DeSerializerInput;
import org.appwork.storage.JSONMapper;
import org.appwork.storage.JsonDeSerializer;
import org.appwork.storage.JsonSerializer;
import org.appwork.storage.SelfJSONDeSerializer;
import org.appwork.storage.SelfJSONSerializer;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.storage.converter.ConverterInput;
import org.appwork.storage.converter.JsonConverterForDeserialization;
import org.appwork.storage.converter.JsonConverterForSerialization;
import org.appwork.storage.converter.SelfJsonConverterForDeserialization;
import org.appwork.storage.converter.SelfJsonConverterForSerialization;
import org.appwork.testframework.AWTest;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.HexFormatter;

public abstract class JsonDEserializerTests
extends AWTest {
    public static Object CONTEXT;
    private static boolean FLAG;

    protected void testOnMapper(JSONMapper mapper, Object serializerContext) throws Exception {
        CONTEXT = mapper;
        JsonDEserializerTests.logInfoAnyway("Test mapper : " + mapper.getClass().getSimpleName());
        this.testSerializeDeserializeSelfSerializer(mapper);
        this.testSerializeDeserializeSelfConverter(mapper);
        this.testHiddenInterfaces(mapper);
        this.testAddingAConverter(mapper);
        this.testAddingASerializer(mapper);
        this.testAddingAConverter(mapper);
        this.testAddingASerializer(mapper);
        this.testConvertStringToHex(mapper);
        this.testConverterClassHirarchy(mapper);
        this.testNullSerializerAndObjectDeserializer(mapper);
    }

    protected void testNullSerializerAndObjectDeserializer(JSONMapper mapper) throws Exception {
        mapper.putSerializer(null, new JsonSerializer(){

            @Override
            public String toJSonString(Object object, Object mapper) {
                FLAG = false;
                return "\"null\"";
            }
        });
        mapper.putDeSerializer(Object.class, new JsonDeSerializer(){

            @Override
            public Object toObject(DeSerializerInput input, TypeRef<?> typeRef, Object mapper) {
                String json = input.getJSONRepresentation();
                if ("\"null\"".equals(json)) {
                    FLAG = false;
                    return null;
                }
                return input;
            }
        });
        FLAG = true;
        HashMap<String, String> org = new HashMap<String, String>();
        org.put("a", null);
        org.put("b", "null");
        String json = mapper.objectToString(org);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, Map.class);
        FLAG = true;
        HashMap<String, String> restored = mapper.stringToObject(json, new TypeRef<HashMap<String, String>>(){});
        JsonDEserializerTests.assertType(restored, Map.class);
        JsonDEserializerTests.assertFalse(FLAG);
        JsonDEserializerTests.assertEquals(restored.get("a"), null);
        JsonDEserializerTests.assertEquals(restored.get("b"), null);
    }

    protected void testConverterClassHirarchy(JSONMapper mapper) throws Exception {
        mapper.putConverterForSerialization(ArrayList.class, new JsonConverterForSerialization(){

            @Override
            public Object convertForSerialization(Object obj, Object mapper) {
                FLAG = false;
                return StringUtils.join((ArrayList)obj, ",");
            }
        });
        mapper.putConverterFromDeserialization(ArrayList.class, new JsonConverterForDeserialization(){

            @Override
            public Object convertForDeserialization(ConverterInput input, TypeRef<?> typeRef, Object mapper) {
                Object object = input.getGenericRepresentation();
                return new ArrayList<String>(Arrays.asList(((String)object).split(",")));
            }
        });
        FLAG = true;
        ArrayList<String> org = new ArrayList<String>(Arrays.asList("1", "2", "3"));
        String json = mapper.objectToString(org);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, String.class);
        List restored = mapper.stringToObject(json, new TypeRef<ArrayList<String>>(){});
        JsonDEserializerTests.assertType(restored, ArrayList.class);
        JsonDEserializerTests.assertFalse(FLAG);
        JsonDEserializerTests.assertEqualsDeep(org, restored);
    }

    protected void testConvertStringToHex(JSONMapper mapper) throws Exception {
        mapper.putConverterForSerialization(String.class, new JsonConverterForSerialization(){

            @Override
            public Object convertForSerialization(Object obj, Object mapper) {
                if (((String)obj).startsWith("___")) {
                    return obj;
                }
                FLAG = false;
                try {
                    return "___" + HexFormatter.byteArrayToHex(((String)obj).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new WTFException(e);
                }
            }
        });
        mapper.putConverterFromDeserialization(String.class, new JsonConverterForDeserialization(){

            @Override
            public Object convertForDeserialization(ConverterInput input, TypeRef<?> typeRef, Object mapper) {
                Object generic = input.getGenericRepresentation();
                if (generic == null) {
                    FLAG = false;
                    return input;
                }
                if (((String)generic).startsWith("___")) {
                    FLAG = false;
                    try {
                        return new String(HexFormatter.hexToByteArray(((String)generic).substring(3)), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new WTFException();
                    }
                }
                return input;
            }
        });
        FLAG = true;
        List<String> org = Arrays.asList("1", "2", "3");
        String json = mapper.objectToString(org);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, Map.class);
        List<String> restored = mapper.stringToObject(json, new TypeRef<List<String>>(){});
        JsonDEserializerTests.assertType(restored, ArrayList.class);
        JsonDEserializerTests.assertFalse(FLAG);
        JsonDEserializerTests.assertEqualsDeep(org, restored);
        mapper.putConverterForSerialization(String.class, null);
        mapper.putConverterFromDeserialization(String.class, null);
    }

    protected void testAddingAConverter(JSONMapper mapper) throws Exception {
        mapper.putConverterForSerialization(List.class, new JsonConverterForSerialization(){

            @Override
            public Object convertForSerialization(Object obj, Object mapper) {
                FLAG = false;
                HashMap map = new HashMap();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    map.put("" + i, ((List)obj).get(i));
                }
                return map;
            }
        });
        mapper.putConverterFromDeserialization(List.class, new JsonConverterForDeserialization(){

            @Override
            public Object convertForDeserialization(ConverterInput input, TypeRef<?> typeRef, Object mapper) {
                Object object = input.getGenericRepresentation();
                FLAG = false;
                if (!(object instanceof Map)) {
                    return object;
                }
                HashMap map = (HashMap)object;
                int i = 0;
                ArrayList<Object> list = new ArrayList<Object>();
                while (map.containsKey(i + "")) {
                    Object entry = ((JSONMapper)mapper).convert(map.get(i + ""), new TypeRef<Object>(((ParameterizedType)typeRef.getType()).getActualTypeArguments()[0]){});
                    list.add(entry);
                    ++i;
                }
                return list;
            }
        });
        FLAG = true;
        List<String> org = Arrays.asList("1", "2", "3");
        String json = mapper.objectToString(org);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, Map.class);
        List<String> restored = mapper.stringToObject(json, new TypeRef<List<String>>(){});
        JsonDEserializerTests.assertType(restored, ArrayList.class);
        JsonDEserializerTests.assertFalse(FLAG);
        JsonDEserializerTests.assertEqualsDeep(org, restored);
    }

    protected void testAddingASerializer(JSONMapper mapper) throws Exception {
        mapper.putSerializer(List.class, new JsonSerializer(){

            @Override
            public String toJSonString(Object object, Object mapper) {
                FLAG = false;
                HashMap map = new HashMap();
                for (int i = 0; i < ((List)object).size(); ++i) {
                    map.put("" + i, ((List)object).get(i));
                }
                return ((JSONMapper)mapper).objectToString(map);
            }
        });
        mapper.putDeSerializer(List.class, new JsonDeSerializer(){

            @Override
            public Object toObject(DeSerializerInput input, TypeRef<?> typeRef, Object mapper) {
                FLAG = false;
                HashMap<String, String> map = ((JSONMapper)mapper).stringToObject(input.getJSONRepresentation(), TypeRef.HASHMAP_STRING);
                int i = 0;
                ArrayList<String> list = new ArrayList<String>();
                while (map.containsKey(i + "")) {
                    list.add(map.get(i + ""));
                    ++i;
                }
                return list;
            }
        });
        FLAG = true;
        List<String> org = Arrays.asList("1", "2", "3");
        String json = mapper.objectToString(org);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, Map.class);
        List<String> restored = mapper.stringToObject(json, new TypeRef<List<String>>(){});
        JsonDEserializerTests.assertType(restored, ArrayList.class);
        JsonDEserializerTests.assertFalse(FLAG);
        JsonDEserializerTests.assertEqualsDeep(org, restored);
    }

    protected void testSerializeDeserializeSelfConverter(JSONMapper mapper) throws Exception {
        TestObjSelfConverter self = new TestObjSelfConverter();
        self.setTime(Time.timestamp());
        FLAG = true;
        String json = mapper.objectToString(self);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, String.class);
        FLAG = true;
        TestObjSelfConverter<String> restored = mapper.stringToObject(json, new TypeRef<TestObjSelfConverter<String>>(){});
        JsonDEserializerTests.assertFalse(FLAG);
        if (!CompareUtils.equalsDeep(self, restored)) {
            throw new Exception("Self Converter failed");
        }
    }

    protected void testSerializeDeserializeSelfSerializer(JSONMapper mapper) throws Exception {
        TestObjSelfSerializer self = new TestObjSelfSerializer();
        self.setTime(Time.timestamp());
        FLAG = true;
        String json = mapper.objectToString(self);
        JsonDEserializerTests.assertFalse(FLAG);
        Object restoreTEst = mapper.stringToObject(json, TypeRef.OBJECT);
        JsonDEserializerTests.assertType(restoreTEst, String.class);
        FLAG = true;
        TestObjSelfSerializer<String> restored = mapper.stringToObject(json, new TypeRef<TestObjSelfSerializer<String>>(){});
        JsonDEserializerTests.assertFalse(FLAG);
        if (!CompareUtils.equalsDeep(self, restored)) {
            throw new Exception("Self deSERIALIZER failed");
        }
    }

    protected void testHiddenInterfaces(JSONMapper mapper) {
        HiddenInterfaceTestObjSelfSerializer bad = new HiddenInterfaceTestObjSelfSerializer();
        bad.setTime(Time.timestamp());
        try {
            mapper.objectToString(bad);
            throw new Exception("This call must throw an exception, because the selfserializer interface is 'hidden'.");
        }
        catch (Exception exception) {
            TestObjSelfSerializer self = new TestObjSelfSerializer();
            self.setTime(Time.timestamp());
            try {
                mapper.stringToObject(mapper.objectToString(self), HiddenInterfaceTestObjSelfSerializer.TYPE);
                throw new Exception("This call must throw an exception, because the selfdeserializer interface is 'hidden'.");
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public static class TestObjSelfConverter<T>
    implements Storable,
    SelfJsonConverterForSerialization,
    SelfJsonConverterForDeserialization {
        public static final TypeRef<TestObjSelfConverter> TYPE = new TypeRef<TestObjSelfConverter>(TestObjSelfConverter.class){};
        private T generic;
        private long time;

        public T getGeneric() {
            return this.generic;
        }

        public void setGeneric(T generic) {
            this.generic = generic;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public Object convertForSerialization(Object mapperContext) {
            if (mapperContext == null) {
                throw new WTFException("Mapper Context is missing");
            }
            if (CONTEXT != mapperContext) {
                throw new WTFException("Mapper Context does not match Expected: " + CONTEXT + " IS: " + mapperContext);
            }
            FLAG = false;
            return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").format(new Date(this.getTime()));
        }

        @Override
        public void restoreForDeserialization(ConverterInput input, Object mapperContext) {
            try {
                Object deserializedObject = input.getGenericRepresentation();
                AWTest.assertNotNull(deserializedObject);
                AWTest.assertType(deserializedObject, String.class);
                if (mapperContext == null) {
                    throw new WTFException("Mapper Context is missing");
                }
                if (CONTEXT != mapperContext) {
                    throw new WTFException("Mapper Context does not match Expected: " + CONTEXT + " IS: " + mapperContext);
                }
                try {
                    this.setTime(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").parse((String)deserializedObject).getTime());
                    FLAG = false;
                }
                catch (ParseException e) {
                    throw new WTFException(e);
                }
            }
            catch (Exception e1) {
                throw new WTFException(e1);
            }
        }
    }

    public static class TestObjSelfSerializer<T>
    implements Storable,
    SelfJSONSerializer,
    SelfJSONDeSerializer {
        public static final TypeRef<TestObjSelfSerializer> TYPE = new TypeRef<TestObjSelfSerializer>(TestObjSelfSerializer.class){};
        private T generic;
        private long time;

        public T getGeneric() {
            return this.generic;
        }

        public void setGeneric(T generic) {
            this.generic = generic;
        }

        @Override
        public String serializeToJSON(Object mapper) {
            if (mapper == null) {
                throw new WTFException("Mapper Context is missing");
            }
            if (CONTEXT != mapper) {
                throw new WTFException("Mapper Context does not match Expected: " + CONTEXT + " IS: " + mapper);
            }
            FLAG = false;
            return ((JSONMapper)mapper).objectToString(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").format(new Date(this.getTime())));
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public void deserializeFromJSON(DeSerializerInput input, Object mapper) {
            if (mapper == null) {
                throw new WTFException("Mapper Context is missing");
            }
            if (CONTEXT != mapper) {
                throw new WTFException("Mapper Context does not match Expected: " + CONTEXT + " IS: " + mapper);
            }
            try {
                this.setTime(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").parse(((JSONMapper)mapper).stringToObject(input.getJSONRepresentation(), TypeRef.STRING)).getTime());
                FLAG = false;
            }
            catch (ParseException e) {
                throw new WTFException(e);
            }
        }
    }

    public static class HiddenInterfaceTestObjSelfSerializer
    extends TestObjSelfSerializer {
        public static final TypeRef<HiddenInterfaceTestObjSelfSerializer> TYPE = new TypeRef<HiddenInterfaceTestObjSelfSerializer>(HiddenInterfaceTestObjSelfSerializer.class){};
    }
}

