/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import java.util.ArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.simplejson.JSonNode;

public class GenericJsonArray<T extends JSonNode>
extends ArrayList<T> {
    public GenericJsonArray() {
    }

    public GenericJsonArray(int size) {
        super(size);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JSonNode n : this) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(n.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toPrettyString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("[\r\n");
            for (JSonNode n : this) {
                if (sb.length() > 3) {
                    sb.append(",\r\n");
                }
                String[] lines = n.toPrettyString().split("[\r\n]+");
                boolean first = true;
                for (String line : lines) {
                    if (!first) {
                        sb.append("\r\n");
                    }
                    first = false;
                    sb.append(" " + line);
                }
            }
            sb.append("\r\n]");
            if (sb.length() < 40) {
                return this.toString();
            }
        }
        catch (Throwable e) {
            System.out.println(1);
            throw new WTFException(e);
        }
        return sb.toString();
    }
}

