/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.protobuf;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.appwork.storage.protobuf.WireType;

public class Decoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Map<Integer, Object> toMap(List<Record> records, boolean byteArrayToString) {
        if (records != null) {
            LinkedHashMap<Integer, Object> ret = new LinkedHashMap<Integer, Object>();
            for (Record record : records) {
                Integer fieldNum = record.getFieldNum();
                Object entry = ret.get(fieldNum);
                Map<Integer, Object> payLoad = record.getPayLoad();
                if (payLoad instanceof List) {
                    payLoad = this.toMap((List)((Object)payLoad), byteArrayToString);
                } else if (payLoad instanceof byte[] && byteArrayToString) {
                    payLoad = new String((byte[])payLoad, UTF8);
                }
                if (entry == null) {
                    ret.put(fieldNum, payLoad);
                    continue;
                }
                if (entry instanceof List) {
                    ((List)entry).add(payLoad);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(entry);
                list.add(payLoad);
                ret.put(fieldNum, list);
            }
            return ret;
        }
        return null;
    }

    public List<Record> decode(InputStream is) throws Exception {
        RecordTag next;
        ArrayList<Record> records = new ArrayList<Record>();
        block7: while ((next = this.nextField(is)) != null) {
            Record record = new Record(next);
            records.add(record);
            switch (next.getType()) {
                case VARINT: {
                    long value = this.readVarInt(is, true);
                    if (value <= 127L && value >= -128L) {
                        record.setPayLoad((byte)value);
                        continue block7;
                    }
                    if (value <= 32767L && value >= -32768L) {
                        record.setPayLoad((short)value);
                        continue block7;
                    }
                    if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                        record.setPayLoad((int)value);
                        continue block7;
                    }
                    record.setPayLoad(value);
                    continue block7;
                }
                case I32: 
                case I64: {
                    long value;
                    int len = WireType.I64.equals((Object)next.getType()) ? 8 : 4;
                    byte[] bytes = new byte[len];
                    new DataInputStream(is).readFully(bytes);
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    long l = value = len == 8 ? buffer.getLong() : (long)buffer.getInt();
                    if (value <= 127L && value >= -128L) {
                        record.setPayLoad((byte)value);
                        continue block7;
                    }
                    if (value <= 32767L && value >= -32768L) {
                        record.setPayLoad((short)value);
                        continue block7;
                    }
                    if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                        record.setPayLoad((int)value);
                        continue block7;
                    }
                    record.setPayLoad(value);
                    continue block7;
                }
                case LEN: {
                    long len = this.readVarInt(is, true);
                    if (len > Integer.MAX_VALUE) {
                        throw new ArithmeticException(len + " doesn't fit into Integer");
                    }
                    byte[] bytes = new byte[(int)len];
                    new DataInputStream(is).readFully(bytes);
                    record.setPayLoad(bytes);
                    try {
                        List<Record> value = this.decode(new ByteArrayInputStream(bytes));
                        if (value == null) continue block7;
                        record.setPayLoad(value);
                    }
                    catch (Exception exception) {}
                    continue block7;
                }
            }
            throw new Exception("Unsupported:" + next);
        }
        if (records.size() == 0) {
            return null;
        }
        return records;
    }

    public RecordTag nextField(InputStream is) throws IOException {
        long tag = this.readVarInt(is, false);
        if (tag == -1L) {
            return null;
        }
        int wireTypeID = (int)tag & 7;
        int fieldNum = (int)tag >> 3;
        WireType wireType = WireType.parse(wireTypeID);
        if (wireType != null) {
            return new RecordTag(wireType, fieldNum);
        }
        throw new IOException("Unsupported wireType:" + wireTypeID);
    }

    public long readVarInt(InputStream is, boolean alwaysThrowEOF) throws IOException {
        long ret = 0L;
        int shift = 0;
        while (true) {
            int read;
            if ((read = is.read()) == -1) {
                if (shift > 0 && alwaysThrowEOF) {
                    throw new EOFException();
                }
                return -1L;
            }
            long value = read & 0x7F;
            int msb = (read & 0xFF) >> 7;
            ret |= value << shift;
            if (msb == 0) {
                return ret;
            }
            shift += 7;
        }
    }

    public static class Record {
        private final RecordTag tag;
        private Object payLoad;

        public Object getPayLoad() {
            return this.payLoad;
        }

        protected void setPayLoad(Object payLoad) {
            this.payLoad = payLoad;
        }

        public RecordTag getTag() {
            return this.tag;
        }

        public WireType getType() {
            return this.getTag().getType();
        }

        public int getFieldNum() {
            return this.getTag().getFieldNum();
        }

        private Record(RecordTag tag) {
            this.tag = tag;
        }

        public String toString() {
            if (this.getPayLoad() instanceof byte[]) {
                return this.getTag() + "=" + new String((byte[])this.getPayLoad());
            }
            return this.getTag() + "=" + this.getPayLoad();
        }
    }

    public static class RecordTag {
        private final WireType type;
        private final int fieldNum;

        public WireType getType() {
            return this.type;
        }

        public int getFieldNum() {
            return this.fieldNum;
        }

        private RecordTag(WireType type, int fieldNum) {
            this.type = type;
            this.fieldNum = fieldNum;
        }

        public String toString() {
            return (Object)((Object)this.getType()) + "@" + this.getFieldNum();
        }
    }
}

