/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.tests;

import java.lang.reflect.Type;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefault;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.testframework.AWTest;
import org.appwork.utils.reflection.CompiledType;

public class InterfaceMapperTest
extends AWTest {
    public static void main(String[] args) {
        InterfaceMapperTest.run();
    }

    @Override
    public void runTest() throws Exception {
        TestObj obj = new TestObj();
        obj.setSub(new TestObj(3));
        FlexiJSonMapper mapper = new FlexiJSonMapper(){

            protected InterfaceStorage createInterfaceInvocationHandler(CompiledType cType, FlexiJSonObject obj) throws SecurityException, NoSuchMethodException {
                return new InterfaceStorage(this, cType, obj);
            }
        };
        FlexiJSonNode node = mapper.objectToJsonNode(obj);
        TestInterface proxy = (TestInterface)mapper.jsonToObject(node, new SimpleTypeRef((Type)((Object)TestInterface.class)));
        TestInterface proxy2 = (TestInterface)mapper.jsonToObject(FlexiUtils.copyOf(node), new SimpleTypeRef((Type)((Object)TestInterface.class)));
        TestInterface proxy3 = (TestInterface)mapper.jsonToObject(mapper.objectToJsonNode(obj), new SimpleTypeRef((Type)((Object)TestInterface.class)));
        mapper.setIgnoreDefaultValuesEnabled(true);
        ((FlexiJSonObject)node).remove("sub");
        InterfaceMapperTest.assertNull(proxy.getSub());
        System.out.println(proxy.toString());
        InterfaceMapperTest.assertNotNull(proxy2.getSub());
        int oldInt = proxy2.getSub().getInt();
        proxy2.getSub().setInt(7);
        InterfaceMapperTest.assertEquals(proxy2.getSub().getInt(), 7);
        proxy2.getSub().setInt(oldInt);
        InterfaceMapperTest.assertEquals(proxy2.getSub().getInt(), oldInt);
        InterfaceMapperTest.assertTrue(proxy.equals(proxy));
        InterfaceMapperTest.assertFalse(proxy.equals(proxy2));
        InterfaceMapperTest.assertTrue(proxy2.equals(proxy3));
        proxy2.setSub(null);
        InterfaceMapperTest.assertTrue(proxy.equals(proxy2));
        InterfaceMapperTest.assertTrue(proxy.equals(InterfaceStorage.shrink(proxy2)));
        InterfaceMapperTest.assertFalse(proxy.equals(null));
        InterfaceMapperTest.assertFalse(proxy.equals(obj));
        InterfaceMapperTest.assertEquals(obj.getInt(), proxy.getInt());
        TestInterface old = proxy.getSub();
        proxy.setSub(obj);
        TestInterface newObj = proxy.getSub();
        InterfaceMapperTest.assertTrue(newObj == obj);
        InterfaceMapperTest.assertEquals(proxy.getIntWithDef(), 9);
        TestInterface defaultsProxy = (TestInterface)mapper.jsonToObject(new FlexiJSONParser("{}").parse(), new SimpleTypeRef((Type)((Object)TestInterface.class)));
        InterfaceMapperTest.assertEquals(defaultsProxy.getIntWithDef(), 3);
        InterfaceMapperTest.assertEquals(defaultsProxy.getSubWithDefault().getBool(), true);
    }

    public static class TestObj
    implements TestInterface {
        private int i;
        private TestInterface sub;

        public TestObj() {
        }

        public TestObj(int i) {
            this.i = i;
        }

        @Override
        public TestInterface getSub() {
            return this.sub;
        }

        @Override
        public void setSub(TestInterface sub) {
            this.sub = sub;
        }

        @Override
        public int getInt() {
            return this.i;
        }

        @Override
        public int getIntWithDef() {
            return 9;
        }

        @Override
        public void setInt(int i) {
            this.i = i;
        }

        @Override
        public TestInterface2[] getSubList() {
            return null;
        }

        @Override
        public TestInterface2 getSubWithDefault() {
            return null;
        }
    }

    public static interface TestInterface {
        public int getInt();

        public void setInt(int var1);

        @FlexiInterfaceDefault(value="3")
        public int getIntWithDef();

        @FlexiInterfaceDefault(value="[{}]")
        public TestInterface2[] getSubList();

        public TestInterface getSub();

        @FlexiInterfaceDefault(value="{bool:true}")
        public TestInterface2 getSubWithDefault();

        public void setSub(TestInterface var1);
    }

    public static interface TestInterface2 {
        public boolean getBool();
    }
}

