/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.stringify;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.net.CountingOutputStream;

public class FlexiJSonStringBuilder {
    protected final Charset charset = Charset.forName("UTF-8");
    protected byte[] ifNotEOL;
    private final CharsetEncoder charEncoder = this.charset.newEncoder();
    private ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.charEncoder.averageBytesPerChar() * 16);
    private CharBuffer charBuffer = CharBuffer.allocate(16);
    protected byte[] lineCommentStart;
    protected byte[] lineCommentEnd;
    protected byte[] inlineCommentStart;
    protected byte[] inlineCommendEnd;
    protected byte[] spaceString;
    protected byte[] commaString;
    protected byte[] nullString;
    protected byte[] undefinedString;
    protected byte[] collonString;
    protected byte[] zeroString;
    protected byte[] escapedEscaped;
    protected byte[] escapedEscapedUString;
    protected byte[] escapedEscapedNString;
    protected byte[] escapedEscapedRString;
    protected byte[] escapedEscapedTString;
    protected byte[] escapedEscapedFString;
    protected byte[] escapedEscapedBString;
    protected byte[] escapedQuotationMarks;
    protected byte[] escapedEscapedQuotationMarks;
    protected byte[] arrayOpenTag;
    protected byte[] arrayCloseTag;
    protected byte[] objectOpenTag;
    protected byte[] objectCloseTag;
    protected byte[] trueString;
    protected byte[] falseString;
    protected byte[] newLineRN;

    public FlexiJSonStringBuilder() {
        this.initTags(this.charset);
    }

    protected void initTags(Charset charset) {
        this.lineCommentStart = "//".getBytes(charset);
        this.lineCommentEnd = "\r\n".getBytes(charset);
        this.inlineCommentStart = "/*".getBytes(charset);
        this.inlineCommendEnd = "*/".getBytes(charset);
        this.spaceString = " ".getBytes(charset);
        this.commaString = ",".getBytes(charset);
        this.nullString = "null".getBytes(charset);
        this.undefinedString = "undefined".getBytes(charset);
        this.collonString = ":".getBytes(charset);
        this.zeroString = "0".getBytes(charset);
        this.escapedEscaped = "\\\\".getBytes(charset);
        this.escapedEscapedUString = "\\u".getBytes(charset);
        this.escapedEscapedNString = "\\n".getBytes(charset);
        this.escapedEscapedRString = "\\r".getBytes(charset);
        this.escapedEscapedTString = "\\t".getBytes(charset);
        this.escapedEscapedBString = "\\b".getBytes(charset);
        this.escapedEscapedFString = "\\f".getBytes(charset);
        this.escapedQuotationMarks = "\"".getBytes(charset);
        this.escapedEscapedQuotationMarks = "\\\"".getBytes(charset);
        this.arrayOpenTag = "[".getBytes(charset);
        this.arrayCloseTag = "]".getBytes(charset);
        this.objectOpenTag = "{".getBytes(charset);
        this.objectCloseTag = "}".getBytes(charset);
        this.trueString = "true".getBytes(charset);
        this.falseString = "false".getBytes(charset);
        this.newLineRN = "\r\n".getBytes(charset);
    }

    public String toJSONString(FlexiJSonNode node, LinkedList<String> path) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(){

            @Override
            public synchronized String toString() {
                return new String(this.buf, 0, this.count, FlexiJSonStringBuilder.this.charset);
            }
        };
        this.toJSONString(node, os, path);
        return os.toString();
    }

    public void toJSONString(FlexiJSonNode node, OutputStream out, LinkedList<String> path) {
        try {
            if (path == null) {
                path = new LinkedList();
            }
            this.ifNotEOL = null;
            node.writeToStream(this, new JSONBuilderOutputStream(out, this.charset), 0, path);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    public void appendPrimitiveValue(FlexiJSonValue value, JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        FlexiJSonComments b = value.getCommentsBefore();
        FlexiJSonComments a = value.getCommentsAfter();
        if (b != null && b.size() > 0) {
            b.writeToStream(this, out, layer, path);
        }
        this.appendPrimitiveValueWithoutComments(value, out, path, layer);
        if (a != null && a.size() > 0) {
            a.writeToStream(this, out, layer, path);
        }
    }

    protected void appendPrimitiveValueWithoutComments(FlexiJSonValue value, JSONBuilderOutputStream out, LinkedList<String> path, int layer) throws IOException {
        this.writeIfNotEOL(out);
        switch (value.getType()) {
            case BOOLEAN: {
                this.appendBoolean(value, out);
                break;
            }
            case DOUBLE: {
                this.appendDouble(value, out);
                break;
            }
            case LONG: {
                this.appendLong(value, out);
                break;
            }
            case STRING: {
                this.appendString(value, out);
                break;
            }
            case NULL: {
                this.appendNull(value, out);
                break;
            }
            case UNDEFINED: {
                this.appendUndefined(value, out);
                break;
            }
            default: {
                new WTFException("Not supported:" + (Object)((Object)value.getType()));
            }
        }
    }

    protected void appendUndefined(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        this.bytesToStream(out, this.undefinedString);
    }

    protected void stringToStream(JSONBuilderOutputStream out, String string) throws IOException {
        out.write(string.getBytes(this.charset));
    }

    protected void appendNull(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        this.bytesToStream(out, this.nullString);
    }

    protected void bytesToStream(JSONBuilderOutputStream out, byte[] bytes) throws IOException {
        out.write(bytes);
    }

    protected void appendLong(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        this.stringToStream(out, value.getValue().toString());
    }

    protected void appendString(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        String s = (String)value.getValue();
        this.appendString(out, s);
    }

    protected void finalizeAppendString(JSONBuilderOutputStream out) throws IOException {
        if (this.charBuffer.hasRemaining()) {
            JDK8BufferHelper.clear(this.byteBuffer);
            JDK8BufferHelper.flip(this.charBuffer);
            this.charEncoder.encode(this.charBuffer, this.byteBuffer, true);
            JDK8BufferHelper.flip(this.byteBuffer);
            out.write(this.byteBuffer.array(), this.byteBuffer.position(), this.byteBuffer.remaining());
            JDK8BufferHelper.clear(this.charBuffer);
        }
    }

    protected void appendString(JSONBuilderOutputStream out, String s) throws IOException, CharacterCodingException {
        this.bytesToStream(out, this.escapedQuotationMarks);
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedQuotationMarks);
                    continue block9;
                }
                case '\\': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscaped);
                    continue block9;
                }
                case '\b': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedBString);
                    continue block9;
                }
                case '\f': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedFString);
                    continue block9;
                }
                case '\n': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedNString);
                    continue block9;
                }
                case '\r': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedRString);
                    continue block9;
                }
                case '\t': {
                    this.finalizeAppendString(out);
                    this.bytesToStream(out, this.escapedEscapedTString);
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        this.finalizeAppendString(out);
                        String ss = Integer.toHexString(ch);
                        this.bytesToStream(out, this.escapedEscapedUString);
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            this.bytesToStream(out, this.zeroString);
                        }
                        this.stringToStream(out, ss.toUpperCase(Locale.ENGLISH));
                        continue block9;
                    }
                    this.charBuffer.append(ch);
                    if (Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) continue block9;
                    this.finalizeAppendString(out);
                }
            }
        }
        this.finalizeAppendString(out);
        this.bytesToStream(out, this.escapedQuotationMarks);
    }

    protected void appendDouble(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        this.stringToStream(out, value.getValue().toString());
    }

    protected void appendBoolean(FlexiJSonValue value, JSONBuilderOutputStream out) throws IOException {
        if (Boolean.TRUE.equals(value.getValue())) {
            this.bytesToStream(out, this.trueString);
        } else {
            this.bytesToStream(out, this.falseString);
        }
    }

    public void appendComment(FlexiComment comment, JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        if (comment.getType() == FlexiComment.Type.LINE) {
            this.bytesToStream(out, this.lineCommentStart);
            this.stringToStream(out, comment.getText());
            this.ifNotEOL = this.lineCommentEnd;
        } else {
            this.bytesToStream(out, this.inlineCommentStart);
            this.stringToStream(out, comment.getText());
            this.bytesToStream(out, this.inlineCommendEnd);
        }
    }

    protected boolean writeIfNotEOL(JSONBuilderOutputStream out) throws IOException {
        if (this.ifNotEOL != null) {
            this.bytesToStream(out, this.ifNotEOL);
            this.ifNotEOL = null;
            return true;
        }
        return false;
    }

    public void appendArray(FlexiJSonArray array, JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        FlexiJSonComments b = array.getCommentsBefore();
        FlexiJSonComments a = array.getCommentsAfter();
        if (b != null) {
            b.writeToStream(this, out, 0, path);
        }
        this.bytesToStream(out, this.arrayOpenTag);
        boolean first = true;
        for (int i = 0; i < array.size(); ++i) {
            FlexiJSonNode n = (FlexiJSonNode)array.get(i);
            if (first) {
                first = false;
            } else {
                this.bytesToStream(out, this.commaString);
            }
            n.writeToStream(this, out, 0, path);
        }
        if (array.getCommentsInside() != null && array.getCommentsInside().size() > 0) {
            if (!first) {
                this.bytesToStream(out, this.commaString);
            }
            array.getCommentsInside().writeToStream(this, out, 0, path);
        }
        this.bytesToStream(out, this.arrayCloseTag);
        if (a != null) {
            a.writeToStream(this, out, 0, path);
        }
    }

    public void appendObject(FlexiJSonObject object, JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        FlexiJSonComments b = object.getCommentsBefore();
        FlexiJSonComments a = object.getCommentsAfter();
        if (b != null) {
            b.writeToStream(this, out, 0, path);
        }
        this.writeIfNotEOL(out);
        this.bytesToStream(out, this.objectOpenTag);
        if (object.getCommentsInside() != null) {
            object.getCommentsInside().writeToStream(this, out, 0, path);
        }
        boolean first = true;
        for (KeyValueElement es : object.getElements()) {
            this.writeIfNotEOL(out);
            if (first) {
                first = false;
            } else {
                this.bytesToStream(out, this.commaString);
            }
            first = false;
            if (es.getCommentsBeforeKey() != null) {
                es.getCommentsBeforeKey().writeToStream(this, out, layer + 1, path);
            }
            if (es.getKey() == null) continue;
            this.writeIfNotEOL(out);
            this.appendString(out, es.getKey());
            if (es.getCommentsAfterKey() != null) {
                es.getCommentsAfterKey().writeToStream(this, out, layer + 1, path);
            }
            this.writeIfNotEOL(out);
            this.bytesToStream(out, this.collonString);
            es.getValue().writeToStream(this, out, layer, path);
        }
        this.bytesToStream(out, this.objectCloseTag);
        if (a != null) {
            a.writeToStream(this, out, 0, path);
        }
    }

    public void appendComments(FlexiJSonComments comments, JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        for (FlexiCommentJsonNode c : comments) {
            this.writeIfNotEOL(out);
            c.writeToStream(this, out, 0, path);
        }
    }

    public String toJSONString(FlexiJSonNode node) {
        return this.toJSONString(node, new LinkedList<String>());
    }

    public static class JSONBuilderOutputStream
    extends CountingOutputStream {
        private final ByteArrayOutputStream baos;
        private long lastNewLineIndex = -1L;
        private final byte space;
        private final byte[] newLineRN;
        private final byte[] lookBackBuffer;
        public boolean compactArrayMode = false;
        private final byte[] writeBuf = new byte[1];
        public final Charset charset;

        public JSONBuilderOutputStream(OutputStream out, Charset charset) {
            super(out);
            this.space = " ".getBytes(charset)[0];
            this.newLineRN = "\r\n".getBytes(charset);
            this.lookBackBuffer = new byte[this.newLineRN.length];
            this.baos = out instanceof ByteArrayOutputStream ? (ByteArrayOutputStream)out : null;
            this.charset = charset;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                super.write(b, off, len);
                if (len >= this.lookBackBuffer.length) {
                    System.arraycopy(b, off + len - this.lookBackBuffer.length, this.lookBackBuffer, 0, this.lookBackBuffer.length);
                } else {
                    int leftShift = this.lookBackBuffer.length - len;
                    System.arraycopy(this.lookBackBuffer, leftShift, this.lookBackBuffer, 0, len);
                    System.arraycopy(b, off, this.lookBackBuffer, leftShift, len);
                }
                if (this.lastNewLineIndex >= 0L) {
                    for (int i = off; i < off + len; ++i) {
                        if (b[i] == this.space) continue;
                        this.lastNewLineIndex = -1L;
                    }
                }
                if (Arrays.equals(this.lookBackBuffer, this.newLineRN)) {
                    this.lastNewLineIndex = this.transferedBytes();
                }
            }
        }

        public long getLastNewLineIndex() {
            return this.lastNewLineIndex;
        }

        public byte[] getLookBackBuffer() {
            return this.lookBackBuffer;
        }

        public byte getLastByteFromBackBuffer() {
            return this.lookBackBuffer[this.lookBackBuffer.length - 1];
        }

        @Override
        public void write(int b) throws IOException {
            this.writeBuf[0] = (byte)b;
            this.write(this.writeBuf, 0, 1);
        }

        public String toString() {
            if (this.baos == null) {
                return super.toString();
            }
            try {
                return this.baos.toString(this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                return super.toString();
            }
        }

        public boolean lastWasNewline() {
            return this.transferedBytes() == 0L || Arrays.equals(this.lookBackBuffer, this.newLineRN);
        }
    }
}

