/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.typemapper;

import java.lang.reflect.Type;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.duration.InvalidTimeSpanException;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.CompiledType;

public class TimeSpanMapper
implements FlexiTypeMapper {
    @Override
    public FlexiJSonNode obj2JSon(FlexiJSonMapper mapper, Object obj, Getter reference, List<CompiledType> typeHirarchy) {
        if (mapper != null) {
            if (obj == null) {
                return mapper.createFlexiJSonValue((String)null);
            }
            return mapper.createFlexiJSonValue(((TimeSpan)obj).format(true));
        }
        if (obj == null) {
            return new FlexiJSonValue((String)null);
        }
        return new FlexiJSonValue(((TimeSpan)obj).format(true));
    }

    @Override
    public Object json2Obj(FlexiJSonMapper mapper, FlexiJSonNode node, CompiledType type, Setter setter) throws FlexiMapperException {
        if (node instanceof FlexiJSonValue) {
            switch (((FlexiJSonValue)node).getType()) {
                case LONG: {
                    return TimeSpan.fromMillis(((Number)((FlexiJSonValue)node).getValue()).longValue());
                }
                case STRING: {
                    if (((FlexiJSonValue)node).getValue().equals("")) {
                        return null;
                    }
                    try {
                        return TimeSpan.parse((String)((FlexiJSonValue)node).getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new FlexiMapperException(node, type, e);
                    }
                    catch (InvalidTimeSpanException e) {
                        throw new FlexiMapperException(node, type, e);
                    }
                }
                case NULL: {
                    return null;
                }
            }
        }
        throw new WTFException("Cannot Map node to Date");
    }

    @Override
    public boolean canConvert2Json(Object obj, Getter getter) {
        return obj != null && obj instanceof TimeSpan;
    }

    @Override
    public boolean canConvert2Object(FlexiJSonNode node, CompiledType type, Setter setter) {
        return type.isInstanceOf(new Type[]{TimeSpan.class});
    }
}

