/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.typemapper;

import java.lang.reflect.Type;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.storage.StorableDateFormat;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.reflection.CompiledType;

public class DateMapper
implements FlexiTypeMapper {
    public static final String JSON_DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:sszzz";
    private List<LocalTimeFormat> formats = new CopyOnWriteArrayList<LocalTimeFormat>();

    public DateMapper() {
        this.addFormat("yyyy-MM-dd'T'HH:mm:ss zzz");
        this.addFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        this.addFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.addFormat("yyyy/MM/dd HH:mm:ssZ");
        this.addFormat("yyyy/MM/dd HH:mm:ss");
        this.addFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.addFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        this.addFormat("yyyy-MM-dd'T'HH:mmZ");
        this.addFormat("yyyy-MM-dd'T'HH:mm");
        this.addFormat("yyyy-MM-dd HH:mm:ssZ");
        this.addFormat("yyyy-MM-dd HH:mm:ss");
        this.addFormat("yyyy-MM-dd");
        this.addFormat("HH:mm:ss");
    }

    public void addFormat(String format) {
        this.formats.add(new LocalTimeFormat(format));
    }

    @Override
    public FlexiJSonNode obj2JSon(FlexiJSonMapper mapper, Object obj, Getter reference, List<CompiledType> typeHirarchy) {
        SimpleDateFormat formater = this.getSerializationFormater(reference);
        if (formater == null) {
            if (mapper != null) {
                return mapper.createFlexiJSonValue(((Date)obj).getTime());
            }
            return new FlexiJSonValue(((Date)obj).getTime());
        }
        if (mapper != null) {
            return mapper.createFlexiJSonValue(formater.format((Date)obj));
        }
        return new FlexiJSonValue(formater.format((Date)obj));
    }

    public SimpleDateFormat getSerializationFormater(Getter reference) {
        ClassCache cc;
        List<StorableDateFormat> dateformat;
        if (reference != null && (dateformat = (cc = reference.classCache).getAnnotations(reference.key, StorableDateFormat.class)) != null && dateformat.size() > 0) {
            return new SimpleDateFormat(dateformat.get(0).value());
        }
        return (SimpleDateFormat)this.formats.get(0).get();
    }

    @Override
    public Object json2Obj(FlexiJSonMapper mapper, FlexiJSonNode node, CompiledType type, Setter reference) throws FlexiMapperException {
        if (node instanceof FlexiJSonValue) {
            switch (((FlexiJSonValue)node).getType()) {
                case LONG: {
                    return new Date((Long)((FlexiJSonValue)node).getValue());
                }
                case STRING: {
                    if (((FlexiJSonValue)node).getValue().equals("")) {
                        return null;
                    }
                    String s = (String)((FlexiJSonValue)node).getValue();
                    Date ret = this.parseString(s);
                    if (ret != null) {
                        return ret;
                    }
                    throw new FlexiMapperException(node, type, "Cannot Map node to Date " + (String)((FlexiJSonValue)node).getValue());
                }
                case NULL: {
                    return null;
                }
            }
        }
        throw new FlexiMapperException(node, type, "Cannot Map node to Date");
    }

    public Date parseString(String s) {
        if ("$NOW".equalsIgnoreCase(s)) {
            return new Date();
        }
        s = s.replaceAll("Z$", "+0000");
        s = s.replaceAll("(\\+|\\-)\\s*(\\d{2}):(\\d{2})$", "$1$2$3");
        s = s.replaceAll("(\\+|\\-)\\s*(\\d{2})$", "$1$200");
        for (LocalTimeFormat f : this.formats) {
            ParsePosition pp = new ParsePosition(0);
            Date ret = ((SimpleDateFormat)f.get()).parse(s, pp);
            if (pp.getErrorIndex() >= 0 || pp.getIndex() != s.length()) continue;
            return ret;
        }
        return null;
    }

    @Override
    public boolean canConvert2Json(Object obj, Getter getter) {
        return obj != null && obj instanceof Date;
    }

    @Override
    public boolean canConvert2Object(FlexiJSonNode node, CompiledType type, Setter setter) {
        return type.isInstanceOf(new Type[]{Date.class});
    }

    public static Date parseJsonDefault(String dateString) throws FlexiMapperException {
        return (Date)new DateMapper().json2Obj(null, new FlexiJSonValue(String.valueOf(dateString)), CompiledType.create(Date.class), null);
    }

    public static String formatJsonDefault(long timestamp) {
        return new SimpleDateFormat(JSON_DEFAULT_FORMAT, Locale.US).format(timestamp);
    }

    public static String formatJsonDefault(Date date) {
        return DateMapper.formatJsonDefault(date.getTime());
    }

    public class LocalTimeFormat
    extends ThreadLocal<SimpleDateFormat> {
        private final String format;

        public LocalTimeFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat ret = new SimpleDateFormat(this.format, Locale.US);
            ret.setLenient(false);
            return ret;
        }
    }
}

