/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.tests;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.testframework.AWTest;

public class DateMapperTest
extends AWTest {
    public static void main(String[] args) {
        DateMapperTest.run();
    }

    @Override
    public void runTest() throws Exception {
        String source = "2022-01-01T00:00:00Z";
        Instant instant = Instant.parse(source);
        Date fromInstant = Date.from(instant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        Date fsdfds = format.parse("2022-01-01T00:00:00CET");
        String formated = format.format(fsdfds);
        Date date = new DateMapper().parseString("2022-01-01T00:00:00+0100");
        DateMapperTest.assertNotNull(date);
        date = (Date)FlexiUtils.jsonToObject("\"2022-01-01T00:00:00 -08:00\"", new SimpleTypeRef((Type)((Object)Date.class)));
        DateMapperTest.assertEquals(date.toInstant().toString(), "2022-01-01T08:00:00Z");
        String json = FlexiUtils.serializeMinimized(date);
        DateMapperTest.assertEquals(json, "\"2022-01-01T09:00:00 CET\"");
        date = (Date)FlexiUtils.jsonToObject("\"2022-01-01 00:00:00 -08:00\"", new SimpleTypeRef((Type)((Object)Date.class)));
        DateMapperTest.assertEquals(date.toInstant().toString(), "2022-01-01T08:00:00Z");
        json = FlexiUtils.serializeMinimized(date);
        DateMapperTest.assertEquals(json, "\"2022-01-01T09:00:00 CET\"");
        date = (Date)FlexiUtils.jsonToObject("\"2022-01-01T00:00:00Z\"", new SimpleTypeRef((Type)((Object)Date.class)));
        DateMapperTest.assertEquals(date.toInstant().toString(), "2022-01-01T00:00:00Z");
        json = FlexiUtils.serializeMinimized(date);
        DateMapperTest.assertEquals(json, "\"2022-01-01T01:00:00 CET\"");
        date = (Date)FlexiUtils.jsonToObject("\"2022-01-01T00:00:00 CET\"", new SimpleTypeRef((Type)((Object)Date.class)));
        DateMapperTest.assertEquals(date.toInstant().toString(), "2021-12-31T23:00:00Z");
        json = FlexiUtils.serializeMinimized(date);
        DateMapperTest.assertEquals(json, "\"2022-01-01T00:00:00 CET\"");
        date = (Date)FlexiUtils.jsonToObject("\"2022-01-01T00:00:00+0100\"", new SimpleTypeRef((Type)((Object)Date.class)));
        DateMapperTest.assertEquals(date.toInstant().toString(), "2021-12-31T23:00:00Z");
        json = FlexiUtils.serializeMinimized(date);
        DateMapperTest.assertEquals(json, "\"2022-01-01T00:00:00 CET\"");
    }
}

