/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.interfacestorage;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiDefaultFactory;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefault;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefaultFactory;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorageListener;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandler;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandlerImpl;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.utils.FlexiWalker;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.event.basic.CoreDelegate;
import org.appwork.utils.event.basic.CoreEventSender;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class InterfaceStorage<InterfaceType>
implements InvocationHandler {
    public FlexiJSonObject backendNode;
    public final CompiledType cType;
    public final FlexiJSonMapper mapper;
    private Map<String, Object> cache;
    private CoreEventSender<InterfaceStorageListener<InterfaceType>> eventSender;
    private static final Object NULL = new Object();
    private volatile HashMap<String, PropertyHandler<InterfaceType, Object>> propertyHandlers = new HashMap();
    private InterfaceType storage;

    public FlexiJSonObject getBackendNode() {
        return this.backendNode;
    }

    public void setBackendNode(FlexiJSonObject target) {
        FlexiJSonObject old = this.backendNode;
        this.backendNode = target;
        if (old != null && old.getParent() != null) {
            DebugMode.debugger("Check Me");
        }
    }

    public InterfaceStorage(FlexiJSonMapper mapper, CompiledType cType, FlexiJSonObject obj) {
        this.backendNode = obj;
        this.cType = cType;
        this.mapper = mapper;
        this.cache = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreEventSender<InterfaceStorageListener<InterfaceType>> getEventSender() {
        InterfaceStorage interfaceStorage = this;
        synchronized (interfaceStorage) {
            if (this.eventSender == null) {
                this.eventSender = new CoreEventSender();
            }
            return this.eventSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (proxy == null) {
            proxy = this.storage;
        }
        if (this.storage != proxy && this.storage != null) {
            throw new WTFException();
        }
        Class<?> returnType = method.getReturnType();
        int parameterCount = ClassCache.getParameterCount(method);
        if ("toString".equals(method.getName()) && Clazz.isString(returnType) && parameterCount == 0) {
            return this.cType + "-proxy:\r\n" + new FlexiJSonPrettyStringify().toJSONString(new FlexiJSonMapper(){

                @Override
                protected boolean isIncludeInterfaceStorageBackendNode() {
                    return false;
                }
            }.objectToJsonNode(proxy)) + "\r\n\r\nBackend Node:\r\n" + FlexiUtils.serializeToPrettyJson(this.backendNode);
        }
        if ("hashCode".equals(method.getName()) && Clazz.isInteger(returnType) && parameterCount == 0) {
            return this.cType.hashCode();
        }
        if ("equals".equals(method.getName()) && Clazz.isBoolean(returnType) && parameterCount == 1 && method.getParameterTypes()[0] == Object.class) {
            return this.equals(proxy, args);
        }
        final String key = ClassCache.createKey(method);
        if (parameterCount == 1 && returnType == Void.TYPE) {
            Object oldValue;
            final Object newValue = args[0];
            Property property = this.cType.getClassCache().getProperty(key);
            boolean requiresWrite = true;
            InterfaceStorage interfaceStorage = this;
            synchronized (interfaceStorage) {
                Object object = oldValue = property.getter == null ? null : this.getWithUsingTheCache(property.getter, key);
                if (oldValue == null && newValue == null) {
                    requiresWrite = false;
                } else if (oldValue == null && newValue != null || oldValue != null || newValue == null) {
                    requiresWrite = true;
                } else if (property.type.isPrimitive() || property.type.isEnum(true) || property.type.isString()) {
                    if (CompareUtils.equals(oldValue, newValue)) {
                        requiresWrite = false;
                    }
                } else if (oldValue != newValue) {
                    if (property.type.isListContainer() || property.type.isMap()) {
                        if ((property.type.getComponentType().isPrimitive() || property.type.getComponentType().isEnum(true) || property.type.getComponentType().isString()) && CompareUtils.equalsDeep(oldValue, newValue)) {
                            requiresWrite = false;
                        }
                    } else if (property.type.isInstanceOf(new Type[]{FlexiStorableInterface.class, Storable.class})) {
                        ClassCache cc = property.type.getClassCache();
                        boolean onlyPrimitiveLikeTypes = true;
                        for (String propKey : cc.getKeys()) {
                            CompiledType propType = CompiledType.create(cc.getType(propKey), property.type);
                            if (propType.isPrimitive() || propType.isEnum(true) || propType.isString()) continue;
                            onlyPrimitiveLikeTypes = false;
                            break;
                        }
                        if (onlyPrimitiveLikeTypes && CompareUtils.equalsDeep(oldValue, newValue)) {
                            requiresWrite = false;
                        }
                    }
                }
                this.writeToCache(key, newValue);
            }
            if (requiresWrite) {
                PropertyHandler<InterfaceType, Object> propertyHandler;
                CoreEventSender<InterfaceStorageListener<InterfaceType>> eventSender = this.eventSender;
                if (eventSender != null) {
                    final Object fProxy = proxy;
                    eventSender.fireEvent(new CoreDelegate<InterfaceStorageListener<InterfaceType>>(){

                        @Override
                        protected void fireTo(InterfaceStorageListener<InterfaceType> listener) {
                            listener.onInterfaceValueSet(fProxy, key, oldValue, newValue);
                        }
                    });
                }
                if ((propertyHandler = this.propertyHandlers.get(key)) != null) {
                    propertyHandler.fireEventSet(oldValue, newValue);
                }
                this.onSet(key, oldValue, newValue);
            }
            return null;
        }
        if (parameterCount == 0 && returnType != Void.TYPE) {
            InterfaceStorage interfaceStorage = this;
            synchronized (interfaceStorage) {
                Getter getter = this.cType.getClassCache().getGetter(key);
                return getter == null ? null : this.getWithUsingTheCache(getter, key);
            }
        }
        throw new WTFException("Invalid method call:" + method);
    }

    protected void onSet(String key, Object old, Object object) {
    }

    private Object getWithUsingTheCache(Getter getter, String key) throws FlexiParserException, FlexiMapperException {
        Object value;
        List<String> alts;
        Object cachedValue = this.readCache(key);
        if (cachedValue != null) {
            if (cachedValue == NULL) {
                return null;
            }
            return cachedValue;
        }
        KeyValueElement element = this.getElementByKey(key);
        if (element == null && getter != null && (alts = getter.getAlternativeKeys()) != null) {
            String altkey;
            Iterator<String> iterator = alts.iterator();
            while (iterator.hasNext() && (element = this.getElementByKey(altkey = iterator.next())) == null) {
            }
        }
        if (this.isReturnDefaultValue(element, getter.getMethod(), key)) {
            value = this.getDefaultValue(getter.getMethod(), key);
            this.writeToCache(key, value);
            return value;
        }
        value = this.mapper.jsonToObject(element.getValue(), new SimpleTypeRef(getter.getMethod().getGenericReturnType()));
        this.writeToCache(key, value);
        return value;
    }

    protected boolean isReturnDefaultValue(KeyValueElement element, Method method, String key) {
        return element == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyValueElement getElementByKey(String key) {
        InterfaceStorage interfaceStorage = this;
        synchronized (interfaceStorage) {
            return this.getBackendNode().getElement(key);
        }
    }

    protected boolean equals(Object proxy, Object[] args) {
        Object compareTo = args[0];
        if (compareTo == null) {
            return false;
        }
        if (!Proxy.isProxyClass(compareTo.getClass())) {
            return false;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(compareTo);
        if (handler == null) {
            return false;
        }
        if (handler == this) {
            return true;
        }
        if (handler instanceof InterfaceStorage) {
            boolean ret;
            InterfaceStorage other = (InterfaceStorage)handler;
            if (other.cType != this.cType) {
                return false;
            }
            try {
                FlexiJSonNode a = this.mapper.objectToJsonNode(proxy);
                FlexiJSonNode b = this.mapper.objectToJsonNode(compareTo);
                ret = a.equals(b);
            }
            catch (FlexiMapperException e) {
                return false;
            }
            return ret;
        }
        return false;
    }

    public synchronized void clearCache() {
        this.cache.clear();
    }

    protected synchronized Object readCache(String key) {
        return this.cache.get(key);
    }

    protected synchronized void writeToCache(String key, Object ret) {
        if (ret == null) {
            this.cache.put(key, NULL);
        } else {
            this.cache.put(key, ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultValue(Method method, String key) throws FlexiParserException, FlexiMapperException {
        List<FlexiInterfaceDefault> defaultAnnotations;
        List<FlexiInterfaceDefaultFactory> defaultFactoryAnnotations = this.cType.getClassCache().getAnnotations(key, FlexiInterfaceDefaultFactory.class);
        if (defaultFactoryAnnotations != null && defaultFactoryAnnotations.size() > 0) {
            try {
                Class<? extends FlexiDefaultFactory> cls = defaultFactoryAnnotations.get(0).value();
                if (cls != null) {
                    return cls.newInstance().createDefault();
                }
            }
            catch (InstantiationException e) {
                throw new WTFException(e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException(e);
            }
        }
        if ((defaultAnnotations = this.cType.getClassCache().getAnnotations(key, FlexiInterfaceDefault.class)) != null && defaultAnnotations.size() > 0) {
            FlexiJSonNode defaultNode = new FlexiJSONParser(defaultAnnotations.get(0).value()){

                @Override
                protected FlexiJSonComments createCommentsContainer() {
                    return InterfaceStorage.this.mapper.createFlexiJsonCommentsContainer();
                }

                @Override
                protected FlexiCommentJsonNode createComment(String comment, FlexiComment.Type type, FlexiMapperTags tag, int startindex, int endIndex, Object path) {
                    return InterfaceStorage.this.mapper.createFlexiJsonComment(comment, tag, type);
                }

                @Override
                public FlexiJSonArray createJSonArray() {
                    return InterfaceStorage.this.mapper.createFlexiJSonArray(0);
                }

                @Override
                public FlexiJSonObject createJSonObject() {
                    return InterfaceStorage.this.mapper.createFlexiJSonObject();
                }

                @Override
                public FlexiJSonValue createJSonValue() {
                    return InterfaceStorage.this.mapper.createFlexiJSonValue();
                }

                @Override
                public FlexiJSonValue createJSonValue(Boolean value) {
                    return InterfaceStorage.this.mapper.createFlexiJSonValue(value);
                }

                @Override
                public FlexiJSonValue createJSonValue(Number longValue) {
                    return InterfaceStorage.this.mapper.createFlexiJSonValue(longValue);
                }

                @Override
                public FlexiJSonValue createJSonValue(String value) {
                    return InterfaceStorage.this.mapper.createFlexiJSonValue(value);
                }
            }.setDebug(new StringBuilder()).setIgnoreIssues(FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES).parse();
            InterfaceStorage interfaceStorage = this;
            synchronized (interfaceStorage) {
                FlexiJSonObject backendNode = this.getBackendNode();
                backendNode.add(new KeyValueElement(backendNode, key, defaultNode));
            }
            return this.mapper.jsonToObject(defaultNode, new SimpleTypeRef(method.getGenericReturnType()));
        }
        Class<?> returnType = method.getReturnType();
        if (Clazz.isByte(returnType)) {
            return (byte)0;
        }
        if (Clazz.isCharacter(returnType)) {
            return Character.valueOf('\u0000');
        }
        if (Clazz.isShort(returnType)) {
            return (short)0;
        }
        if (Clazz.isInteger(returnType)) {
            return 0;
        }
        if (Clazz.isLong(returnType)) {
            return 0L;
        }
        if (Clazz.isDouble(returnType)) {
            return 0.0;
        }
        if (Clazz.isFloat(returnType)) {
            return Float.valueOf(0.0f);
        }
        if (method.getReturnType() == Boolean.class) {
            return Boolean.FALSE;
        }
        if (method.getReturnType() == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public <ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyAccessHandler(String key, Class<ReturnType> clazz) {
        return this.getPropertyAccessHandler(key, clazz, !DebugMode.TRUE_IN_IDE_ELSE_FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyAccessHandler(String key, Class<ReturnType> clazz, boolean swallowException) {
        IllegalArgumentException e;
        if (!this.cType.getClassCache().getKeys().contains(key)) {
            e = new IllegalArgumentException("No key " + key + " available in " + this.cType);
            if (swallowException) {
                LogV3.log(e);
            } else {
                throw e;
            }
        }
        if (!clazz.isAssignableFrom(ReflectionUtils.getRaw(this.cType.getClassCache().getType(key)))) {
            e = new IllegalArgumentException("Invalid type " + key + " has type " + ReflectionUtils.getRaw(this.cType.getClassCache().getType(key)) + " - not " + clazz);
            if (swallowException) {
                LogV3.log(e);
            } else {
                throw e;
            }
        }
        InterfaceStorage interfaceStorage = this;
        synchronized (interfaceStorage) {
            PropertyHandler<InterfaceType, Object> ret = this.propertyHandlers.get(key);
            if (ret == null) {
                HashMap<String, PropertyHandler<InterfaceType, Object>> newMap = new HashMap<String, PropertyHandler<InterfaceType, Object>>(this.propertyHandlers);
                ret = new PropertyHandlerImpl<InterfaceType, Object>(this, key, clazz);
                newMap.put(key, ret);
                this.propertyHandlers = newMap;
            }
            return ret;
        }
    }

    public <ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyAccessHandler(String key, TypeRef<ReturnType> type) {
        return this.getPropertyAccessHandler(key, type, !DebugMode.TRUE_IN_IDE_ELSE_FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyAccessHandler(String key, TypeRef<ReturnType> type, boolean swallowException) {
        Class<?> clazz;
        if (!this.cType.getClassCache().getKeys().contains(key)) {
            IllegalArgumentException e = new IllegalArgumentException("No key " + key + " available in " + this.cType);
            if (swallowException) {
                LogV3.log(e);
            } else {
                throw e;
            }
        }
        if (!(clazz = type.getRawClass()).isAssignableFrom(ReflectionUtils.getRaw(this.cType.getClassCache().getType(key)))) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid type " + key + " has type " + ReflectionUtils.getRaw(this.cType.getClassCache().getType(key)) + " - not " + clazz);
            if (swallowException) {
                LogV3.log(e);
            } else {
                throw e;
            }
        }
        InterfaceStorage interfaceStorage = this;
        synchronized (interfaceStorage) {
            PropertyHandler<InterfaceType, Object> ret = this.propertyHandlers.get(key);
            if (ret == null) {
                HashMap<String, PropertyHandler<InterfaceType, Object>> newMap = new HashMap<String, PropertyHandler<InterfaceType, Object>>(this.propertyHandlers);
                ret = new PropertyHandlerImpl(this, key, clazz);
                newMap.put(key, ret);
                this.propertyHandlers = newMap;
            }
            return ret;
        }
    }

    public static <InterfaceType, ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyHandler(InterfaceType proxy, String key, Class<ReturnType> clazz) {
        if (proxy == null) {
            return null;
        }
        return InterfaceStorage.get(proxy).getPropertyAccessHandler(key, clazz);
    }

    public static <InterfaceType, ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyHandler(InterfaceType proxy, String key, Class<ReturnType> clazz, boolean swallowExceptions) {
        if (proxy == null) {
            return null;
        }
        return InterfaceStorage.get(proxy).getPropertyAccessHandler(key, clazz, swallowExceptions);
    }

    public static <InterfaceType, ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyHandler(InterfaceType proxy, String key, TypeRef<ReturnType> typeRef) {
        if (proxy == null) {
            return null;
        }
        return InterfaceStorage.get(proxy).getPropertyAccessHandler(key, typeRef);
    }

    public static <InterfaceType, ReturnType> PropertyHandler<InterfaceType, ReturnType> getPropertyHandler(InterfaceType proxy, String key, TypeRef<ReturnType> typeRef, boolean swallowExceptions) {
        if (proxy == null) {
            return null;
        }
        return InterfaceStorage.get(proxy).getPropertyAccessHandler(key, typeRef, swallowExceptions);
    }

    public void setStorage(InterfaceType proxy) {
        this.storage = proxy;
    }

    public static <InterfaceType> InterfaceStorage<InterfaceType> get(InterfaceType storage) {
        InvocationHandler ret = Proxy.getInvocationHandler(storage);
        if (ret instanceof InterfaceStorage) {
            return (InterfaceStorage)ret;
        }
        return null;
    }

    public InterfaceType getStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <InterfaceType> InterfaceType shrink(InterfaceType storage, CompiledType type) {
        InterfaceStorage<InterfaceType> stori = InterfaceStorage.get(storage);
        if (type == null) {
            type = stori.cType;
        }
        InterfaceStorage<InterfaceType> interfaceStorage = stori;
        synchronized (interfaceStorage) {
            FlexiJSonObject node = stori.backendNode;
            new FlexiWalker(node, type){

                @Override
                public boolean onNode(FlexiJSonNode node, CompiledType type, JSPath path) {
                    return type != null;
                }
            }.run();
        }
        return storage;
    }

    public static <InterfaceType> InterfaceType shrink(InterfaceType storage) {
        return InterfaceStorage.shrink(storage, null);
    }
}

