/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.config.ide;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.HashSet;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.config.FlexiConfigBuilder;
import org.appwork.storage.flexijson.config.FlexiConfigFromJsonConfigBuilder;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandler;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class STATIC_CFG_CLASS_GENERATOR {
    private static StringBuilder imports;
    private static HashSet<Class<?>> importedClasses;

    public static File overwrite(String container, Class<?> inter, boolean createIfNotExists, boolean swallowCFGInitException, boolean swallowPropertyInitExceptions) throws ClassNotFoundException, URISyntaxException, SecurityException, NoSuchMethodException, IOException {
        String sourcE = STATIC_CFG_CLASS_GENERATOR.createSource(container, inter, swallowCFGInitException, swallowPropertyInitExceptions);
        String bin = new File(inter.getClassLoader().getResource("").toURI()).getAbsolutePath();
        File root = new File(bin.replace("/bin", "/src").replace("\\bin", "\\src"));
        File target = new File(root, container.replace(".", "/") + ".java");
        if (!createIfNotExists && !target.isFile()) {
            return target;
        }
        System.out.println("Updated file at " + target);
        System.out.println(sourcE);
        IO.secureWrite(target, sourcE, IO.SYNC.META_AND_DATA);
        return target;
    }

    /*
     * WARNING - void declaration
     */
    public static String createSource(String container, Class<?> inter, boolean swallowCFGInitException, boolean swallowPropertyInitExceptions) throws ClassNotFoundException, URISyntaxException, SecurityException, NoSuchMethodException, IOException {
        String bin = new File(inter.getClassLoader().getResource("").toURI()).getAbsolutePath();
        File root = new File(bin.replace("/bin", "/src").replace("\\bin", "\\src"));
        File target = new File(root, container.replace(".", "/") + ".java");
        StringBuilder sb = new StringBuilder();
        imports = new StringBuilder();
        importedClasses = new HashSet();
        if (!StringUtils.equals(inter.getName().replaceAll("\\.[^\\.]+$", ""), container.replaceAll("\\.[^\\.]+$", ""))) {
            STATIC_CFG_CLASS_GENERATOR.addImport(inter);
        }
        STATIC_CFG_CLASS_GENERATOR.addImport(InterfaceStorage.class);
        STATIC_CFG_CLASS_GENERATOR.addImport(PropertyHandler.class);
        STATIC_CFG_CLASS_GENERATOR.addImport(Application.class);
        StringBuilder props = new StringBuilder();
        boolean builderAdded = false;
        if (target.isFile()) {
            String exists = IO.readFileToString(target);
            String builder = new Regex(exists, "(public\\s+static\\s+[^;]*\\s+CFG\\s+[^;]*=[^;]+;)").getMatch(0);
            String buildConfig = new Regex(exists, "(private\\s+static\\s+[^;]*buildConfig.*\\}//\\s*buildConfig)").getMatch(0);
            if (StringUtils.isNotEmpty(buildConfig)) {
                for (String string : new Regex(exists, "import ([^\\;]+);").getColumn(0)) {
                    try {
                        Class<?> cls = Class.forName(string);
                        if (!buildConfig.contains(cls.getSimpleName())) continue;
                        STATIC_CFG_CLASS_GENERATOR.addImport(cls);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (builder != null) {
                builderAdded = true;
                props.append("     " + (String)builder).append("\r\n\r\n");
                if (buildConfig != null) {
                    props.append("     " + buildConfig).append("\r\n\r\n");
                    if (buildConfig.contains(FlexiConfigBuilder.class.getSimpleName() + "<")) {
                        STATIC_CFG_CLASS_GENERATOR.addImport(FlexiConfigBuilder.class);
                    }
                    if (buildConfig.contains(FlexiConfigFromJsonConfigBuilder.class.getSimpleName() + "<")) {
                        STATIC_CFG_CLASS_GENERATOR.addImport(FlexiConfigFromJsonConfigBuilder.class);
                    }
                    STATIC_CFG_CLASS_GENERATOR.addImport(LogV3.class);
                    STATIC_CFG_CLASS_GENERATOR.addImport(InterruptedException.class);
                    STATIC_CFG_CLASS_GENERATOR.addImport(Exception.class);
                }
                if (builder.contains(FlexiConfigBuilder.class.getSimpleName() + "<")) {
                    STATIC_CFG_CLASS_GENERATOR.addImport(FlexiConfigBuilder.class);
                }
                if (builder.contains(FlexiConfigFromJsonConfigBuilder.class.getSimpleName() + "<")) {
                    STATIC_CFG_CLASS_GENERATOR.addImport(FlexiConfigFromJsonConfigBuilder.class);
                }
            }
        }
        STATIC_CFG_CLASS_GENERATOR.addImport(LogV3.class);
        STATIC_CFG_CLASS_GENERATOR.addImport(InterruptedException.class);
        STATIC_CFG_CLASS_GENERATOR.addImport(Exception.class);
        STATIC_CFG_CLASS_GENERATOR.addImport(WTFException.class);
        if (!builderAdded) {
            props.append("    private static " + inter.getSimpleName() + " buildConfig() {\r\n");
            props.append("        try {\r\n");
            props.append("            final " + inter.getSimpleName() + " ret = new " + FlexiConfigBuilder.class.getSimpleName() + "<" + inter.getSimpleName() + ">(" + inter.getSimpleName() + ".class, Application.getResource(\"cfg/" + inter.getSimpleName() + ".json\")).getStorageOrDefault(null);\r\n");
            props.append("            if (ret == null) {\r\n");
            props.append("                throw new WTFException();\r\n");
            props.append("            }\r\n");
            props.append("            return ret;\r\n");
            props.append("        } catch (final Exception e) {\r\n");
            props.append("            LogV3.log(e);\r\n");
            props.append("            if (e instanceof InterruptedException) {\r\n");
            props.append("                // restore interrupt flag\r\n");
            props.append("                Thread.currentThread().interrupt();\r\n");
            props.append("            }\r\n");
            if (!swallowCFGInitException) {
                props.append("            throw e instanceof RuntimeException ? (RuntimeException) e : new WTFException(e);\r\n");
            }
            props.append("        }\r\n");
            if (swallowCFGInitException) {
                props.append("        return null;\r\n");
            }
            props.append("    }// buildConfig\r\n");
            props.append("     " + StringUtils.fillPost("public static final " + inter.getSimpleName(), " ", 100) + " " + StringUtils.fillPost("CFG", " ", 50) + " = buildConfig();").append("\r\n\r\n");
            STATIC_CFG_CLASS_GENERATOR.addImport(FlexiConfigBuilder.class);
        }
        ClassCache cc = ClassCache.getClassCache(inter);
        for (String key : cc.getKeys()) {
            void var16_25;
            String staticKey = StringUtils.camelCaseToUnderscore(key, true);
            STATIC_CFG_CLASS_GENERATOR.addImport(cc.getType(key));
            CompiledType.ToStringRule rules = new CompiledType.ToStringRule();
            rules.setSyntax(CompiledType.ToStringSyntax.JAVA);
            CompiledType ct = CompiledType.create(cc.getType(key));
            STATIC_CFG_CLASS_GENERATOR.addImport(ct.raw);
            for (CompiledType c : ct.componentTypes) {
                STATIC_CFG_CLASS_GENERATOR.addImport(c.raw);
            }
            String string = "new TypeRef<" + ct.toString(rules) + ">(){}";
            if (cc.getType(key) instanceof Class) {
                String string2 = ((Class)cc.getType(key)).getSimpleName() + ".class";
            }
            if (ct.type.equals(TypeRef.HASHMAP_STRING.getType())) {
                String string3 = "TypeRef.HASHMAP_STRING";
            }
            if (var16_25.contains("TypeRef")) {
                STATIC_CFG_CLASS_GENERATOR.addImport(TypeRef.class);
            }
            rules.setPrimitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.WRAPPER_NAMES_FOR_BOTH);
            props.append("     " + StringUtils.fillPost("public static final PropertyHandler<" + inter.getSimpleName() + "," + ct.toString(rules) + "> ", " ", 100) + " " + StringUtils.fillPost(staticKey, " ", 50) + " = InterfaceStorage.getPropertyHandler(CFG, \"" + key + "\", " + (String)var16_25 + ", " + swallowPropertyInitExceptions + ");").append("\r\n");
        }
        String simple = new Regex(container, "([^\\.]+$)").getMatch(0);
        String packageName = new Regex(container, "(.*)(\\.[^\\.]+$)").getMatch(0);
        String ret = "package " + packageName + ";\r\n\r\n";
        ret = ret + imports.toString() + "\r\n";
        ret = ret + "public class " + simple + " {\r\n";
        ret = ret + props.toString();
        ret = ret + "\r\n";
        ret = ret + "}";
        return ret;
    }

    private static void addImport(Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof Class) {
            if (Clazz.isPrimitive(type)) {
                return;
            }
            if (((Class)type).getName().startsWith("java.lang.")) {
                return;
            }
            if (!importedClasses.add((Class)type)) {
                return;
            }
            imports.append("import " + ((Class)type).getName().replace("$", ".") + ";").append("\r\n");
            return;
        }
        if (type instanceof ParameterizedType) {
            STATIC_CFG_CLASS_GENERATOR.addImport(ReflectionUtils.getRaw(type));
            Type[] actual = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < actual.length; ++i) {
                STATIC_CFG_CLASS_GENERATOR.addImport(actual[i]);
            }
            return;
        }
        throw new InvalidParameterException("type not supported: " + type);
    }
}

