/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.config.ide;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.flexijson.config.FlexiConfigBuilder;
import org.appwork.storage.flexijson.config.FlexiConfigFromJsonConfigBuilder;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefault;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Application;
import org.appwork.utils.IO;

public class FlexiConfigFromJsonConfigBuilderTest
extends AWTest {
    private ArrayList<File> deleteme = new ArrayList();

    @Override
    public void runTest() throws Exception {
        try {
            try {
                new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, new File("test")).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.DISK});
                throw new Exception("Expected an IllegalArgumentException because test does not end with .json");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.testMigrationFromDisk();
                this.testMigrationFromClassPathRoot();
                this.testMigrationFromClassPathRelative();
                boolean wait = false;
                for (File f : this.deleteme) {
                    if (!f.isFile()) continue;
                    wait = true;
                    break;
                }
                if (wait) {
                    Thread.sleep(5000L);
                    for (File f : this.deleteme) {
                        if (!f.isFile()) continue;
                        throw new Exception("File should be gone " + f);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                LogV3.log(e);
                throw e;
            }
            catch (Throwable throwable) {
                boolean wait = false;
                for (File f : this.deleteme) {
                    if (!f.isFile()) continue;
                    wait = true;
                    break;
                }
                if (wait) {
                    Thread.sleep(5000L);
                    for (File f : this.deleteme) {
                        if (!f.isFile()) continue;
                        throw new Exception("File should be gone " + f);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMigrationFromClassPathRelative() throws Exception {
        try {
            File res = Application.getResource("testRelative.json");
            URL location = TestConfigInterface.class.getClassLoader().getResource(TestConfigInterface.class.getName().replace(".", "/") + ".class");
            File classLocation = new File(location.toURI()).getParentFile();
            String rel = org.appwork.utils.Files.getRelativePath(Application.getResource(""), res);
            long now = System.currentTimeMillis() + 193219L;
            File root = this.deleteAfterTest(new File(classLocation, rel));
            root.delete();
            IO.secureWrite(root, "{\"test\":" + now + "}", null);
            File array = this.deleteAfterTest(new File(classLocation, rel.replace(".json", "") + ".array.json"));
            array.delete();
            IO.secureWrite(array, "[\"fromfile2\"]", null);
            TestConfigInterface storageFromClassPath = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.CLASSPATH_RELATIVE})).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfile2"});
            File target = this.deleteAfterTest(Application.getResource("testRelativeFromFallback.json"));
            target.delete();
            TestConfigInterface storageFromClassPathFallBack = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, target, res).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.CLASSPATH_RELATIVE})).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(target.isFile()).is(false);
            FlexiConfigFromJsonConfigBuilder.get(storageFromClassPathFallBack).writeToDisk();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(target.isFile()).is(true);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfile2"});
            FlexiConfigFromJsonConfigBuilder.get(storageFromClassPathFallBack).setAutoWriteEnabled(false);
        }
        finally {
            this.deleteFiles();
        }
    }

    public void deleteFiles() throws Exception {
        for (File f : this.deleteme) {
            if (!f.isFile()) continue;
            Files.delete(f.toPath());
            FlexiConfigFromJsonConfigBuilderTest.assertThat(f.isFile()).is(false);
        }
    }

    private File deleteAfterTest(File file) {
        this.deleteme.add(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMigrationFromClassPathRoot() throws URISyntaxException, IOException, Exception {
        try {
            File res = this.deleteAfterTest(Application.getResource("test.json"));
            URL location = TestConfigInterface.class.getProtectionDomain().getCodeSource().getLocation();
            File classLocation = new File(location.toURI());
            String rel = org.appwork.utils.Files.getRelativePath(Application.getResource(""), res);
            long now = System.currentTimeMillis() + 199L;
            File file = this.deleteAfterTest(new File(classLocation, rel));
            file.delete();
            IO.secureWrite(file, "{\"test\":" + now + "}", null);
            file = this.deleteAfterTest(new File(classLocation, rel.replace(".json", "") + ".array.json"));
            file.delete();
            IO.secureWrite(file, "[\"fromfile2\"]", null);
            TestConfigInterface storageFromClassPath = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.CLASSPATH_ROOT})).setAutoWriteEnabled(false)).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfile2"});
            File target = this.deleteAfterTest(Application.getResource("testRelativeFromFallback2.json"));
            target.delete();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(target.isFile()).is(false);
            TestConfigInterface storageFromClassPathFallBack = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, target, res).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.CLASSPATH_ROOT})).setAutoWriteEnabled(false)).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(target.isFile()).is(false);
            FlexiConfigFromJsonConfigBuilder.get(storageFromClassPathFallBack).writeToDisk();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(target.isFile()).is(true);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfile2"});
        }
        finally {
            this.deleteFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMigrationFromDisk() throws Exception {
        try {
            File res = Application.getResource("test.json");
            long now = System.currentTimeMillis();
            File root = this.deleteAfterTest(new File(res.getAbsolutePath()));
            root.delete();
            IO.secureWrite(root, "{\"test\":" + now + "}", null);
            File array = this.deleteAfterTest(new File(res.getAbsolutePath().replace(".json", "") + ".array.json"));
            array.delete();
            IO.secureWrite(array, "[\"fromfile\"]", null);
            FlexiConfigBuilder builder = ((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.DISK})).setAutoWriteEnabled(false);
            TestConfigInterface storage = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)builder).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storage.getTest()).isNumber(now);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storage.getArray()).equalsDeep(new String[]{"fromfile"});
            IO.secureWrite(this.deleteAfterTest(Application.getResource("testFallback.json")), "{}", null);
            IO.secureWrite(this.deleteAfterTest(Application.getResource("testFallback.array.json")), "null", null);
            res = this.deleteAfterTest(Application.getResource("notavailable.json"));
            res.delete();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(res.isFile()).is(false);
            FlexiConfigBuilder builderFallBack = ((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, Application.getResource("testFallback.json")).setAutoWriteEnabled(false)).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.DISK});
            TestConfigInterface storageFallback = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)builderFallBack).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFallback.getTest()).isNumber(12345);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storageFallback.getArray()).equalsDeep(null);
            ((FlexiConfigFromJsonConfigBuilder)builderFallBack).writeToDisk();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(res.isFile()).is(true);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(Application.getResource("testFallback.array.json").isFile()).is(false);
            res = this.deleteAfterTest(Application.getResource("test.json"));
            storage.setTest(12L);
            FlexiConfigBuilder<?> builder2 = FlexiConfigBuilder.get(storage);
            builder2.writeToDisk();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(array.isFile()).is(false);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(root.isFile()).is(true);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(builder).is(builder2);
            TestConfigInterface storage2 = (TestConfigInterface)((FlexiConfigFromJsonConfigBuilder)((FlexiConfigFromJsonConfigBuilder)new FlexiConfigFromJsonConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res).setAutoWriteEnabled(false)).setReadSources(new FlexiConfigBuilder.Source[]{FlexiConfigBuilder.Source.DISK})).setAutoWriteEnabled(false).getStorage();
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storage2.getTest()).isNumber(12);
            FlexiConfigFromJsonConfigBuilderTest.assertThat(storage2.getArray()).equalsDeep(new String[]{"fromfile"});
        }
        finally {
            this.deleteFiles();
        }
    }

    public static void main(String[] args) {
        FlexiConfigFromJsonConfigBuilderTest.run();
    }

    public static interface TestConfigInterface
    extends FlexiStorableInterface {
        @FlexiInterfaceDefault(value="12345")
        public long getTest();

        public void setTest(long var1);

        @FlexiInterfaceDefault(value="[]")
        public String[] getArray();

        public void setArray(String[] var1);
    }
}

