/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.config.ide;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.config.FlexiConfigBuilder;
import org.appwork.storage.flexijson.config.FlexiConfigListener;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefault;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.reflection.CompiledType;

public class FlexiConfigBuilderTest
extends AWTest {
    private ArrayList<File> deleteme = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTest() throws Exception {
        try {
            this.testEventSenderAndSubEventSender();
            try {
                new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, new File("test"), new File[0]).setReadSources(FlexiConfigBuilder.Source.DISK);
                throw new Exception("Expected an IllegalArgumentException because test does not end with .json");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.testDamagedJson();
                this.testReadFromDisk();
                this.testReadFromClassPathRoot();
                this.testReadFromClassPathRelative();
                boolean allGone = true;
                for (File f : this.deleteme) {
                    if (!f.isFile()) continue;
                    allGone = false;
                }
                if (!allGone) {
                    Thread.sleep(5000L);
                    for (File f : this.deleteme) {
                        if (!f.isFile()) continue;
                        throw new Exception("File should be gone " + f);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            boolean allGone = true;
            for (File f : this.deleteme) {
                if (!f.isFile()) continue;
                allGone = false;
            }
            if (!allGone) {
                Thread.sleep(5000L);
                for (File f : this.deleteme) {
                    if (!f.isFile()) continue;
                    throw new Exception("File should be gone " + f);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventSenderAndSubEventSender() throws Exception {
        try {
            File res = this.deleteAfterTest(Application.getResource("test.json"));
            res.delete();
            FlexiConfigBuilderTest.assertThat(res.isFile()).is(false);
            final AtomicInteger count = new AtomicInteger();
            final AtomicInteger count2 = new AtomicInteger();
            FlexiConfigBuilder builder = new FlexiConfigBuilder<TestInterfaceWithSubInterfaces>(TestInterfaceWithSubInterfaces.class, res, new File[0]){

                @Override
                public void onInterfaceValueSet(Object storage, String key, Object oldValue, Object newValue) {
                    super.onInterfaceValueSet(storage, key, oldValue, newValue);
                    count.incrementAndGet();
                }
            }.setReadSources(FlexiConfigBuilder.Source.DISK);
            builder.getEventSender().addListener(new FlexiConfigListener(){

                @Override
                public void onValueModified(FlexiConfigBuilder builder, Object storage, String key, Object oldValue, Object newValue) {
                    count2.incrementAndGet();
                }
            });
            TestInterfaceWithSubInterfaces storage = (TestInterfaceWithSubInterfaces)builder.getStorage();
            TestConfigInterface object = storage.getObject();
            int triggersCallback = 0;
            FlexiConfigBuilderTest.assertThat(object.getTest()).isNumber(12345);
            object.setTest(123L);
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(count2.get());
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(++triggersCallback);
            FlexiConfigBuilderTest.assertThat(object.getTest()).isNumber(123);
            object = (TestConfigInterface)new FlexiJSonMapper().jsonToObject((FlexiJSonNode)new FlexiJSonObject(), CompiledType.create(TestConfigInterface.class));
            FlexiConfigBuilderTest.assertThat(object.getTest()).isNumber(12345);
            storage.setObject(object);
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(count2.get());
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(++triggersCallback);
            object.setTest(1234L);
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(count2.get());
            FlexiConfigBuilderTest.assertThat(count.get()).isNumber(++triggersCallback);
            FlexiConfigBuilder<?> builder2 = FlexiConfigBuilder.get(storage);
            builder2.writeToDisk();
        }
        finally {
            this.deleteFiles();
        }
    }

    public void deleteFiles() {
        for (File f : this.deleteme) {
            f.delete();
        }
        this.deleteme.clear();
    }

    private File deleteAfterTest(File file) {
        this.deleteme.add(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDamagedJson() throws Exception {
        try {
            File res = Application.getResource("test.json");
            long now = System.currentTimeMillis();
            File root = this.deleteAfterTest(new File(res.getAbsolutePath()));
            root.delete();
            IO.secureWrite(root, "{\"test\":" + now + ",\"array\":[\"fromfile\"]", IO.SYNC.META_AND_DATA);
            final FlexiConfigBuilder<TestConfigInterface> builder = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]).setReadSources(FlexiConfigBuilder.Source.DISK);
            new AWTest.AssertAnException<FlexiParserException>(){

                @Override
                public void run() throws Exception {
                    builder.setAutoWriteEnabled(false).getStorage();
                }
            }.start();
            FlexiConfigBuilder<TestConfigInterface> builder3 = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]){

                @Override
                public FlexiJSONParser createParser(String json) {
                    FlexiJSONParser ret = super.createParser(json);
                    ret.addIgnoreIssues(new Object[]{ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG});
                    return ret;
                }
            };
            TestConfigInterface storage = (TestConfigInterface)builder3.setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storage.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storage.getArray()).equalsDeep(new String[]{"fromfile"});
            root = this.deleteAfterTest(Application.getResource("testFallback.json"));
            IO.secureWrite(root, "{array:null}", null);
            res = this.deleteAfterTest(Application.getResource("notavailable.json"));
            res.delete();
            FlexiConfigBuilderTest.assertThat(res.isFile()).is(false);
            FlexiConfigBuilder<TestConfigInterface> builderFallBack = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[]{root}){

                @Override
                public FlexiJSONParser createParser(String json) {
                    FlexiJSONParser ret = super.createParser(json);
                    ret.addIgnoreIssues(new Object[]{ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES});
                    return ret;
                }
            };
            TestConfigInterface storageFallback = (TestConfigInterface)builderFallBack.setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storageFallback.getTest()).isNumber(12345);
            FlexiConfigBuilderTest.assertThat(storageFallback.getArray()).equalsDeep(null);
            builderFallBack.writeToDisk();
            FlexiConfigBuilderTest.assertThat(res.isFile()).is(true);
            FlexiConfigBuilderTest.assertThat(root.isFile()).is(false);
            res = this.deleteAfterTest(Application.getResource("test.json"));
            storage.setTest(12L);
            FlexiConfigBuilder<?> builder2 = FlexiConfigBuilder.get(storage);
            builder2.writeToDisk();
            FlexiConfigBuilderTest.assertFileExists(res);
            FlexiConfigBuilderTest.assertThat(builder3).is(builder2);
            TestConfigInterface storage2 = (TestConfigInterface)new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]){

                @Override
                public FlexiJSONParser createParser(String json) {
                    FlexiJSONParser ret = super.createParser(json);
                    ret.addIgnoreIssues(new Object[]{ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG});
                    return ret;
                }
            }.setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storage2.getTest()).isNumber(12);
            FlexiConfigBuilderTest.assertThat(storage2.getArray()).equalsDeep(new String[]{"fromfile"});
        }
        finally {
            this.deleteFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFromClassPathRelative() throws Exception {
        try {
            File res = this.deleteAfterTest(Application.getResource("testRelative.json"));
            URL location = TestConfigInterface.class.getClassLoader().getResource(TestConfigInterface.class.getName().replace(".", "/") + ".class");
            File classLocation = new File(location.toURI()).getParentFile();
            String rel = Files.getRelativePath(Application.getResource(""), res);
            long now = System.currentTimeMillis() + 193219L;
            File root = this.deleteAfterTest(new File(classLocation, rel));
            root.delete();
            IO.secureWrite(root, "{\"test\":" + now + ",\"array\":[\"frsd2omfil3e2\"]}", null);
            TestConfigInterface storageFromClassPath = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]).setReadSources(FlexiConfigBuilder.Source.CLASSPATH_RELATIVE).setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"frsd2omfil3e2"});
            File target = this.deleteAfterTest(Application.getResource("testRelativeFromFallback.json"));
            target.delete();
            TestConfigInterface storageFromClassPathFallBack = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, target, res).setReadSources(FlexiConfigBuilder.Source.CLASSPATH_RELATIVE).setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(target.isFile()).is(false);
            FlexiConfigBuilder.get(storageFromClassPathFallBack).writeToDisk();
            FlexiConfigBuilderTest.assertThat(target.isFile()).is(true);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"frsd2omfil3e2"});
        }
        finally {
            this.deleteFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFromClassPathRoot() throws URISyntaxException, IOException, Exception {
        try {
            File res = this.deleteAfterTest(Application.getResource("test.json"));
            URL location = TestConfigInterface.class.getProtectionDomain().getCodeSource().getLocation();
            File classLocation = new File(location.toURI());
            String rel = Files.getRelativePath(Application.getResource(""), res);
            long now = System.currentTimeMillis() + 199L;
            File file = this.deleteAfterTest(new File(classLocation, rel));
            file.delete();
            IO.secureWrite(file, "{\"test\":" + now + ",\"array\":[\"fromfil3e2\"]}", null);
            TestConfigInterface storageFromClassPath = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]).setReadSources(FlexiConfigBuilder.Source.CLASSPATH_ROOT).setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfil3e2"});
            File target = this.deleteAfterTest(Application.getResource("testRelativeFromFallback2.json"));
            target.delete();
            FlexiConfigBuilderTest.assertThat(target.isFile()).is(false);
            TestConfigInterface storageFromClassPathFallBack = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, target, res).setReadSources(FlexiConfigBuilder.Source.CLASSPATH_ROOT).setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(target.isFile()).is(false);
            FlexiConfigBuilder.get(storageFromClassPathFallBack).writeToDisk();
            FlexiConfigBuilderTest.assertThat(target.isFile()).is(true);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storageFromClassPath.getArray()).equalsDeep(new String[]{"fromfil3e2"});
        }
        finally {
            this.deleteFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFromDisk() throws Exception {
        try {
            File res = this.deleteAfterTest(Application.getResource("test.json"));
            long now = System.currentTimeMillis();
            File root = new File(res.getAbsolutePath());
            root.delete();
            this.deleteme.add(root);
            IO.secureWrite(root, "{\"test\":" + now + ",\"array\":[\"fromfile\"]}", null);
            FlexiConfigBuilder<TestConfigInterface> builder = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]).setReadSources(FlexiConfigBuilder.Source.DISK);
            TestConfigInterface storage = builder.setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storage.getTest()).isNumber(now);
            FlexiConfigBuilderTest.assertThat(storage.getArray()).equalsDeep(new String[]{"fromfile"});
            IO.secureWrite(this.deleteAfterTest(Application.getResource("testFallback.json")), "{\"array\":null}", null);
            res = this.deleteAfterTest(Application.getResource("notavailable.json"));
            res.delete();
            FlexiConfigBuilderTest.assertThat(res.isFile()).is(false);
            FlexiConfigBuilder<TestConfigInterface> builderFallBack = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, Application.getResource("testFallback.json")).setReadSources(FlexiConfigBuilder.Source.DISK);
            TestConfigInterface storageFallback = builderFallBack.setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storageFallback.getTest()).isNumber(12345);
            FlexiConfigBuilderTest.assertThat(storageFallback.getArray()).equalsDeep(null);
            builderFallBack.writeToDisk();
            FlexiConfigBuilderTest.assertThat(res.isFile()).is(true);
            FlexiConfigBuilderTest.assertThat(Application.getResource("testFallback.json").isFile()).is(false);
            res = this.deleteAfterTest(Application.getResource("test.json"));
            storage.setTest(12L);
            FlexiConfigBuilder<?> builder2 = FlexiConfigBuilder.get(storage);
            builder2.writeToDisk();
            FlexiConfigBuilderTest.assertThat(root.isFile()).is(true);
            FlexiConfigBuilderTest.assertThat(builder).is(builder2);
            TestConfigInterface storage2 = new FlexiConfigBuilder<TestConfigInterface>(TestConfigInterface.class, res, new File[0]).setReadSources(FlexiConfigBuilder.Source.DISK).setAutoWriteEnabled(false).getStorage();
            FlexiConfigBuilderTest.assertThat(storage2.getTest()).isNumber(12);
            FlexiConfigBuilderTest.assertThat(storage2.getArray()).equalsDeep(new String[]{"fromfile"});
        }
        finally {
            this.deleteFiles();
        }
    }

    public static void main(String[] args) {
        FlexiConfigBuilderTest.run();
    }

    public static interface TestInterfaceWithSubInterfaces
    extends FlexiStorableInterface {
        @FlexiInterfaceDefault(value="{}")
        public TestConfigInterface getObject();

        public void setObject(TestConfigInterface var1);
    }

    public static interface SubInterface
    extends FlexiStorableInterface {
        @FlexiInterfaceDefault(value="12345")
        public long getTest();

        public void setTest(long var1);

        @FlexiInterfaceDefault(value="[]")
        public String[] getArray();

        public void setArray(String[] var1);
    }

    public static interface TestConfigInterface
    extends FlexiStorableInterface {
        @FlexiInterfaceDefault(value="12345")
        public long getTest();

        public void setTest(long var1);

        @FlexiInterfaceDefault(value="[]")
        public String[] getArray();

        public void setArray(String[] var1);
    }
}

