/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.config.FlexiConfigBuilder;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.reflection.CompiledType;

public class FlexiConfigFromJsonConfigBuilder<T>
extends FlexiConfigBuilder<T> {
    public FlexiConfigFromJsonConfigBuilder(Class<T> class1, File target) {
        super(class1, target, new File[0]);
    }

    public FlexiConfigFromJsonConfigBuilder(Class<T> class1, File target, File ... fallbacks) {
        super(class1, target, fallbacks);
    }

    @Override
    public FlexiConfigFromJsonConfigBuilder<T> setAutoWriteEnabled(boolean autoWriteEnabled) {
        return (FlexiConfigFromJsonConfigBuilder)super.setAutoWriteEnabled(autoWriteEnabled);
    }

    public static FlexiConfigFromJsonConfigBuilder<?> get(FlexiStorableInterface storage) {
        InterfaceStorage handler = FlexiConfigFromJsonConfigBuilder.getStorage(storage);
        if (handler == null) {
            return null;
        }
        for (Object l : handler.getEventSender().getListener()) {
            if (!(l instanceof FlexiConfigFromJsonConfigBuilder)) continue;
            return (FlexiConfigFromJsonConfigBuilder)l;
        }
        return null;
    }

    protected ConfigBridgeInvocationHandler createRootInterfaceStorageHandler(FlexiJSonMapper mapper, CompiledType cType, FlexiJSonObject obj) throws NoSuchMethodException {
        return new ConfigBridgeInvocationHandler(mapper, cType, obj, this);
    }

    @Override
    public FlexiConfigFromJsonConfigBuilder<T> setReadSources(FlexiConfigBuilder.Source ... readSources) {
        return (FlexiConfigFromJsonConfigBuilder)super.setReadSources(readSources);
    }

    @Override
    protected FlexiJSonObject resourceToObject(File resource, FlexiConfigBuilder.Source source) throws IOException, FlexiParserException {
        try {
            ClassCache classCache = ClassCache.getClassCache(this.targetInterface);
            Set<String> keys = classCache.getKeys();
            FlexiJSonObject node = (FlexiJSonObject)this.readSubNode(resource, null, source);
            if (node == null) {
                node = new FlexiJSonObject();
            }
            for (String key : keys) {
                FlexiJSonNode subNode;
                Property p = classCache.getProperty(key);
                if (p == null || !p.type.isContainer() || (subNode = this.readSubNode(resource, key, source)) == null) continue;
                node.add(new KeyValueElement(node, key, subNode));
            }
            return node;
        }
        catch (SecurityException e1) {
            throw new WTFException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new WTFException(e1);
        }
    }

    private FlexiJSonNode readSubNode(File resource, String key, FlexiConfigBuilder.Source source) throws IOException, FlexiParserException {
        switch (source) {
            case CLASSPATH_ROOT: {
                String rel = Files.getRelativePath(Application.getResource(""), resource);
                String path = key == null ? rel + ".json" : rel + "." + key + ".json";
                URL url = this.targetInterface.getClassLoader().getResource(path);
                if (url != null) {
                    String json = IO.readURLToString(url);
                    return this.createParser(json).parse();
                }
            }
            case CLASSPATH_RELATIVE: {
                String rel = Files.getRelativePath(Application.getResource(""), resource);
                String path = key == null ? rel + ".json" : rel + "." + key + ".json";
                URL url = this.targetInterface.getResource(path);
                if (url == null) break;
                String json = IO.readURLToString(url);
                return this.createParser(json).parse();
            }
            case DISK: {
                File file;
                File file2 = file = key == null ? new File(resource.getAbsolutePath() + ".json") : new File(resource.getAbsolutePath() + "." + key + ".json");
                if (!file.isFile()) break;
                String json = IO.readFileToString(file);
                return this.createParser(json).parse();
            }
            default: {
                DebugMode.throwInIDEElse(new WTFException("All option should be handled here"));
            }
        }
        return null;
    }

    @Override
    public void writeToDisk() throws FlexiMapperException, IOException {
        super.writeToDisk();
        if (this.getSource() == FlexiConfigBuilder.Source.DISK) {
            this.deleteByResource(this.targetPath);
            if (this.isDeleteFallbacksOnWrite() && this.fallbacks != null) {
                for (File targetPath : this.fallbacks) {
                    this.deleteByResource(targetPath);
                }
            }
        }
    }

    private void deleteByResource(File targetPath) {
        File[] files;
        final File resource = new File(targetPath.getAbsolutePath().replaceAll((CrossSystem.isWindows() ? "(?i)" : "") + "\\.json$", ""));
        final File root = resource.getParentFile();
        for (File file : files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String rel = Files.getRelativePath(root, file);
                return StringUtils.startsWithCaseInsensitive(rel, resource.getName() + ".");
            }
        })) {
            String rel;
            if (file.equals(this.targetPath)) continue;
            Pattern pattern = Pattern.compile("^" + Pattern.quote(resource.getName()) + (CrossSystem.isWindows() ? "(?i)" : "") + "\\.(.*?)\\.?json$", 2);
            Matcher matcher = pattern.matcher(rel = Files.getRelativePath(root, file));
            if (!matcher.find()) continue;
            String key = matcher.group(1);
            LogV3.info("Delete deprecated/fallback config file: " + file);
            file.delete();
        }
    }

    public static class ConfigBridgeInvocationHandler
    extends InterfaceStorage {
        public ConfigBridgeInvocationHandler(FlexiJSonMapper mapper, CompiledType cType, FlexiJSonObject obj, FlexiConfigBuilder<?> flexiConfigBuilder) throws SecurityException, NoSuchMethodException {
            super(mapper, cType, obj);
        }

        @Override
        protected KeyValueElement getElementByKey(String key) {
            KeyValueElement ret = super.getElementByKey(key);
            if (ret == null) {
                for (KeyValueElement e : this.getBackendNode().getElements()) {
                    if (!StringUtils.equalsIgnoreCase(e.getKey(), key)) continue;
                    return e;
                }
            }
            return ret;
        }
    }
}

