/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;

public class KeyValueElement {
    private String key;
    public final Object path;
    private FlexiJSonObject parent;
    private FlexiJSonNode value;
    private FlexiJSonComments commentsBeforeKey;
    private FlexiJSonComments commentsAfterKey;
    private int order = 0;

    public String getKey() {
        return this.key;
    }

    public KeyValueElement(FlexiJSonObject parent, Object path, String key, FlexiJSonNode value) {
        this.key = key;
        this.value = value;
        this.path = path;
        this.parent = parent;
    }

    public KeyValueElement(FlexiJSonObject parent, String key, FlexiJSonNode value) {
        this(parent, null, key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.commentsBeforeKey != null) {
            for (FlexiCommentJsonNode c : this.commentsBeforeKey) {
                sb.append(c);
            }
        }
        sb.append(this.key);
        if (this.commentsAfterKey != null) {
            for (FlexiCommentJsonNode c : this.commentsAfterKey) {
                sb.append(c);
            }
        }
        sb.append("=");
        sb.append(this.value);
        return sb.toString();
    }

    public KeyValueElement(Object path) {
        this.path = path;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FlexiJSonNode getValue() {
        return this.value;
    }

    public void setValue(FlexiJSonNode value) {
        this.value = value;
    }

    public FlexiJSonComments getCommentsBeforeKey() {
        return this.commentsBeforeKey;
    }

    public void setCommentsBeforeKey(FlexiJSonComments commentsBeforeKey) {
        this.commentsBeforeKey = commentsBeforeKey;
        if (commentsBeforeKey != null) {
            commentsBeforeKey.setParent(this.value);
            for (FlexiCommentJsonNode c : commentsBeforeKey) {
                c.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_KEY);
            }
        }
    }

    public FlexiJSonComments getCommentsAfterKey() {
        return this.commentsAfterKey;
    }

    public void setCommentsAfterKey(FlexiJSonComments commentsAfterKey) {
        this.commentsAfterKey = commentsAfterKey;
        if (commentsAfterKey != null) {
            commentsAfterKey.setParent(this.value);
            for (FlexiCommentJsonNode c : commentsAfterKey) {
                c.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_KEY);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void addCommentsBeforeKey(FlexiJSonComments commentsBeforeKey2, boolean append) {
        if (commentsBeforeKey2 == null) {
            return;
        }
        commentsBeforeKey2.setParent(this.value);
        for (FlexiCommentJsonNode c : commentsBeforeKey2) {
            c.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_KEY);
        }
        if (this.commentsBeforeKey == null) {
            this.commentsBeforeKey = commentsBeforeKey2;
        } else if (append) {
            this.commentsBeforeKey.addAll(commentsBeforeKey2);
        } else {
            this.commentsBeforeKey.addAll(0, commentsBeforeKey2);
        }
    }

    public void addCommentsAfterKey(FlexiJSonComments c) {
        if (c == null) {
            return;
        }
        c.setParent(this.value);
        for (FlexiCommentJsonNode comment : c) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_KEY);
        }
        if (this.commentsAfterKey == null) {
            this.commentsAfterKey = c;
        } else {
            this.commentsAfterKey.addAll(c);
        }
    }

    public boolean hasComments() {
        if (this.commentsAfterKey != null && this.commentsAfterKey.size() > 0) {
            return true;
        }
        return this.commentsBeforeKey != null && this.commentsBeforeKey.size() > 0;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

