/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandler;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandlerImpl;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandlerListener;

public class PropertyHandlerProviderBridge<T>
implements ValueProvider<T> {
    public final PropertyHandler<Object, T> keyHandler;
    private static WeakHashMap<ValueProviderListener<?>, Set<ListenerBridge<?>>> REFS_LINK = new WeakHashMap();

    public PropertyHandlerProviderBridge(PropertyHandler<?, T> propertyHandler) {
        this.keyHandler = propertyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ValueProviderListener<T> listener) {
        Object object = this.keyHandler.getEventSender().LOCK;
        synchronized (object) {
            ListenerBridge<T> newListener = this.searchListener(listener);
            if (newListener != null) {
                WeakHashMap<ValueProviderListener<?>, Set<ListenerBridge<?>>> weakHashMap = REFS_LINK;
                synchronized (weakHashMap) {
                    Set<ListenerBridge<?>> set = REFS_LINK.get(listener);
                    if (set != null) {
                        set.remove(newListener);
                        if (set.size() == 0) {
                            REFS_LINK.remove(listener);
                        }
                    }
                }
                this.keyHandler.getEventSender().removeListener(newListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ValueProviderListener<T> listener, boolean weak) {
        Object object = this.keyHandler.getEventSender().LOCK;
        synchronized (object) {
            ListenerBridge<T> newListener = this.searchListener(listener);
            if (newListener == null) {
                newListener = new ListenerBridge<T>(this, listener);
                WeakHashMap<ValueProviderListener<?>, Set<ListenerBridge<?>>> weakHashMap = REFS_LINK;
                synchronized (weakHashMap) {
                    Set<ListenerBridge<?>> set = REFS_LINK.get(listener);
                    if (set == null) {
                        set = new HashSet();
                    }
                    set.add(newListener);
                    REFS_LINK.put(listener, set);
                }
            }
            if (weak) {
                ((ListenerBridge)newListener).strongRef = null;
            } else {
                ((ListenerBridge)newListener).strongRef = listener;
            }
            this.keyHandler.getEventSender().addListener(newListener, weak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerBridge<T> searchListener(ValueProviderListener<T> listener) {
        Object object = this.keyHandler.getEventSender().LOCK;
        synchronized (object) {
            ListenerBridge newListener = null;
            for (PropertyHandlerListener l : this.keyHandler.getEventSender().getListener()) {
                if (!(l instanceof ListenerBridge) || ((ListenerBridge)l).listener != listener) continue;
                newListener = (ListenerBridge)l;
                break;
            }
            return newListener;
        }
    }

    @Override
    public T get() {
        return this.keyHandler.get();
    }

    @Override
    public void set(T value) {
        this.keyHandler.set(value);
    }

    @Override
    public <AnnoType extends Annotation> List<AnnoType> getAnnotations(Class<AnnoType> type) {
        return this.keyHandler.getAnnotations(type);
    }

    private static class ListenerBridge<T>
    implements PropertyHandlerListener<Object, T> {
        public final WeakReference<ValueProviderListener<T>> listener;
        private final PropertyHandlerProviderBridge<T> owner;
        private ValueProviderListener<T> strongRef;

        public ListenerBridge(PropertyHandlerProviderBridge<T> providerBridge, ValueProviderListener<T> listener2) {
            this.owner = providerBridge;
            this.listener = new WeakReference<ValueProviderListener<ValueProviderListener<T>>>(listener2);
        }

        public ValueProviderListener<T> getListener() {
            ValueProviderListener sr = this.strongRef;
            return sr == null ? (ValueProviderListener)this.listener.get() : sr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup(PropertyHandlerImpl<Object, T> property) {
            property.getEventSender().removeListener(this);
            WeakHashMap weakHashMap = REFS_LINK;
            synchronized (weakHashMap) {
                REFS_LINK.isEmpty();
            }
        }

        @Override
        public void onInterfaceValueSet(Object storage, PropertyHandlerImpl<Object, T> property, T oldValue, T newValue) {
            ValueProviderListener<T> actual = this.getListener();
            if (actual != null) {
                actual.onValueModified(this.owner, newValue);
            } else {
                this.cleanup(property);
            }
        }
    }
}

